/*
 * Decompiled with CFR 0.152.
 */
package ai.grazie.rules;

import ai.grazie.rules.NodeRuleMatch;
import ai.grazie.rules.RuleMatch;
import ai.grazie.rules.document.Metadata;
import ai.grazie.rules.tree.NodeMatch;
import ai.grazie.rules.tree.TextRange;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class MatchingResult {
    private static final Comparator<RuleMatch> COMPARING_BY_REPORTED_RANGE = Comparator.comparing(rm -> rm.reportedRanges().getFirst().start());
    public static final MatchingResult EMPTY = new MatchingResult(List.of(), List.of(), Metadata.EMPTY);
    public final List<RuleMatch> matches;
    public final Metadata metadata;
    public final List<OverriddenMatch> overridden;

    public static MatchingResult from(List<? extends RuleMatch> rawMatches) {
        if (rawMatches.isEmpty()) {
            return EMPTY;
        }
        ArrayList<RuleMatch> matches = new ArrayList<RuleMatch>();
        ArrayList<OverriddenMatch> overridden = new ArrayList<OverriddenMatch>();
        Metadata metadata = Metadata.EMPTY;
        for (RuleMatch ruleMatch : rawMatches) {
            NodeMatch nm;
            if (ruleMatch instanceof NodeRuleMatch) {
                NodeRuleMatch nrm = (NodeRuleMatch)ruleMatch;
                v0 = nrm.result();
            } else {
                v0 = nm = null;
            }
            if (nm != null && nm.preventedBy == null && !nm.metadata.isEmpty()) {
                metadata = metadata.with(nm.metadata);
            }
            if (nm != null && nm.preventedBy != null) {
                overridden.add(new OverriddenMatch(ruleMatch, nm.preventedBy));
                continue;
            }
            if (ruleMatch.message() == null) continue;
            MatchingResult.addNonConflictingMatch(matches, ruleMatch, overridden);
        }
        return MatchingResult.toResult(matches, overridden, metadata);
    }

    public static MatchingResult concat(Iterable<MatchingResult> mrs) {
        ArrayList<RuleMatch> matches = new ArrayList<RuleMatch>();
        ArrayList<OverriddenMatch> overridden = new ArrayList<OverriddenMatch>();
        Metadata[] metadata = new Metadata[]{Metadata.EMPTY};
        for (MatchingResult each : mrs) {
            if (each.isEmpty()) continue;
            for (RuleMatch match : each.matches) {
                MatchingResult.addNonConflictingMatch(matches, match, overridden);
            }
            overridden.addAll(each.overridden);
            metadata[0] = metadata[0].with(each.metadata);
        }
        return MatchingResult.toResult(matches, overridden, metadata[0]);
    }

    private static MatchingResult toResult(List<RuleMatch> matches, List<OverriddenMatch> overridden, Metadata metadata) {
        if (matches.isEmpty() && overridden.isEmpty() && metadata.isEmpty()) {
            return EMPTY;
        }
        return new MatchingResult(matches, overridden, metadata);
    }

    private static void addNonConflictingMatch(List<RuleMatch> matches, RuleMatch match, List<OverriddenMatch> overridden) {
        if (!matches.isEmpty()) {
            List<TextRange> ranges = match.reportedRanges();
            for (RuleMatch prev : matches) {
                if (!MatchingResult.overlaps(prev.reportedRanges(), ranges)) continue;
                overridden.add(new OverriddenMatch(match, prev.rule().id));
                return;
            }
        }
        matches.add(match);
    }

    private static boolean overlaps(List<TextRange> ranges1, List<TextRange> ranges2) {
        return ranges1.stream().anyMatch(r1 -> ranges2.stream().anyMatch(r2 -> r1.overlaps((TextRange)r2)));
    }

    private MatchingResult(List<RuleMatch> matches, List<OverriddenMatch> overridden, Metadata metadata) {
        this.matches = MatchingResult.sort(matches);
        this.overridden = overridden;
        this.metadata = metadata;
    }

    private static List<RuleMatch> sort(List<RuleMatch> matches) {
        return matches.size() <= 1 ? Collections.unmodifiableList(matches) : matches.stream().sorted(COMPARING_BY_REPORTED_RANGE).toList();
    }

    public boolean isEmpty() {
        return this.matches.isEmpty() && this.overridden.isEmpty() && this.metadata.isEmpty();
    }

    public MatchingResult withoutMetadata() {
        return MatchingResult.toResult(this.matches, this.overridden, Metadata.EMPTY);
    }

    public String toString() {
        return "MatchingResult{matches=" + String.valueOf(this.matches) + ", metadata=" + String.valueOf(this.metadata) + ", overridden=" + String.valueOf(this.overridden) + "}";
    }

    public record OverriddenMatch(RuleMatch match, String overriddenBy) {
        @Override
        public String toString() {
            return this.match.rule().id + "(" + this.match.message() + ") by " + this.overriddenBy;
        }
    }
}

