/*
 * Decompiled with CFR 0.152.
 */
package ai.grazie.rules.common;

import ai.grazie.nlp.langs.alphabet.Alphabet;
import com.carrotsearch.hppc.CharCharHashMap;
import com.carrotsearch.hppc.CharObjectHashMap;
import com.carrotsearch.hppc.CharObjectMap;
import org.jetbrains.annotations.Nullable;

public class Diacritics {
    private static final CharCharHashMap dia2NormalChars = new CharCharHashMap();
    public static final CharObjectMap<String> normal2DiacriticChars = new CharObjectHashMap();

    public static char removeDiacritic(char c) {
        return dia2NormalChars.getOrDefault(c, c);
    }

    public static boolean isDiacritic(char c) {
        return dia2NormalChars.containsKey(c);
    }

    public static String removeDiacritics(String text) {
        return Diacritics.removeDiacritics(text, null);
    }

    public static String removeDiacritics(String text, @Nullable Alphabet toPreserve) {
        StringBuilder result = null;
        for (int i = 0; i < text.length(); ++i) {
            char c = text.charAt(i);
            char normal = dia2NormalChars.get(c);
            if (normal == '\u0000' || toPreserve != null && toPreserve.matchEntire((CharSequence)String.valueOf(c))) continue;
            if (result == null) {
                result = new StringBuilder(text);
            }
            result.setCharAt(i, normal);
        }
        return result == null ? text : result.toString();
    }

    static {
        String diacritics = "\u00e0\u00e1\u00e2\u00e3\u00e4\u00e5\u00e7\u00e8\u00e9\u00ea\u00eb\u00ec\u00ed\u00ee\u00ef\u00f1\u00f2\u00f3\u00f4\u00f5\u00f6\u00f8\u00f9\u00fa\u00fb\u00fc\u00fd\u00ff\u0101\u0103\u0105\u0107\u010b\u010d\u010f\u0111\u0113\u0117\u0119\u011b\u011f\u0121\u0123\u0127\u0129\u012b\u012d\u0131\u0137\u013a\u013c\u013e\u0142\u0144\u0146\u0148\u014d\u014f\u0151\u0159\u015b\u015f\u0161\u0163\u0165\u0169\u016b\u016d\u016f\u0173\u017a\u017c\u017e\u01a1\u01b0\u01eb\u0219\u021b\u03cd\u1e0d\u1e0f\u1e11\u1e25\u1e27\u1e29\u1e2f\u1e45\u1e49\u1e5f\u1e63\u1e65\u1e6d\u1e6f\u1e95\u1e96\u1ea1\u1ea3\u1ea5\u1ea7\u1ea9\u1ead\u1eaf\u1eb1\u1eb7\u1ebb\u1ebf\u1ec1\u1ec3\u1ec5\u1ec7\u1ec9\u1ecb\u1ecd\u1ecf\u1ed1\u1ed3\u1ed5\u1ed9\u1edb\u1edd\u1ee3\u1ee5\u1ee7\u1ee9\u1eeb\u1eed\u1eef\u1ef3\u1ef9\u00c0\u00c1\u00c2\u00c3\u00c4\u00c5\u00c7\u00c8\u00c9\u00ca\u00cb\u00cc\u00cd\u00ce\u00cf\u00d1\u00d2\u00d3\u00d4\u00d5\u00d6\u00d8\u00d9\u00da\u00db\u00dc\u00dd\u0178\u0100\u0102\u0104\u0106\u010a\u010c\u010e\u0110\u0112\u0116\u0118\u011a\u011e\u0120\u0122\u0126\u0128\u012a\u012cI\u0136\u0139\u013b\u013d\u0141\u0143\u0145\u0147\u014c\u014e\u0150\u0158\u015a\u015e\u0160\u0162\u0164\u0168\u016a\u016c\u016e\u0172\u0179\u017b\u017d\u01a0\u01af\u01ea\u0218\u021a\u038e\u1e0c\u1e0e\u1e10\u1e24\u1e26\u1e28\u1e2e\u1e44\u1e48\u1e5e\u1e62\u1e64\u1e6c\u1e6e\u1e94\u1ea0\u1ea2\u1ea4\u1ea6\u1ea8\u1eac\u1eae\u1eb0\u1eb6\u1eba\u1ebe\u1ec0\u1ec2\u1ec4\u1ec6\u1ec8\u1eca\u1ecc\u1ece\u1ed0\u1ed2\u1ed4\u1ed8\u1eda\u1edc\u1ee2\u1ee4\u1ee6\u1ee8\u1eea\u1eec\u1eee\u1ef2\u1ef8";
        String normal = "aaaaaaceeeeiiiinoooooouuuuyyaaacccddeeeeggghiiiikllllnnnooorsssttuuuuuzzzouostudddhhhinnrssttzhaaaaaaaaaeeeeeeiiooooooooouuuuuuyyAAAAAACEEEEIIIINOOOOOOUUUUYYAAACCCDDEEEEGGGHIIIIKLLLLNNNOOORSSSTTUUUUUZZZOUOSTUDDDHHHINNRSSTTZAAAAAAAAAEEEEEEIIOOOOOOOOOUUUUUUYY";
        for (int i = 0; i < diacritics.length(); ++i) {
            char dia = diacritics.charAt(i);
            char norm = normal.charAt(i);
            dia2NormalChars.put(dia, norm);
            String s = (String)normal2DiacriticChars.get(norm);
            if (s == null) {
                s = "";
            }
            normal2DiacriticChars.put(norm, (Object)(s + dia));
        }
    }
}

