/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.oracle.generator;

import com.intellij.database.Dbms;
import com.intellij.database.dialects.base.generator.AbstractCodeGenerator;
import com.intellij.database.dialects.base.generator.AbstractScriptGenerator;
import com.intellij.database.dialects.base.generator.ScriptingContext;
import com.intellij.database.dialects.oracle.generator.OraExecuteGenerator;
import com.intellij.database.dialects.oracle.generator.OraNativeDefinitionsGenerator;
import com.intellij.database.dialects.oracle.generator.OraRefreshMatViewGenerator;
import com.intellij.database.dialects.oracle.generator.OraScriptGeneratorHelper;
import com.intellij.database.dialects.oracle.model.OraSequence;
import com.intellij.database.model.basic.BasicElement;
import kotlin.Metadata;
import kotlin.TuplesKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\r\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0014R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0012"}, d2={"Lcom/intellij/database/dialects/oracle/generator/OraScriptGenerator;", "Lcom/intellij/database/dialects/base/generator/AbstractScriptGenerator;", "<init>", "()V", "generatorHelper", "Lcom/intellij/database/dialects/oracle/generator/OraScriptGeneratorHelper;", "getGeneratorHelper", "()Lcom/intellij/database/dialects/oracle/generator/OraScriptGeneratorHelper;", "createNativeDefinitionsGenerator", "Lcom/intellij/database/dialects/base/generator/AbstractCodeGenerator;", "context", "Lcom/intellij/database/dialects/base/generator/ScriptingContext;", "createRefreshingGenerator", "createExecuteGenerator", "createCapsKey", "", "element", "Lcom/intellij/database/model/basic/BasicElement;", "intellij.database.dialects.oracle"})
public final class OraScriptGenerator
extends AbstractScriptGenerator {
    @NotNull
    private final OraScriptGeneratorHelper generatorHelper;

    public OraScriptGenerator() {
        Dbms dbms = Dbms.ORACLE;
        Intrinsics.checkNotNullExpressionValue((Object)dbms, (String)"ORACLE");
        super(dbms);
        this.generatorHelper = OraScriptGeneratorHelper.INSTANCE;
    }

    @NotNull
    public OraScriptGeneratorHelper getGeneratorHelper() {
        return this.generatorHelper;
    }

    @NotNull
    public AbstractCodeGenerator createNativeDefinitionsGenerator(@NotNull ScriptingContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return (AbstractCodeGenerator)new OraNativeDefinitionsGenerator(context);
    }

    @NotNull
    public AbstractCodeGenerator createRefreshingGenerator(@NotNull ScriptingContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return (AbstractCodeGenerator)new OraRefreshMatViewGenerator(context);
    }

    @NotNull
    public AbstractCodeGenerator createExecuteGenerator(@NotNull ScriptingContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return (AbstractCodeGenerator)new OraExecuteGenerator(context);
    }

    @NotNull
    protected Object createCapsKey(@NotNull BasicElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Object it = super.createCapsKey(element);
        boolean bl = false;
        return element instanceof OraSequence ? TuplesKt.to((Object)it, (Object)((OraSequence)element).isBelongsToColumn()) : it;
    }
}

