/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.oracle.plan;

import com.intellij.database.dataSource.DatabaseConnectionCore;
import com.intellij.database.dataSource.connection.statements.ReusableSmartStatement;
import com.intellij.database.dialects.base.plan.AbstractPlanModelBuilder;
import com.intellij.database.dialects.base.plan.RawPlanData;
import com.intellij.database.plan.MetaNode;
import com.intellij.database.plan.PlanRetrievalException;
import com.intellij.database.remote.jdbc.RemoteResultSet;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Ref;
import com.intellij.util.ThrowableConsumer;
import com.intellij.util.containers.MultiMap;
import java.math.BigDecimal;
import java.sql.SQLException;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OraRawPlanData
extends RawPlanData {
    private static final String DEFAULT_PLAN_TABLE = "PLAN_TABLE";
    public MetaNode<MetaData> plan;

    public void load(@NotNull DatabaseConnectionCore connection, final @NotNull String statement, boolean run) {
        if (connection == null) {
            OraRawPlanData.$$$reportNull$$$0(0);
        }
        if (statement == null) {
            OraRawPlanData.$$$reportNull$$$0(1);
        }
        this.plan = null;
        final MultiMap childMap = MultiMap.createLinked();
        final Ref root = Ref.create();
        OraRawPlanData.useStatementWithPreserved((DatabaseConnectionCore)connection, (RawPlanData.ResourceUser)new RawPlanData.ResourceUser<ReusableSmartStatement<String>>(){

            public void use(ReusableSmartStatement<String> s) throws PlanRetrievalException, SQLException {
                String uuid = AbstractPlanModelBuilder.randomShorterUUID();
                s.barren().execute((Object)("EXPLAIN PLAN SET STATEMENT_ID = '" + uuid + "' INTO \"PLAN_TABLE\" FOR " + statement));
                s.noisy().execute((Object)("SELECT OPERATION, OPTIONS, OBJECT_NAME, OBJECT_TYPE, ID, PARENT_ID, POSITION, COST, CARDINALITY, CPU_COST, IO_COST, BYTES, TIME, FILTER_PREDICATES, ACCESS_PREDICATES FROM \"PLAN_TABLE\" WHERE STATEMENT_ID = '" + uuid + "'"), OraRawPlanData.processing((ThrowableConsumer)rs -> {
                    while (rs.next()) {
                        MetaData nodeData = new MetaData(rs.getString("OPERATION"), rs.getString("OPTIONS"), rs.getString("OBJECT_NAME"), rs.getString("OBJECT_TYPE"), OraRawPlanData.this.getInteger((RemoteResultSet)rs, "ID"), OraRawPlanData.this.getInteger((RemoteResultSet)rs, "PARENT_ID"), OraRawPlanData.this.getInteger((RemoteResultSet)rs, "POSITION"), OraRawPlanData.this.getBig((RemoteResultSet)rs, "COST"), OraRawPlanData.this.getBig((RemoteResultSet)rs, "CARDINALITY"), OraRawPlanData.this.getBig((RemoteResultSet)rs, "CPU_COST"), OraRawPlanData.this.getBig((RemoteResultSet)rs, "IO_COST"), OraRawPlanData.this.getBig((RemoteResultSet)rs, "BYTES"), OraRawPlanData.this.getBig((RemoteResultSet)rs, "TIME"), rs.getString("FILTER_PREDICATES"), rs.getString("ACCESS_PREDICATES"));
                        if (nodeData.parentId == null) {
                            root.set((Object)nodeData);
                            continue;
                        }
                        childMap.putValue((Object)nodeData.parentId, (Object)nodeData);
                    }
                }));
            }
        }, (RawPlanData.StateSaver[])new RawPlanData.StateSaver[0]);
        if (root.get() == null) {
            throw new PlanRetrievalException("No root operation found");
        }
        this.plan = new Object(this){

            public MetaNode<MetaData> fillChildren(MetaNode<MetaData> node) {
                for (MetaData data : childMap.get((Object)((MetaData)node.data).id)) {
                    node.children.add(this.fillChildren((MetaNode<MetaData>)new MetaNode((Object)data)));
                }
                node.children.sort((o1, o2) -> Comparing.compare((Comparable)((MetaData)o1.data).position, (Comparable)((MetaData)o2.data).position));
                return node;
            }
        }.fillChildren((MetaNode<MetaData>)new MetaNode((Object)((MetaData)root.get())));
    }

    @Nullable
    Integer getInteger(RemoteResultSet resultSet, String col) throws Exception {
        return resultSet.getObject(col) == null ? null : Integer.valueOf(resultSet.getInt(col));
    }

    @Nullable
    BigDecimal getBig(RemoteResultSet resultSet, String col) throws Exception {
        return resultSet.getObject(col) == null ? null : resultSet.getBigDecimal(col);
    }

    public void load(@NotNull String dump) {
        if (dump == null) {
            OraRawPlanData.$$$reportNull$$$0(2);
        }
        try {
            new Object(this){

                private static MetaNode<MetaData> visit(JSONObject obj) throws JSONException {
                    MetaNode node = new MetaNode((Object)new MetaData(obj.getString("operation"), obj.optString("options"), obj.optString("objectName"), obj.optString("objectType"), obj.optInt("id"), obj.optInt("parentId"), obj.optInt("position"), AbstractPlanModelBuilder.optBig((JSONObject)obj, (String)"cost", null), AbstractPlanModelBuilder.optBig((JSONObject)obj, (String)"cardinality", null), AbstractPlanModelBuilder.optBig((JSONObject)obj, (String)"cpuCost", null), AbstractPlanModelBuilder.optBig((JSONObject)obj, (String)"ioCost", null), AbstractPlanModelBuilder.optBig((JSONObject)obj, (String)"bytes", null), AbstractPlanModelBuilder.optBig((JSONObject)obj, (String)"time", null), obj.optString("filterPredicates"), obj.optString("accessPredicates")));
                    JSONArray children = obj.optJSONArray("children");
                    if (children != null) {
                        int e = children.length();
                        for (int i2 = 0; i2 < e; ++i2) {
                            node.children.add(3.visit(children.getJSONObject(i2)));
                        }
                    }
                    return node;
                }
            };
            this.plan = 3.visit(new JSONObject(dump));
        }
        catch (JSONException e) {
            throw new PlanRetrievalException("Load failed", (Throwable)e);
        }
    }

    public String dump() {
        try {
            new Object(this){

                private static JSONObject visit(MetaNode<MetaData> node) throws JSONException {
                    JSONObject res = new JSONObject();
                    res.put("operation", (Object)((MetaData)node.data).operation);
                    res.put("options", (Object)((MetaData)node.data).options);
                    res.put("objectName", (Object)((MetaData)node.data).objectName);
                    res.put("objectType", (Object)((MetaData)node.data).objectType);
                    res.put("cardinality", (Object)((MetaData)node.data).cardinality);
                    res.put("cost", (Object)((MetaData)node.data).cost);
                    res.put("cpuCost", (Object)((MetaData)node.data).cpuCost);
                    res.put("ioCost", (Object)((MetaData)node.data).ioCost);
                    res.put("bytes", (Object)((MetaData)node.data).bytes);
                    res.put("time", (Object)((MetaData)node.data).time);
                    res.put("accessPredicates", (Object)((MetaData)node.data).accessPredicates);
                    res.put("filterPredicates", (Object)((MetaData)node.data).filterPredicates);
                    res.put("id", (Object)((MetaData)node.data).id);
                    res.put("parentId", (Object)((MetaData)node.data).parentId);
                    res.put("position", (Object)((MetaData)node.data).position);
                    if (!node.children.isEmpty()) {
                        JSONArray children = new JSONArray();
                        for (MetaNode child : node.children) {
                            children.put((Object)4.visit((MetaNode<MetaData>)child));
                        }
                        res.put("children", (Object)children);
                    }
                    return res;
                }
            };
            return 4.visit(this.plan).toString(2);
        }
        catch (JSONException e) {
            throw new PlanRetrievalException("Dump failed", (Throwable)e);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "connection";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "statement";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "dump";
                break;
            }
        }
        objectArray[1] = "com/intellij/database/dialects/oracle/plan/OraRawPlanData";
        objectArray[2] = "load";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static final class MetaData {
        public final String operation;
        public final String options;
        public final String objectName;
        public final String objectType;
        public final String filterPredicates;
        public final String accessPredicates;
        public final Integer id;
        public final Integer parentId;
        public final Integer position;
        public final BigDecimal cardinality;
        public final BigDecimal cost;
        public final BigDecimal cpuCost;
        public final BigDecimal ioCost;
        public final BigDecimal bytes;
        public final BigDecimal time;

        private MetaData(String operation, String options, String objectName, String objectType, Integer id, Integer parentId, Integer position, BigDecimal cost, BigDecimal cardinality, BigDecimal cpuCost, BigDecimal ioCost, BigDecimal bytes, BigDecimal time, String filterPredicates, String accessPredicates) {
            this.operation = operation;
            this.options = options;
            this.objectName = objectName;
            this.objectType = objectType;
            this.id = id;
            this.parentId = parentId;
            this.position = position;
            this.cost = cost;
            this.cardinality = cardinality;
            this.cpuCost = cpuCost;
            this.ioCost = ioCost;
            this.bytes = bytes;
            this.time = time;
            this.filterPredicates = filterPredicates;
            this.accessPredicates = accessPredicates;
        }
    }
}

