/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.dialects.oracle.psi;

import com.intellij.database.dialects.oracle.types.OraTypeSystem;
import com.intellij.database.types.DasBuiltinType;
import com.intellij.database.types.DasType;
import com.intellij.database.types.DasTypeSystemBase;
import com.intellij.psi.tree.IElementType;
import com.intellij.sql.dialects.oracle.OraTypes;
import com.intellij.sql.psi.SqlCommonKeywords;
import com.intellij.sql.psi.SqlCommonTokens;
import com.intellij.sql.psi.SqlExpression;
import com.intellij.sql.psi.impl.SqlDasTypeAwareDeepRecursiveElement;
import com.intellij.sql.psi.impl.SqlUnaryExpressionImpl;
import kotlin.DeepRecursiveScope;
import kotlin.Metadata;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\"\u0010\u0006\u001a\u00020\u0007*\u0012\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u00070\bj\u0002`\nH\u0096@\u00a2\u0006\u0002\u0010\u000b\u00a8\u0006\f"}, d2={"Lcom/intellij/sql/dialects/oracle/psi/OraUnaryExpressionImpl;", "Lcom/intellij/sql/psi/impl/SqlUnaryExpressionImpl;", "elementType", "Lcom/intellij/psi/tree/IElementType;", "<init>", "(Lcom/intellij/psi/tree/IElementType;)V", "computeDasType", "Lcom/intellij/database/types/DasType;", "Lkotlin/DeepRecursiveScope;", "Lcom/intellij/sql/psi/impl/SqlDasTypeAwareDeepRecursiveElement;", "Lcom/intellij/sql/psi/impl/SqlDeepRecursiveTypeEvaluationScope;", "(Lkotlin/DeepRecursiveScope;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "intellij.database.dialects.oracle"})
public class OraUnaryExpressionImpl
extends SqlUnaryExpressionImpl {
    public OraUnaryExpressionImpl(@NotNull IElementType elementType) {
        Intrinsics.checkNotNullParameter((Object)elementType, (String)"elementType");
        super(elementType);
    }

    @Nullable
    public Object computeDasType(@NotNull DeepRecursiveScope<SqlDasTypeAwareDeepRecursiveElement, DasType> $this$computeDasType, @NotNull Continuation<? super DasType> $completion) {
        return OraUnaryExpressionImpl.computeDasType$suspendImpl(this, $this$computeDasType, $completion);
    }

    static /* synthetic */ Object computeDasType$suspendImpl(OraUnaryExpressionImpl $this, DeepRecursiveScope<SqlDasTypeAwareDeepRecursiveElement, DasType> $receiver, Continuation<? super DasType> $completion) {
        IElementType sign = $this.getOpSign();
        if (Intrinsics.areEqual((Object)sign, (Object)SqlCommonKeywords.SQL_NOT)) {
            return OraTypeSystem.BOOLEAN;
        }
        if (Intrinsics.areEqual((Object)sign, (Object)OraTypes.ORA_INSERTING) || Intrinsics.areEqual((Object)sign, (Object)OraTypes.ORA_UPDATING) || Intrinsics.areEqual((Object)sign, (Object)OraTypes.ORA_DELETING)) {
            return OraTypeSystem.BOOLEAN;
        }
        SqlExpression sqlExpression = $this.getOperand();
        if (sqlExpression == null) {
            return DasTypeSystemBase.UNKNOWN;
        }
        SqlExpression operand = sqlExpression;
        DasType dasType = operand.getDasType();
        Intrinsics.checkNotNullExpressionValue((Object)dasType, (String)"getDasType(...)");
        DasType operandType = dasType;
        if (Intrinsics.areEqual((Object)sign, (Object)SqlCommonTokens.SQL_OP_PLUS)) {
            return operandType;
        }
        if (Intrinsics.areEqual((Object)sign, (Object)SqlCommonTokens.SQL_OP_MINUS)) {
            if (Intrinsics.areEqual((Object)operandType, (Object)OraTypeSystem.NATURAL) || Intrinsics.areEqual((Object)operandType, (Object)OraTypeSystem.POSITIVE)) {
                return OraTypeSystem.BINARY_INTEGER;
            }
            if (Intrinsics.areEqual((Object)operandType, (Object)OraTypeSystem.NATURALN) || Intrinsics.areEqual((Object)operandType, (Object)OraTypeSystem.POSITIVEN)) {
                return OraTypeSystem.SIMPLE_INTEGER;
            }
            return operandType instanceof DasBuiltinType && ((DasBuiltinType)operandType).getTypeClass().getCategory().isNumber() ? operandType : (DasType)OraTypeSystem.NUMBER;
        }
        if (Intrinsics.areEqual((Object)sign, (Object)OraTypes.ORA_PRIOR) || Intrinsics.areEqual((Object)sign, (Object)OraTypes.ORA_CONNECT_BY_ROOT)) {
            return operandType;
        }
        if (Intrinsics.areEqual((Object)sign, (Object)OraTypes.ORA_ORA_JOIN_OPERATOR)) {
            return operandType;
        }
        return DasTypeSystemBase.UNKNOWN;
    }
}

