/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.eel.impl.local.tunnels;

import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.platform.eel.EelTunnelsApi;
import com.intellij.platform.eel.impl.IpAddressesImplKt;
import com.intellij.platform.eel.impl.local.tunnels.LocalTunnelsImplKt;
import com.intellij.platform.eel.impl.local.tunnels.MyService;
import com.intellij.platform.eel.impl.local.tunnels.SocketAdapter;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.net.SocketAddress;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineName;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.Job;
import kotlinx.coroutines.channels.Channel;
import kotlinx.coroutines.channels.ChannelKt;
import kotlinx.coroutines.channels.ClosedSendChannelException;
import kotlinx.coroutines.channels.ReceiveChannel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u0003\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\u0013\u001a\u00020\u0014H\u0096@\u00a2\u0006\u0002\u0010\u0015J\u0014\u0010\u0016\u001a\u00020\u00142\n\b\u0002\u0010\u0017\u001a\u0004\u0018\u00010\u0018H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\t\u001a\b\u0012\u0004\u0012\u00020\b0\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\u00020\u000eX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/intellij/platform/eel/impl/local/tunnels/ConnectionAcceptorImpl;", "Lcom/intellij/platform/eel/EelTunnelsApi$ConnectionAcceptor;", "boundServerSocket", "Ljava/nio/channels/ServerSocketChannel;", "<init>", "(Ljava/nio/channels/ServerSocketChannel;)V", "_incomingConnections", "Lkotlinx/coroutines/channels/Channel;", "Lcom/intellij/platform/eel/EelTunnelsApi$Connection;", "incomingConnections", "Lkotlinx/coroutines/channels/ReceiveChannel;", "getIncomingConnections", "()Lkotlinx/coroutines/channels/ReceiveChannel;", "boundAddress", "Lcom/intellij/platform/eel/EelTunnelsApi$ResolvedSocketAddress;", "getBoundAddress", "()Lcom/intellij/platform/eel/EelTunnelsApi$ResolvedSocketAddress;", "listenSocket", "Lkotlinx/coroutines/Job;", "close", "", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "closeImpl", "err", "", "intellij.platform.eel.impl"})
@SourceDebugExtension(value={"SMAP\nlocalTunnelsImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 localTunnelsImpl.kt\ncom/intellij/platform/eel/impl/local/tunnels/ConnectionAcceptorImpl\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,289:1\n30#2,2:290\n57#3:292\n35#3,2:293\n*S KotlinDebug\n*F\n+ 1 localTunnelsImpl.kt\ncom/intellij/platform/eel/impl/local/tunnels/ConnectionAcceptorImpl\n*L\n224#1:290,2\n261#1:292\n261#1:293,2\n*E\n"})
final class ConnectionAcceptorImpl
implements EelTunnelsApi.ConnectionAcceptor {
    @NotNull
    private final ServerSocketChannel boundServerSocket;
    @NotNull
    private final Channel<EelTunnelsApi.Connection> _incomingConnections;
    @NotNull
    private final ReceiveChannel<EelTunnelsApi.Connection> incomingConnections;
    @NotNull
    private final EelTunnelsApi.ResolvedSocketAddress boundAddress;
    @NotNull
    private final Job listenSocket;

    public ConnectionAcceptorImpl(@NotNull ServerSocketChannel boundServerSocket) {
        Intrinsics.checkNotNullParameter((Object)boundServerSocket, (String)"boundServerSocket");
        this.boundServerSocket = boundServerSocket;
        this._incomingConnections = ChannelKt.Channel$default((int)0, null, null, (int)7, null);
        this.incomingConnections = (ReceiveChannel)this._incomingConnections;
        SocketAddress socketAddress = this.boundServerSocket.getLocalAddress();
        Intrinsics.checkNotNullExpressionValue((Object)socketAddress, (String)"getLocalAddress(...)");
        this.boundAddress = IpAddressesImplKt.getAsResolvedSocketAddress(socketAddress);
        boolean bl = this.boundServerSocket.isOpen();
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        this.boundServerSocket.configureBlocking(false);
        Application application = ApplicationManager.getApplication();
        Intrinsics.checkNotNullExpressionValue((Object)application, (String)"getApplication(...)");
        ComponentManager $this$service$iv = (ComponentManager)application;
        boolean $i$f$service = false;
        Class<MyService> serviceClass$iv = MyService.class;
        Object object = $this$service$iv.getService(serviceClass$iv);
        if (object == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        this.listenSocket = BuildersKt.launch$default((CoroutineScope)((MyService)object).getScope(), (CoroutineContext)Dispatchers.getIO().plus((CoroutineContext)new CoroutineName("eel socket accept")), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            Object L$1;
            Object L$2;
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ ConnectionAcceptorImpl this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * WARNING - void declaration
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public final Object invokeSuspend(Object $result) {
                void $this$launch;
                Object object;
                SocketChannel channel2;
                Selector selector;
                CoroutineScope coroutineScope = (CoroutineScope)this.L$0;
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        selector = Selector.open();
                        this.this$0.boundServerSocket.register(selector, 16);
                        break;
                    }
                    case 1: {
                        channel2 = (SocketChannel)this.L$2;
                        selector = (Selector)this.L$1;
                        try {
                            ResultKt.throwOnFailure((Object)$result);
                            object = $result;
                        }
                        catch (IOException e) {
                            this.this$0.closeImpl(e);
                            return Unit.INSTANCE;
                        }
                    }
                    default: {
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }
                }
                while (CoroutineScopeKt.isActive((CoroutineScope)$this$launch)) {
                    while (selector.select(100L) == 0) {
                        CoroutineScopeKt.ensureActive((CoroutineScope)$this$launch);
                    }
                    selector.selectedKeys().clear();
                    channel2 = this.this$0.boundServerSocket.accept();
                    LocalTunnelsImplKt.access$getLogger$p().info("Connection from " + channel2.socket().getRemoteSocketAddress());
                    try {
                        Channel channel3 = this.this$0._incomingConnections;
                        Intrinsics.checkNotNull((Object)channel2);
                        this.L$0 = $this$launch;
                        this.L$1 = selector;
                        this.L$2 = channel2;
                        this.label = 1;
                        object = channel3.send((Object)new SocketAdapter(channel2), (Continuation)this);
                        if (object != object2) continue;
                    }
                    catch (ClosedSendChannelException closedSendChannelException) {
                        channel2.close();
                    }
                    return object2;
                }
                selector.close();
                return Unit.INSTANCE;
                finally {
                    selector.close();
                }
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                var3_3.L$0 = value;
                return (Continuation)var3_3;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)2, null);
    }

    @NotNull
    public ReceiveChannel<EelTunnelsApi.Connection> getIncomingConnections() {
        return this.incomingConnections;
    }

    @NotNull
    public EelTunnelsApi.ResolvedSocketAddress getBoundAddress() {
        return this.boundAddress;
    }

    @Nullable
    public Object close(@NotNull Continuation<? super Unit> $completion) {
        ConnectionAcceptorImpl.closeImpl$default(this, null, 1, null);
        Object object = this.listenSocket.join($completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    private final void closeImpl(Throwable err) {
        boolean $i$f$fileLogger = false;
        boolean $i$f$currentClassLogger = false;
        Class<?> clazz$iv$iv = MethodHandles.lookup().lookupClass();
        Logger logger = Logger.getInstance(clazz$iv$iv);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        logger.warn("Closing with exception", err);
        Job.DefaultImpls.cancel$default((Job)this.listenSocket, null, (int)1, null);
        this.boundServerSocket.close();
        this._incomingConnections.close(err);
        ReceiveChannel.DefaultImpls.cancel$default((ReceiveChannel)((ReceiveChannel)this._incomingConnections), null, (int)1, null);
    }

    static /* synthetic */ void closeImpl$default(ConnectionAcceptorImpl connectionAcceptorImpl, Throwable throwable, int n, Object object) {
        if ((n & 1) != 0) {
            throwable = null;
        }
        connectionAcceptorImpl.closeImpl(throwable);
    }
}

