/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.application.options;

import com.intellij.application.options.CodeStyleImportsBaseUI;
import com.intellij.application.options.ImportLayoutPanel;
import com.intellij.application.options.PackagePanel;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.JavaImportsLayoutSettings;
import com.intellij.psi.codeStyle.PackageEntry;
import com.intellij.psi.codeStyle.PackageEntryTable;
import com.intellij.ui.TableUtil;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.table.JBTable;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import org.jetbrains.annotations.NotNull;

public abstract class CodeStyleImportsPanelBase
extends JPanel {
    private final PackageEntryTable myPackageList = new PackageEntryTable();
    private final CodeStyleImportsBaseUI kotlinUI;
    private final JBTable myPackageTable;
    protected final ImportLayoutPanel myImportLayoutPanel = new ImportLayoutPanel(this.isShowLayoutOnDemandImportFromSamePackageFirstCheckbox(), this.isSupportModule()){

        @Override
        public void refresh() {
            CodeStyleImportsPanelBase.this.refreshTable(CodeStyleImportsPanelBase.this.myPackageTable, CodeStyleImportsPanelBase.this.myPackageList);
            CodeStyleImportsPanelBase.this.refreshTable(this.getImportLayoutTable(), this.getImportLayoutList());
        }
    };

    public CodeStyleImportsPanelBase() {
        this.myPackageTable = ImportLayoutPanel.createTableForPackageEntries(this.myPackageList, this.myImportLayoutPanel);
        this.kotlinUI = this.createKotlinUI(PackagePanel.createPackagesPanel(this.myPackageTable, this.myPackageList), this.myImportLayoutPanel);
        this.setLayout(new BorderLayout());
        this.add((Component)new JBScrollPane((Component)this.kotlinUI.panel), "Center");
    }

    public abstract void reset(CodeStyleSettings var1);

    public abstract void apply(CodeStyleSettings var1);

    public abstract boolean isModified(CodeStyleSettings var1);

    protected CodeStyleImportsBaseUI createKotlinUI(JComponent packages, JComponent importLayout) {
        CodeStyleImportsBaseUI result = new CodeStyleImportsBaseUI(packages, importLayout);
        result.init();
        return result;
    }

    private void refreshTable(JBTable table, PackageEntryTable packageTable) {
        AbstractTableModel model = (AbstractTableModel)table.getModel();
        table.createDefaultColumnsFromModel();
        model.fireTableDataChanged();
        ImportLayoutPanel.resizeColumns(packageTable, table, this.myImportLayoutPanel.areStaticImportsEnabled());
    }

    public void resetLayoutSettings(JavaImportsLayoutSettings settings) {
        this.kotlinUI.reset(settings);
        this.myImportLayoutPanel.getImportLayoutList().copyFrom(settings.getImportLayoutTable());
        this.myPackageList.copyFrom(settings.getPackagesToUseImportOnDemand());
        this.myImportLayoutPanel.getCbLayoutStaticImportsSeparately().setSelected(settings.isLayoutStaticImportsSeparately());
        JBTable importLayoutTable = this.myImportLayoutPanel.getImportLayoutTable();
        AbstractTableModel model = (AbstractTableModel)importLayoutTable.getModel();
        model.fireTableDataChanged();
        model = (AbstractTableModel)this.myPackageTable.getModel();
        model.fireTableDataChanged();
        if (importLayoutTable.getRowCount() > 0) {
            importLayoutTable.getSelectionModel().setSelectionInterval(0, 0);
        }
        if (this.myPackageTable.getRowCount() > 0) {
            this.myPackageTable.getSelectionModel().setSelectionInterval(0, 0);
        }
    }

    public void applyLayoutSettings(JavaImportsLayoutSettings settings) {
        this.stopTableEditing();
        settings.setLayoutStaticImportsSeparately(this.myImportLayoutPanel.areStaticImportsEnabled());
        this.kotlinUI.apply(settings);
        PackageEntryTable list = this.myImportLayoutPanel.getImportLayoutList();
        settings.getImportLayoutTable().copyFrom(CodeStyleImportsPanelBase.getCopyWithoutEmptyPackages(list));
        settings.getPackagesToUseImportOnDemand().copyFrom(CodeStyleImportsPanelBase.getCopyWithoutEmptyPackages(this.myPackageList));
    }

    public boolean isModifiedLayoutSettings(JavaImportsLayoutSettings settings) {
        boolean isModified = CodeStyleImportsPanelBase.isModified((JCheckBox)this.myImportLayoutPanel.getCbLayoutStaticImportsSeparately(), settings.isLayoutStaticImportsSeparately());
        isModified |= this.kotlinUI.isModified(settings);
        PackageEntryTable list = this.myImportLayoutPanel.getImportLayoutList();
        isModified |= CodeStyleImportsPanelBase.isModified(CodeStyleImportsPanelBase.getCopyWithoutEmptyPackages(list), settings.getImportLayoutTable());
        return isModified |= CodeStyleImportsPanelBase.isModified(CodeStyleImportsPanelBase.getCopyWithoutEmptyPackages(this.myPackageList), settings.getPackagesToUseImportOnDemand());
    }

    private void stopTableEditing() {
        TableUtil.stopEditing((JTable)this.myImportLayoutPanel.getImportLayoutTable());
        TableUtil.stopEditing((JTable)this.myPackageTable);
    }

    @NotNull
    private static PackageEntryTable getCopyWithoutEmptyPackages(PackageEntryTable table) {
        PackageEntryTable packageEntryTable;
        try {
            PackageEntryTable copy = (PackageEntryTable)table.clone();
            copy.removeEmptyPackages();
            packageEntryTable = copy;
        }
        catch (CloneNotSupportedException ignored) {
            throw new IllegalStateException("Clone should be supported");
        }
        if (packageEntryTable == null) {
            CodeStyleImportsPanelBase.$$$reportNull$$$0(0);
        }
        return packageEntryTable;
    }

    protected static boolean isModified(JCheckBox checkBox, boolean value) {
        return checkBox.isSelected() != value;
    }

    private static boolean isModified(PackageEntryTable list, PackageEntryTable table) {
        if (list.getEntryCount() != table.getEntryCount()) {
            return true;
        }
        for (int i = 0; i < list.getEntryCount(); ++i) {
            PackageEntry entry2;
            PackageEntry entry1 = list.getEntryAt(i);
            if (entry1.equals((Object)(entry2 = table.getEntryAt(i)))) continue;
            return true;
        }
        return false;
    }

    protected boolean isShowLayoutOnDemandImportFromSamePackageFirstCheckbox() {
        return false;
    }

    protected boolean isSupportModule() {
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/application/options/CodeStyleImportsPanelBase", "getCopyWithoutEmptyPackages"));
    }
}

