/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.editorActions;

import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorModificationUtil;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.editor.ex.EditorSettingsExternalizable;
import com.intellij.openapi.project.Project;
import com.intellij.psi.AbstractBasicJavaFile;
import com.intellij.psi.JavaDocTokenType;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.javadoc.PsiDocToken;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.text.CharArrayUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavadocLineStartHandler
extends EditorActionHandler.ForEachCaret {
    private static final String WHITESPACE = " \t";
    private final EditorActionHandler myOriginalHandler;
    private final boolean myWithSelection;

    public JavadocLineStartHandler(@NotNull EditorActionHandler originalHandler) {
        if (originalHandler == null) {
            JavadocLineStartHandler.$$$reportNull$$$0(0);
        }
        this(originalHandler, false);
    }

    public JavadocLineStartHandler(@NotNull EditorActionHandler originalHandler, boolean withSelection) {
        if (originalHandler == null) {
            JavadocLineStartHandler.$$$reportNull$$$0(1);
        }
        this.myOriginalHandler = originalHandler;
        this.myWithSelection = withSelection;
    }

    protected void doExecute(@NotNull Editor editor, @NotNull Caret caret, DataContext dataContext) {
        PsiDocumentManager psiDocumentManager;
        PsiFile file;
        int lineStartOffset;
        int nonWsStartOffset;
        Document document;
        CharSequence text;
        Project project;
        if (editor == null) {
            JavadocLineStartHandler.$$$reportNull$$$0(2);
        }
        if (caret == null) {
            JavadocLineStartHandler.$$$reportNull$$$0(3);
        }
        if ((project = editor.getProject()) != null && EditorSettingsExternalizable.getInstance().isSmartHome() && (CharArrayUtil.regionMatches((CharSequence)(text = (document = editor.getDocument()).getImmutableCharSequence()), (int)(nonWsStartOffset = CharArrayUtil.shiftForward((CharSequence)text, (int)(lineStartOffset = document.getLineStartOffset(caret.getLogicalPosition().line)), (String)WHITESPACE)), (CharSequence)"/**") || CharArrayUtil.regionMatches((CharSequence)text, (int)nonWsStartOffset, (CharSequence)"*")) && (file = (psiDocumentManager = PsiDocumentManager.getInstance((Project)project)).getPsiFile(document)) != null && JavadocLineStartHandler.isJavaFile(file)) {
            IElementType type;
            psiDocumentManager.commitDocument(document);
            PsiElement startElement = file.findElementAt(nonWsStartOffset);
            if (startElement instanceof PsiDocToken && ((type = ((PsiDocToken)startElement).getTokenType()) == JavaDocTokenType.DOC_COMMENT_START || type == JavaDocTokenType.DOC_COMMENT_LEADING_ASTERISKS)) {
                int targetOffset = CharArrayUtil.shiftForward((CharSequence)text, (int)startElement.getTextRange().getEndOffset(), (String)WHITESPACE);
                if (caret.getOffset() == targetOffset) {
                    targetOffset = lineStartOffset;
                }
                int selectionStartOffset = caret.getLeadSelectionOffset();
                caret.moveToOffset(targetOffset);
                if (this.myWithSelection) {
                    caret.setSelection(selectionStartOffset, caret.getVisualPosition(), caret.getOffset());
                } else {
                    caret.removeSelection();
                }
                EditorModificationUtil.scrollToCaret((Editor)editor);
                return;
            }
        }
        this.myOriginalHandler.execute(editor, caret, dataContext);
    }

    private static boolean isJavaFile(@Nullable PsiFile file) {
        return file instanceof AbstractBasicJavaFile;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "originalHandler";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "caret";
                break;
            }
        }
        objectArray2[1] = "com/intellij/codeInsight/editorActions/JavadocLineStartHandler";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "doExecute";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

