/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.editorActions;

import com.intellij.codeInsight.CodeInsightSettings;
import com.intellij.codeInsight.editorActions.TypedHandlerDelegate;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.AbstractBasicJavaFile;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.JavaDocTokenType;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.impl.source.javadoc.PsiDocParamRef;
import com.intellij.psi.impl.source.tree.JavaDocElementType;
import com.intellij.psi.javadoc.PsiDocTag;
import com.intellij.psi.javadoc.PsiInlineDocTag;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.text.CharArrayUtil;
import com.intellij.xml.util.BasicHtmlUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JavadocTypedHandler
extends TypedHandlerDelegate {
    private static final char START_TAG_SYMBOL = '<';
    private static final char CLOSE_TAG_SYMBOL = '>';
    private static final char SLASH = '/';
    private static final String COMMENT_PREFIX = "!--";

    @NotNull
    public TypedHandlerDelegate.Result charTyped(char c, @NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file) {
        if (project == null) {
            JavadocTypedHandler.$$$reportNull$$$0(0);
        }
        if (editor == null) {
            JavadocTypedHandler.$$$reportNull$$$0(1);
        }
        if (file == null) {
            JavadocTypedHandler.$$$reportNull$$$0(2);
        }
        if (JavadocTypedHandler.isJavaFile(file) && !JavadocTypedHandler.insertClosingTagIfNecessary(c, project, editor, file)) {
            JavadocTypedHandler.adjustStartIndent(c, editor, file);
        }
        TypedHandlerDelegate.Result result = TypedHandlerDelegate.Result.CONTINUE;
        if (result == null) {
            JavadocTypedHandler.$$$reportNull$$$0(3);
        }
        return result;
    }

    private static boolean isJavaFile(@Nullable PsiFile file) {
        return file instanceof AbstractBasicJavaFile;
    }

    private static void adjustStartIndent(char c, @NotNull Editor editor, @NotNull PsiFile file) {
        if (editor == null) {
            JavadocTypedHandler.$$$reportNull$$$0(4);
        }
        if (file == null) {
            JavadocTypedHandler.$$$reportNull$$$0(5);
        }
        if (c == '@') {
            PsiElement prev;
            int offset = editor.getCaretModel().getOffset();
            PsiElement currElement = file.findElementAt(offset);
            if (currElement instanceof PsiWhiteSpace && (prev = currElement.getPrevSibling()) != null && prev.getNode().getElementType() == JavaDocTokenType.DOC_COMMENT_LEADING_ASTERISKS) {
                editor.getDocument().replaceString(currElement.getTextRange().getStartOffset(), offset - 1, (CharSequence)" ");
            }
            return;
        }
    }

    private static boolean insertClosingTagIfNecessary(char c, @NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file) {
        if (project == null) {
            JavadocTypedHandler.$$$reportNull$$$0(6);
        }
        if (editor == null) {
            JavadocTypedHandler.$$$reportNull$$$0(7);
        }
        if (file == null) {
            JavadocTypedHandler.$$$reportNull$$$0(8);
        }
        if (c != '>' || !CodeInsightSettings.getInstance().JAVADOC_GENERATE_CLOSING_TAG) {
            return false;
        }
        PsiDocumentManager.getInstance((Project)project).commitAllDocuments();
        if (!JavadocTypedHandler.isAppropriatePlace(editor, file)) {
            return false;
        }
        int offset = editor.getCaretModel().getOffset();
        Document document = editor.getDocument();
        String tagName = JavadocTypedHandler.getTagName(document.getText(), offset);
        if (tagName == null || BasicHtmlUtil.isSingleHtmlTag((String)tagName, (boolean)false) || tagName.startsWith(COMMENT_PREFIX)) {
            return false;
        }
        document.insertString(offset, (CharSequence)(String.valueOf('<') + "/" + tagName + ">"));
        return true;
    }

    @Nullable
    public static String getTagName(@NotNull CharSequence text, int afterTagOffset) {
        if (text == null) {
            JavadocTypedHandler.$$$reportNull$$$0(9);
        }
        if (afterTagOffset > text.length()) {
            return null;
        }
        int endOffset = afterTagOffset - 1;
        if (endOffset > 0 && text.charAt(endOffset - 1) == '/') {
            return null;
        }
        for (int i = endOffset - 1; i >= 0; --i) {
            char c = text.charAt(i);
            switch (c) {
                case '\n': {
                    return null;
                }
                case '>': {
                    return null;
                }
                case '<': {
                    if (text.charAt(i + 1) == '/') {
                        return null;
                    }
                    return text.subSequence(i + 1, endOffset).toString();
                }
                case '\t': 
                case ' ': {
                    endOffset = i;
                }
            }
        }
        return null;
    }

    private static boolean isAppropriatePlace(Editor editor, PsiFile file) {
        PsiDocTag tag;
        PsiElement element;
        FileViewProvider provider = file.getViewProvider();
        int offset = editor.getCaretModel().getOffset();
        PsiElement elementAtCaret = offset < editor.getDocument().getTextLength() ? provider.findElementAt(offset) : provider.findElementAt(editor.getDocument().getTextLength() - 1);
        for (element = elementAtCaret; element instanceof PsiWhiteSpace || element != null && CharArrayUtil.containsOnlyWhiteSpaces((CharSequence)element.getText()); element = element.getPrevSibling()) {
        }
        if (element == null) {
            return false;
        }
        if (element instanceof PsiDocParamRef) {
            element = element.getParent();
        }
        if (element instanceof PsiDocTag && "param".equals((tag = (PsiDocTag)element).getName()) && JavadocTypedHandler.isTypeParamBracketClosedAfterParamTag(tag, offset)) {
            return false;
        }
        if (PsiTreeUtil.getParentOfType((PsiElement)element, PsiInlineDocTag.class, (boolean)false) != null) {
            return false;
        }
        ASTNode node = element.getNode();
        return node != null && (JavaDocTokenType.ALL_JAVADOC_TOKENS.contains(node.getElementType()) || JavaDocElementType.ALL_JAVADOC_ELEMENTS.contains(node.getElementType()));
    }

    private static boolean isTypeParamBracketClosedAfterParamTag(PsiDocTag tag, int bracketOffset) {
        PsiElement paramToDocument = JavadocTypedHandler.getDocumentingParameter(tag);
        if (paramToDocument == null) {
            return false;
        }
        TextRange paramRange = paramToDocument.getTextRange();
        return paramRange.getEndOffset() == bracketOffset;
    }

    @Nullable
    private static PsiElement getDocumentingParameter(@NotNull PsiDocTag tag) {
        if (tag == null) {
            JavadocTypedHandler.$$$reportNull$$$0(10);
        }
        for (PsiElement element = tag.getFirstChild(); element != null; element = element.getNextSibling()) {
            if (!(element instanceof PsiDocParamRef)) continue;
            return element;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 2: 
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/editorActions/JavadocTypedHandler";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tag";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/editorActions/JavadocTypedHandler";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "charTyped";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "charTyped";
                break;
            }
            case 3: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "adjustStartIndent";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "insertClosingTagIfNecessary";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getTagName";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getDocumentingParameter";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3 -> new IllegalStateException(string);
        };
    }
}

