/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.editorActions.smartEnter;

import com.intellij.application.options.CodeStyle;
import com.intellij.codeInsight.editorActions.smartEnter.Fixer;
import com.intellij.codeInsight.editorActions.smartEnter.JavaSmartEnterProcessor;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEmptyStatement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiForStatement;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.impl.source.tree.JavaJspElementType;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;

public class ForStatementFixer
implements Fixer {
    @Override
    public void apply(Editor editor, JavaSmartEnterProcessor processor, @NotNull PsiElement psiElement) throws IncorrectOperationException {
        if (psiElement == null) {
            ForStatementFixer.$$$reportNull$$$0(0);
        }
        if (!(psiElement instanceof PsiForStatement)) {
            return;
        }
        PsiForStatement forStatement = (PsiForStatement)psiElement;
        PsiJavaToken lParenth = forStatement.getLParenth();
        PsiJavaToken rParenth = forStatement.getRParenth();
        if (lParenth == null || rParenth == null) {
            TextRange textRange = forStatement.getTextRange();
            editor.getDocument().replaceString(textRange.getStartOffset(), textRange.getEndOffset(), (CharSequence)"for () {\n}");
            processor.registerUnresolvedError(textRange.getStartOffset() + "for (".length());
            return;
        }
        PsiStatement initialization = forStatement.getInitialization();
        if (initialization == null) {
            processor.registerUnresolvedError(lParenth.getTextRange().getEndOffset());
            return;
        }
        PsiExpression condition = forStatement.getCondition();
        if (condition == null) {
            boolean endlessLoop;
            boolean bl = endlessLoop = initialization instanceof PsiEmptyStatement && forStatement.getUpdate() == null;
            if (!endlessLoop) {
                ForStatementFixer.registerErrorOffset(editor, processor, initialization, forStatement);
            }
            return;
        }
        if (forStatement.getUpdate() == null) {
            ForStatementFixer.registerErrorOffset(editor, processor, condition, forStatement);
        }
    }

    private static void registerErrorOffset(@NotNull Editor editor, @NotNull JavaSmartEnterProcessor processor, @NotNull PsiElement lastValidForPart, @NotNull PsiForStatement forStatement) {
        if (editor == null) {
            ForStatementFixer.$$$reportNull$$$0(1);
        }
        if (processor == null) {
            ForStatementFixer.$$$reportNull$$$0(2);
        }
        if (lastValidForPart == null) {
            ForStatementFixer.$$$reportNull$$$0(3);
        }
        if (forStatement == null) {
            ForStatementFixer.$$$reportNull$$$0(4);
        }
        Project project = editor.getProject();
        int offset = lastValidForPart.getTextRange().getEndOffset();
        if (project != null && CodeStyle.getSettings((Editor)editor).getCommonSettings((Language)JavaLanguage.INSTANCE).SPACE_AFTER_COMMA) {
            if (editor.getDocument().getCharsSequence().charAt(lastValidForPart.getTextRange().getEndOffset() - 1) != ';') {
                ++offset;
            }
            for (PsiElement element = lastValidForPart.getNextSibling(); element != null && element != forStatement.getRParenth() && element.getParent() == forStatement; element = element.getNextSibling()) {
                ASTNode node = element.getNode();
                if (node == null || !JavaJspElementType.WHITE_SPACE_BIT_SET.contains(node.getElementType()) || element.getTextLength() <= 0) continue;
                ++offset;
                break;
            }
        }
        processor.registerUnresolvedError(offset);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiElement";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lastValidForPart";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "forStatement";
                break;
            }
        }
        objectArray2[1] = "com/intellij/codeInsight/editorActions/smartEnter/ForStatementFixer";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "apply";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "registerErrorOffset";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

