/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.editorActions.smartEnter;

import com.intellij.codeInsight.editorActions.smartEnter.Fixer;
import com.intellij.codeInsight.editorActions.smartEnter.JavaSmartEnterProcessor;
import com.intellij.openapi.editor.Editor;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNewExpression;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;

public class MissingArrayConstructorBracketFixer
implements Fixer {
    @Override
    public void apply(Editor editor, JavaSmartEnterProcessor processor, @NotNull PsiElement psiElement) throws IncorrectOperationException {
        if (psiElement == null) {
            MissingArrayConstructorBracketFixer.$$$reportNull$$$0(0);
        }
        if (!(psiElement instanceof PsiNewExpression)) {
            return;
        }
        PsiNewExpression expr = (PsiNewExpression)psiElement;
        int count = 0;
        for (PsiElement element = expr.getFirstChild(); element != null; element = element.getNextSibling()) {
            if (element.getNode().getElementType() == JavaTokenType.LBRACKET) {
                ++count;
                continue;
            }
            if (element.getNode().getElementType() != JavaTokenType.RBRACKET) continue;
            --count;
        }
        if (count > 0) {
            editor.getDocument().insertString(psiElement.getTextRange().getEndOffset(), (CharSequence)"]");
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiElement", "com/intellij/codeInsight/editorActions/smartEnter/MissingArrayConstructorBracketFixer", "apply"));
    }
}

