/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.editorActions.wordSelection;

import com.intellij.codeInsight.editorActions.wordSelection.AbstractWordSelectioner;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiKeyword;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiUtil;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public final class JavaWordSelectioner
extends AbstractWordSelectioner {
    public boolean canSelect(@NotNull PsiElement e) {
        if (e == null) {
            JavaWordSelectioner.$$$reportNull$$$0(0);
        }
        if (e instanceof PsiKeyword) {
            return true;
        }
        if (e instanceof PsiJavaToken) {
            IElementType tokenType = ((PsiJavaToken)e).getTokenType();
            return tokenType == JavaTokenType.IDENTIFIER || tokenType == JavaTokenType.STRING_LITERAL;
        }
        return false;
    }

    public List<TextRange> select(@NotNull PsiElement e, @NotNull CharSequence editorText, int cursorOffset, @NotNull Editor editor) {
        List ranges;
        if (e == null) {
            JavaWordSelectioner.$$$reportNull$$$0(1);
        }
        if (editorText == null) {
            JavaWordSelectioner.$$$reportNull$$$0(2);
        }
        if (editor == null) {
            JavaWordSelectioner.$$$reportNull$$$0(3);
        }
        if ((ranges = super.select(e, editorText, cursorOffset, editor)) == null) {
            return null;
        }
        if (PsiUtil.isJavaToken(e, JavaTokenType.STRING_LITERAL)) {
            JavaWordSelectioner.killRangesBreakingEscapes(e, ranges, e.getTextRange());
        }
        return ranges;
    }

    private static void killRangesBreakingEscapes(PsiElement e, List<TextRange> ranges, TextRange literalRange) {
        Iterator<TextRange> iterator = ranges.iterator();
        while (iterator.hasNext()) {
            TextRange each = iterator.next();
            if (!literalRange.contains(each) || literalRange.getStartOffset() >= each.getStartOffset() || e.getText().charAt(each.getStartOffset() - literalRange.getStartOffset() - 1) != '\\') continue;
            iterator.remove();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editorText";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
        }
        objectArray2[1] = "com/intellij/codeInsight/editorActions/wordSelection/JavaWordSelectioner";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "canSelect";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "select";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

