/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lexer;

import com.intellij.lexer.StringLiteralLexer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.StringEscapesTokenTypes;
import com.intellij.psi.impl.source.tree.ElementType;
import com.intellij.psi.tree.IElementType;
import org.jetbrains.annotations.NotNull;

class JavaStringLiteralLexer
extends StringLiteralLexer {
    JavaStringLiteralLexer(char quoteChar, IElementType originalLiteralToken) {
        super(quoteChar, originalLiteralToken);
    }

    JavaStringLiteralLexer(char quoteChar, IElementType originalLiteralToken, boolean canEscapeEolOrFramingSpaces, String additionalValidEscapes) {
        super(quoteChar, originalLiteralToken, canEscapeEolOrFramingSpaces, additionalValidEscapes);
    }

    public IElementType getTokenType() {
        char c;
        IElementType tokenType = super.getTokenType();
        if (tokenType == StringEscapesTokenTypes.INVALID_CHARACTER_ESCAPE_TOKEN && this.myBuffer.length() > this.myStart + 1 && (c = this.myBuffer.charAt(this.myStart + 1)) == '{' && ElementType.STRING_TEMPLATE_FRAGMENTS.contains(this.myOriginalLiteralToken)) {
            return this.myOriginalLiteralToken;
        }
        return tokenType;
    }

    @NotNull
    protected IElementType getUnicodeEscapeSequenceType() {
        int start;
        for (start = this.myStart + 2; start < this.myEnd && this.myBuffer.charAt(start) == 'u'; ++start) {
        }
        if (start + 3 >= this.myEnd) {
            IElementType iElementType = StringEscapesTokenTypes.INVALID_UNICODE_ESCAPE_TOKEN;
            if (iElementType == null) {
                JavaStringLiteralLexer.$$$reportNull$$$0(0);
            }
            return iElementType;
        }
        if (!(StringUtil.isHexDigit((char)this.myBuffer.charAt(start)) && StringUtil.isHexDigit((char)this.myBuffer.charAt(start + 1)) && StringUtil.isHexDigit((char)this.myBuffer.charAt(start + 2)) && StringUtil.isHexDigit((char)this.myBuffer.charAt(start + 3)))) {
            IElementType iElementType = StringEscapesTokenTypes.INVALID_UNICODE_ESCAPE_TOKEN;
            if (iElementType == null) {
                JavaStringLiteralLexer.$$$reportNull$$$0(1);
            }
            return iElementType;
        }
        IElementType iElementType = StringEscapesTokenTypes.VALID_STRING_ESCAPE_TOKEN;
        if (iElementType == null) {
            JavaStringLiteralLexer.$$$reportNull$$$0(2);
        }
        return iElementType;
    }

    protected int locateUnicodeEscapeSequence(int start, int i) {
        while (++i < this.myBufferEnd && this.myBuffer.charAt(i) == 'u') {
        }
        int end = this.parseUnicodeDigits(i);
        if (end != i + 4) {
            return end;
        }
        int code = Integer.parseInt(this.myBuffer.subSequence(i, end).toString(), 16);
        i = end;
        if (code != 92 || i >= this.myBufferEnd) {
            return i;
        }
        char c = this.myBuffer.charAt(i);
        if (StringUtil.isOctalDigit((char)c)) {
            if (i + 2 < this.myBufferEnd && StringUtil.isOctalDigit((char)this.myBuffer.charAt(i + 1)) && StringUtil.isOctalDigit((char)this.myBuffer.charAt(i + 2))) {
                return i + 3;
            }
        } else if (c == '\\' && i + 1 < this.myBufferEnd && this.myBuffer.charAt(i + 1) == 'u') {
            i += 2;
            while (i < this.myBufferEnd && this.myBuffer.charAt(i) == 'u') {
                ++i;
            }
            return this.parseUnicodeDigits(i);
        }
        return i + 1;
    }

    private int parseUnicodeDigits(int i) {
        int end = i + 4;
        while (i < end) {
            if (i == this.myBufferEnd) {
                return i;
            }
            if (!StringUtil.isHexDigit((char)this.myBuffer.charAt(i))) {
                return i;
            }
            ++i;
        }
        return end;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lexer/JavaStringLiteralLexer", "getUnicodeEscapeSequenceType"));
    }
}

