/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.formatter.java;

import com.intellij.lang.ASTNode;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.codeStyle.JavaCodeStyleSettings;
import com.intellij.psi.formatter.FormatterUtil;
import com.intellij.psi.impl.source.tree.JavaElementType;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0007J\u0010\u0010\n\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\u0010\u0010\u000b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0012\u0010\f\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u00a8\u0006\r"}, d2={"Lcom/intellij/psi/formatter/java/JavaFormatterRecordUtil;", "", "<init>", "()V", "shouldAdjustIndentForRecordComponentChild", "", "node", "Lcom/intellij/lang/ASTNode;", "javaSettings", "Lcom/intellij/psi/codeStyle/JavaCodeStyleSettings;", "isInRecordComponent", "isInFirstRecordComponent", "findRecordComponent", "intellij.java.frontback.impl"})
public final class JavaFormatterRecordUtil {
    @NotNull
    public static final JavaFormatterRecordUtil INSTANCE = new JavaFormatterRecordUtil();

    private JavaFormatterRecordUtil() {
    }

    @JvmStatic
    public static final boolean shouldAdjustIndentForRecordComponentChild(@NotNull ASTNode node, @NotNull JavaCodeStyleSettings javaSettings) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Intrinsics.checkNotNullParameter((Object)javaSettings, (String)"javaSettings");
        if (javaSettings.NEW_LINE_AFTER_LPAREN_IN_RECORD_HEADER || javaSettings.ALIGN_MULTILINE_RECORDS || javaSettings.RECORD_COMPONENTS_WRAP != 2 || !javaSettings.ANNOTATION_NEW_LINE_IN_RECORD_COMPONENT) {
            return false;
        }
        return INSTANCE.isInFirstRecordComponent(node);
    }

    @JvmStatic
    public static final boolean isInRecordComponent(@NotNull ASTNode node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        return INSTANCE.findRecordComponent(node) != null;
    }

    private final boolean isInFirstRecordComponent(ASTNode node) {
        ASTNode prev;
        ASTNode aSTNode = this.findRecordComponent(node);
        if (aSTNode == null) {
            return false;
        }
        ASTNode parent = aSTNode;
        ASTNode aSTNode2 = prev = FormatterUtil.getPreviousNonWhitespaceSibling((ASTNode)parent);
        return Intrinsics.areEqual((Object)(aSTNode2 != null ? aSTNode2.getElementType() : null), (Object)JavaTokenType.LPARENTH);
    }

    private final ASTNode findRecordComponent(ASTNode node) {
        ASTNode aSTNode = node.getTreeParent();
        if (aSTNode == null) {
            return null;
        }
        ASTNode parent = aSTNode;
        if (Intrinsics.areEqual((Object)parent.getElementType(), (Object)JavaElementType.RECORD_COMPONENT)) {
            return parent;
        }
        if (!Intrinsics.areEqual((Object)parent.getElementType(), (Object)JavaElementType.MODIFIER_LIST)) {
            return null;
        }
        ASTNode aSTNode2 = parent.getTreeParent();
        if (aSTNode2 == null) {
            return null;
        }
        ASTNode grandParent = aSTNode2;
        return Intrinsics.areEqual((Object)grandParent.getElementType(), (Object)JavaElementType.RECORD_COMPONENT) ? grandParent : null;
    }
}

