/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.dependency.kotlin;

import java.util.Collections;
import java.util.EnumSet;
import java.util.Objects;
import java.util.function.Function;
import kotlin.metadata.Attributes;
import kotlin.metadata.KmClass;
import kotlin.metadata.KmDeclarationContainer;
import kotlin.metadata.KmFunction;
import kotlin.metadata.KmPackage;
import kotlin.metadata.KmProperty;
import kotlin.metadata.KmPropertyAccessorAttributes;
import kotlin.metadata.KmTypeAlias;
import kotlin.metadata.Modality;
import kotlin.metadata.Visibility;
import kotlin.metadata.jvm.JvmExtensionsKt;
import kotlin.metadata.jvm.JvmMethodSignature;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.dependency.Node;
import org.jetbrains.jps.dependency.ReferenceID;
import org.jetbrains.jps.dependency.java.JVMClassNode;
import org.jetbrains.jps.dependency.java.JvmClass;
import org.jetbrains.jps.dependency.java.JvmMethod;
import org.jetbrains.jps.dependency.java.JvmNodeReferenceID;
import org.jetbrains.jps.dependency.java.KotlinMeta;
import org.jetbrains.jps.dependency.java.Utils;
import org.jetbrains.jps.util.Iterators;

final class KJvmUtils {
    private static final EnumSet<Visibility> PRIVATE_VISIBILITY = EnumSet.of(Visibility.LOCAL, Visibility.PRIVATE_TO_THIS, Visibility.PRIVATE);

    KJvmUtils() {
    }

    static boolean isSealed(JvmClass cls) {
        return KJvmUtils.isSealed(KJvmUtils.getDeclarationContainer(cls));
    }

    static boolean isSealed(KmDeclarationContainer container) {
        return container instanceof KmClass && Attributes.getModality((KmClass)((KmClass)container)) == Modality.SEALED;
    }

    static Iterable<KmFunction> allKmFunctions(Node<?, ?> node) {
        KotlinMeta meta = KJvmUtils.getKotlinMeta(node);
        return meta != null ? meta.getKmFunctions() : Collections.emptyList();
    }

    static Iterable<KmProperty> allKmProperties(Node<?, ?> node) {
        KotlinMeta meta = KJvmUtils.getKotlinMeta(node);
        return meta != null ? meta.getKmProperties() : Collections.emptyList();
    }

    @Nullable
    static String getKotlinName(JvmNodeReferenceID cls, Utils utils) {
        return Iterators.find(Iterators.map(utils.getNodes(cls, JvmClass.class), c -> KJvmUtils.getKotlinName(c)), Objects::nonNull);
    }

    @Nullable
    static String getKotlinName(JvmClass cls) {
        KmDeclarationContainer container = KJvmUtils.getDeclarationContainer(cls);
        if (container instanceof KmPackage) {
            return cls.getPackageName();
        }
        if (container instanceof KmClass) {
            return ((KmClass)container).getName().replace('.', '/');
        }
        return null;
    }

    static String getMethodKotlinName(JvmClass cls, JvmMethod method) {
        JvmMethodSignature sig = new JvmMethodSignature(method.getName(), method.getDescriptor());
        for (KmFunction f : KJvmUtils.allKmFunctions(cls)) {
            if (!sig.equals((Object)JvmExtensionsKt.getSignature((KmFunction)f))) continue;
            return f.getName();
        }
        if (method.isSynthetic()) {
            for (KmProperty p : KJvmUtils.allKmProperties(cls)) {
                if (sig.equals((Object)JvmExtensionsKt.getSyntheticMethodForAnnotations((KmProperty)p))) {
                    return p.getName();
                }
                if (!sig.equals((Object)JvmExtensionsKt.getSyntheticMethodForDelegate((KmProperty)p))) continue;
                return p.getName();
            }
        }
        return method.getName();
    }

    static boolean isDeclaresDefaultValue(KmFunction f) {
        return Iterators.find(f.getValueParameters(), Attributes::getDeclaresDefaultValue) != null;
    }

    static KmDeclarationContainer getDeclarationContainer(Node<?, ?> node) {
        KotlinMeta meta = KJvmUtils.getKotlinMeta(node);
        return meta != null ? meta.getDeclarationContainer() : null;
    }

    static boolean isKotlinNode(Node<?, ?> node) {
        return KJvmUtils.getKotlinMeta(node) != null;
    }

    @Nullable
    static KotlinMeta getKotlinMeta(Node<?, ?> node) {
        return node instanceof JVMClassNode ? (KotlinMeta)Iterators.find(((JVMClassNode)node).getMetadata(), mt -> mt instanceof KotlinMeta) : null;
    }

    static boolean isInlinable(KmProperty prop) {
        return Attributes.isConst((KmProperty)prop) || Attributes.isInline((KmPropertyAccessorAttributes)prop.getGetter()) || prop.getSetter() != null && Attributes.isInline((KmPropertyAccessorAttributes)prop.getSetter());
    }

    static boolean isPrivate(KmTypeAlias ta) {
        return KJvmUtils.isPrivate(Attributes.getVisibility((KmTypeAlias)ta));
    }

    static boolean isPrivate(KmProperty prop) {
        return KJvmUtils.isPrivate(Attributes.getVisibility((KmProperty)prop));
    }

    static boolean isPrivate(KmFunction func) {
        return KJvmUtils.isPrivate(Attributes.getVisibility((KmFunction)func));
    }

    static boolean isPrivate(KmClass cl) {
        return KJvmUtils.isPrivate(Attributes.getVisibility((KmClass)cl));
    }

    static boolean isPrivate(Visibility vis) {
        return PRIVATE_VISIBILITY.contains(vis);
    }

    static Iterable<ReferenceID> withAllSubclassesIfSealed(Utils utils, ReferenceID sealedClassId) {
        Function<ReferenceID, Iterable> withSubclassesIfSealed = id -> Iterators.flat(Iterators.map(utils.getNodes((ReferenceID)id, JvmClass.class), n -> KJvmUtils.isSealed(n) ? utils.directSubclasses(n.getReferenceID()) : Collections.emptyList()));
        return Iterators.recurse(sealedClassId, withSubclassesIfSealed, true);
    }
}

