/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.annotator;

import com.intellij.codeInsight.intention.CommonIntentionAction;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtilKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.GroovyBundle;
import org.jetbrains.plugins.groovy.annotator.inspections.WrapWithParensQuickFix;
import org.jetbrains.plugins.groovy.lang.psi.GroovyElementTypes;
import org.jetbrains.plugins.groovy.lang.psi.GroovyElementVisitor;
import org.jetbrains.plugins.groovy.lang.psi.api.GrLambdaExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.GroovyResolveResult;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.GrListOrMap;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrField;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrArgumentLabel;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrNamedArgument;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrClosableBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrParenthesizedExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.literals.GrLiteral;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.path.GrCallExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod;
import org.jetbrains.plugins.groovy.lang.psi.util.CompileStaticUtil;
import org.jetbrains.plugins.groovy.transformations.immutable.GrImmutableUtils;
import org.jetbrains.plugins.groovy.transformations.impl.namedVariant.NamedParamData;
import org.jetbrains.plugins.groovy.transformations.impl.namedVariant.NamedParamsUtil;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\r\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0010\u0010\u000e\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0010\u0010\u0011\u001a\u00020\u00072\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0010\u0010\u0014\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/plugins/groovy/annotator/GroovyAnnotator25;", "Lorg/jetbrains/plugins/groovy/lang/psi/GroovyElementVisitor;", "holder", "Lcom/intellij/lang/annotation/AnnotationHolder;", "<init>", "(Lcom/intellij/lang/annotation/AnnotationHolder;)V", "visitMethod", "", "method", "Lorg/jetbrains/plugins/groovy/lang/psi/api/statements/typedef/members/GrMethod;", "visitField", "field", "Lorg/jetbrains/plugins/groovy/lang/psi/api/statements/GrField;", "immutableCheck", "visitCallExpression", "callExpression", "Lorg/jetbrains/plugins/groovy/lang/psi/api/statements/expressions/path/GrCallExpression;", "visitArgumentLabel", "argument", "Lorg/jetbrains/plugins/groovy/lang/psi/api/statements/arguments/GrArgumentLabel;", "checkRequiredNamedArguments", "isGroovyStringLiteral", "", "element", "Lcom/intellij/psi/PsiElement;", "intellij.groovy.psi"})
@SourceDebugExtension(value={"SMAP\nGroovyAnnotator25.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GroovyAnnotator25.kt\norg/jetbrains/plugins/groovy/annotator/GroovyAnnotator25\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 4 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 5 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 6 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,107:1\n1512#2:108\n1538#2,3:109\n1541#2,3:119\n1586#2:130\n1661#2,3:131\n777#2:149\n873#2,2:150\n383#3,7:112\n540#3:122\n525#3,6:123\n221#4:129\n222#4:134\n12033#5,10:135\n14060#5:145\n14061#5:147\n12043#5:148\n1#6:146\n*S KotlinDebug\n*F\n+ 1 GroovyAnnotator25.kt\norg/jetbrains/plugins/groovy/annotator/GroovyAnnotator25\n*L\n39#1:108\n39#1:109,3\n39#1:119,3\n41#1:130\n41#1:131,3\n94#1:149\n94#1:150,2\n39#1:112,7\n39#1:122\n39#1:123,6\n39#1:129\n39#1:134\n85#1:135,10\n85#1:145\n85#1:147\n85#1:148\n85#1:146\n*E\n"})
public final class GroovyAnnotator25
extends GroovyElementVisitor {
    @NotNull
    private final AnnotationHolder holder;

    public GroovyAnnotator25(@NotNull AnnotationHolder holder) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        this.holder = holder;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void visitMethod(@NotNull GrMethod method) {
        void $this$filterTo$iv$iv;
        Object key$iv$iv$iv;
        Object it;
        Object element$iv$iv;
        Map $this$groupByTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        Iterable $this$groupBy$iv = NamedParamsUtil.collectAllParamsFromNamedVariantMethod(method);
        boolean $i$f$groupBy = false;
        Object object = $this$groupBy$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        Iterator<Object> iterator2 = $this$groupByTo$iv$iv.iterator();
        while (iterator2.hasNext()) {
            Object object2;
            void $this$getOrPut$iv$iv$iv;
            element$iv$iv = iterator2.next();
            it = (Pair)element$iv$iv;
            boolean bl = false;
            String key$iv$iv = (String)it.getFirst();
            Map map2 = destination$iv$iv;
            key$iv$iv$iv = key$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl2 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv$iv, answer$iv$iv$iv);
                object2 = answer$iv$iv$iv;
            } else {
                object2 = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object2;
            list$iv$iv.add(element$iv$iv);
        }
        Map $this$filter$iv = destination$iv$iv;
        boolean $i$f$filter = false;
        $this$groupByTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new LinkedHashMap();
        boolean $i$f$filterTo = false;
        iterator2 = $this$filterTo$iv$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            it = element$iv$iv = (Map.Entry)iterator2.next();
            boolean bl = false;
            if (!(((List)it.getValue()).size() > 1)) continue;
            destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
        }
        Map $this$forEach$iv = destination$iv$iv;
        boolean $i$f$forEach = false;
        object = $this$forEach$iv.entrySet().iterator();
        while (object.hasNext()) {
            void $this$mapTo$iv$iv;
            Map.Entry element$iv;
            Map.Entry entry = element$iv = (Map.Entry)object.next();
            boolean bl = false;
            String name = (String)entry.getKey();
            List parameters = (List)entry.getValue();
            String parametersList = CollectionsKt.joinToString$default((Iterable)parameters, null, null, null, (int)0, null, GroovyAnnotator25::visitMethod$lambda$2$0, (int)31, null);
            Iterable $this$map$iv = CollectionsKt.drop((Iterable)parameters, (int)1);
            boolean $i$f$map = false;
            key$iv$iv$iv = $this$map$iv;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                Pair pair = (Pair)item$iv$iv;
                Collection collection = destination$iv$iv2;
                boolean bl3 = false;
                PsiParameter parameter = (PsiParameter)pair.component2();
                collection.add(parameter);
            }
            List duplicatingParameters = (List)destination$iv$iv2;
            for (PsiParameter parameter : duplicatingParameters) {
                PsiIdentifier nameIdentifier;
                if (parameter.getNameIdentifier() == null) continue;
                Object[] objectArray = new Object[]{name, parametersList};
                this.holder.newAnnotation(HighlightSeverity.ERROR, GroovyBundle.message("duplicating.named.parameter", objectArray)).range((PsiElement)nameIdentifier).create();
            }
        }
        super.visitMethod(method);
    }

    @Override
    public void visitField(@NotNull GrField field2) {
        Intrinsics.checkNotNullParameter((Object)field2, (String)"field");
        super.visitField(field2);
        this.immutableCheck(field2);
    }

    private final void immutableCheck(GrField field2) {
        PsiClass psiClass = field2.getContainingClass();
        if (psiClass == null) {
            return;
        }
        PsiClass containingClass = psiClass;
        if (!field2.hasModifierProperty("static") && GrImmutableUtils.hasImmutableAnnotation((PsiModifierListOwner)containingClass) && !GrImmutableUtils.isImmutable(field2)) {
            Object[] objectArray = new Object[]{field2.getName()};
            this.holder.newAnnotation(HighlightSeverity.ERROR, GroovyBundle.message("field.should.be.immutable", objectArray)).range(field2.getNameIdentifierGroovy()).create();
        }
    }

    @Override
    public void visitCallExpression(@NotNull GrCallExpression callExpression) {
        Intrinsics.checkNotNullParameter((Object)callExpression, (String)"callExpression");
        this.checkRequiredNamedArguments(callExpression);
        super.visitCallExpression(callExpression);
    }

    @Override
    public void visitArgumentLabel(@NotNull GrArgumentLabel argument) {
        Intrinsics.checkNotNullParameter((Object)argument, (String)"argument");
        PsiElement psiElement = argument.getNameElement();
        Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"getNameElement(...)");
        PsiElement element = psiElement;
        if (!(element instanceof GrExpression)) {
            return;
        }
        if (this.isGroovyStringLiteral(element)) {
            return;
        }
        if (element instanceof GrLiteral || element instanceof GrListOrMap || element instanceof GrLambdaExpression || element instanceof GrClosableBlock) {
            return;
        }
        if (element instanceof GrParenthesizedExpression) {
            return;
        }
        this.holder.newAnnotation(HighlightSeverity.ERROR, GroovyBundle.message("groovy.complex.argument.label.annotator.message", new Object[0])).range((PsiElement)argument).withFix((CommonIntentionAction)new WrapWithParensQuickFix((GrExpression)element)).create();
    }

    /*
     * WARNING - void declaration
     */
    private final void checkRequiredNamedArguments(GrCallExpression callExpression) {
        void $this$filterTo$iv$iv;
        Object it;
        void $this$mapNotNullTo$iv$iv;
        if (!CompileStaticUtil.isCompileStatic(callExpression)) {
            return;
        }
        GrNamedArgument[] grNamedArgumentArray = callExpression.getNamedArguments();
        Intrinsics.checkNotNullExpressionValue((Object)grNamedArgumentArray, (String)"getNamedArguments(...)");
        Object[] $this$mapNotNull$iv = grNamedArgumentArray;
        boolean $i$f$mapNotNull = false;
        Object[] objectArray = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        int n = ((void)$this$forEach$iv$iv$iv).length;
        for (int j = 0; j < n; ++j) {
            String it$iv$iv;
            void element$iv$iv$iv;
            void element$iv$iv = element$iv$iv$iv = $this$forEach$iv$iv$iv[j];
            boolean bl = false;
            it = (GrNamedArgument)element$iv$iv;
            boolean bl2 = false;
            if (it.getLabelName() == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        Set namedArguments = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
        if (namedArguments.isEmpty()) {
            return;
        }
        GroovyResolveResult groovyResolveResult = callExpression.advancedResolve();
        Intrinsics.checkNotNullExpressionValue((Object)groovyResolveResult, (String)"advancedResolve(...)");
        GroovyResolveResult resolveResult = groovyResolveResult;
        destination$iv$iv = resolveResult.getElement();
        PsiMethod psiMethod = destination$iv$iv instanceof PsiMethod ? (PsiMethod)destination$iv$iv : null;
        if (psiMethod == null) {
            return;
        }
        PsiMethod method = psiMethod;
        Object[] objectArray2 = method.getParameterList().getParameters();
        Intrinsics.checkNotNullExpressionValue((Object)objectArray2, (String)"getParameters(...)");
        Object[] parameters = objectArray2;
        PsiParameter psiParameter = (PsiParameter)ArraysKt.firstOrNull((Object[])parameters);
        if (psiParameter == null) {
            return;
        }
        PsiParameter mapParameter = psiParameter;
        Iterable $this$filter$iv = NamedParamsUtil.collectNamedParams(mapParameter);
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (NamedParamData)element$iv$iv;
            boolean bl = false;
            if (!((NamedParamData)it).getRequired()) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        List requiredNamedParams = (List)destination$iv$iv2;
        for (NamedParamData namedParam : requiredNamedParams) {
            String message;
            if (namedArguments.contains(namedParam.getName())) continue;
            Object[] objectArray3 = new Object[]{namedParam.getName()};
            Intrinsics.checkNotNullExpressionValue((Object)GroovyBundle.message("missing.required.named.parameter", objectArray3), (String)"message(...)");
            this.holder.newAnnotation(HighlightSeverity.ERROR, message).create();
        }
    }

    private final boolean isGroovyStringLiteral(PsiElement element) {
        IElementType it = PsiTreeUtilKt.getElementType((PsiElement)element);
        boolean bl = false;
        return Intrinsics.areEqual((Object)it, (Object)GroovyElementTypes.STRING_SQ) || Intrinsics.areEqual((Object)it, (Object)GroovyElementTypes.STRING_DQ) || Intrinsics.areEqual((Object)it, (Object)GroovyElementTypes.STRING_TSQ) || Intrinsics.areEqual((Object)it, (Object)GroovyElementTypes.STRING_TDQ);
    }

    private static final CharSequence visitMethod$lambda$2$0(Pair it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return "'" + ((PsiParameter)it.getSecond()).getName() + "'";
    }
}

