/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.annotator.intentions;

import com.intellij.codeInsight.intention.FileModifier;
import com.intellij.modcommand.ActionContext;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.Presentation;
import com.intellij.modcommand.PsiUpdateModCommandAction;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiModifier;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.GroovyBundle;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.GrModifier;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.GrModifierList;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B3\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u0012\b\b\u0001\u0010\u0007\u001a\u00020\u0005\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\b\u0010\f\u001a\u00020\u0005H\u0016J\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0002H\u0014J!\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00022\u0006\u0010\u0014\u001a\u00020\u0015H\u0094\u0002R\u0016\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048\u0002X\u0083\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/plugins/groovy/annotator/intentions/GrChangeModifiersFix;", "Lcom/intellij/modcommand/PsiUpdateModCommandAction;", "Lcom/intellij/psi/PsiElement;", "modifiersToRemove", "", "", "modifierToInsert", "textRepresentation", "removeModifierUnderCaret", "", "<init>", "(Ljava/util/List;Ljava/lang/String;Ljava/lang/String;Z)V", "getFamilyName", "getPresentation", "Lcom/intellij/modcommand/Presentation;", "context", "Lcom/intellij/modcommand/ActionContext;", "element", "invoke", "", "updater", "Lcom/intellij/modcommand/ModPsiUpdater;", "intellij.groovy.psi"})
@SourceDebugExtension(value={"SMAP\nGrChangeModifiersFix.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GrChangeModifiersFix.kt\norg/jetbrains/plugins/groovy/annotator/intentions/GrChangeModifiersFix\n+ 2 psiTreeUtil.kt\ncom/intellij/psi/util/PsiTreeUtilKt\n+ 3 KtUtils.kt\ncom/intellij/util/KotlinUtils\n*L\n1#1,60:1\n66#2,2:61\n18#3:63\n*S KotlinDebug\n*F\n+ 1 GrChangeModifiersFix.kt\norg/jetbrains/plugins/groovy/annotator/intentions/GrChangeModifiersFix\n*L\n33#1:61,2\n35#1:63\n*E\n"})
public final class GrChangeModifiersFix
extends PsiUpdateModCommandAction<PsiElement> {
    @FileModifier.SafeFieldForPreview
    @NotNull
    private final List<String> modifiersToRemove;
    @Nullable
    private final String modifierToInsert;
    @NotNull
    private final String textRepresentation;
    private final boolean removeModifierUnderCaret;

    public GrChangeModifiersFix(@NotNull List<String> modifiersToRemove, @Nullable String modifierToInsert, @Nls @NotNull String textRepresentation, boolean removeModifierUnderCaret) {
        Intrinsics.checkNotNullParameter(modifiersToRemove, (String)"modifiersToRemove");
        Intrinsics.checkNotNullParameter((Object)textRepresentation, (String)"textRepresentation");
        super(PsiElement.class);
        this.modifiersToRemove = modifiersToRemove;
        this.modifierToInsert = modifierToInsert;
        this.textRepresentation = textRepresentation;
        this.removeModifierUnderCaret = removeModifierUnderCaret;
    }

    public /* synthetic */ GrChangeModifiersFix(List list, String string, String string2, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            bl = false;
        }
        this(list, string, string2, bl);
    }

    @NotNull
    public String getFamilyName() {
        String string = GroovyBundle.message("intention.family.name.replace.modifiers", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    @NotNull
    protected Presentation getPresentation(@NotNull ActionContext context, @NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Presentation presentation = Presentation.of((String)this.textRepresentation);
        Intrinsics.checkNotNullExpressionValue((Object)presentation, (String)"of(...)");
        return presentation;
    }

    protected void invoke(@NotNull ActionContext context, @NotNull PsiElement element, @NotNull ModPsiUpdater updater) {
        block10: {
            PsiModifierListOwner owner;
            block12: {
                block11: {
                    PsiElement[] psiElementArray;
                    String elementUnderCaretRepresentation;
                    block9: {
                        block8: {
                            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
                            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                            Intrinsics.checkNotNullParameter((Object)updater, (String)"updater");
                            PsiElement $this$parentOfType_u24default$iv = element;
                            boolean withSelf$iv = false;
                            boolean $i$f$parentOfType = false;
                            PsiModifierListOwner psiModifierListOwner = (PsiModifierListOwner)PsiTreeUtil.getParentOfType((PsiElement)$this$parentOfType_u24default$iv, PsiModifierListOwner.class, (boolean)true);
                            if (psiModifierListOwner == null) {
                                return;
                            }
                            owner = psiModifierListOwner;
                            elementUnderCaretRepresentation = element.getText();
                            psiElementArray = owner.getModifierList();
                            if (psiElementArray == null) break block8;
                            PsiElement[] $this$asSafely$iv = psiElementArray;
                            boolean $i$f$asSafely = false;
                            PsiElement[] psiElementArray2 = $this$asSafely$iv;
                            if (!($this$asSafely$iv instanceof GrModifierList)) {
                                psiElementArray2 = null;
                            }
                            if ((psiElementArray = (PsiElement[])psiElementArray2) != null && (psiElementArray = psiElementArray.getModifiers()) != null) break block9;
                        }
                        return;
                    }
                    PsiElement[] modifiers = psiElementArray;
                    boolean hasRequiredModifier = false;
                    for (PsiElement modifier : modifiers) {
                        String modifierRepresentation;
                        String string = modifierRepresentation = modifier instanceof PsiAnnotation ? ((PsiAnnotation)modifier).getQualifiedName() : modifier.getText();
                        if (Intrinsics.areEqual((Object)modifierRepresentation, (Object)this.modifierToInsert)) {
                            hasRequiredModifier = true;
                        }
                        if (!this.removeModifierUnderCaret && Intrinsics.areEqual((Object)modifierRepresentation, (Object)elementUnderCaretRepresentation) || !CollectionsKt.contains((Iterable)this.modifiersToRemove, (Object)modifierRepresentation)) continue;
                        modifier.delete();
                    }
                    if (hasRequiredModifier || this.modifierToInsert == null) break block10;
                    Intrinsics.checkNotNullExpressionValue((Object)GrModifier.GROOVY_MODIFIERS, (String)"GROOVY_MODIFIERS");
                    if (ArraysKt.contains((Object[])GrModifier.GROOVY_MODIFIERS, (Object)this.modifierToInsert)) break block11;
                    Intrinsics.checkNotNullExpressionValue((Object)PsiModifier.MODIFIERS, (String)"MODIFIERS");
                    if (!ArraysKt.contains((Object[])PsiModifier.MODIFIERS, (Object)this.modifierToInsert)) break block12;
                }
                PsiModifierList psiModifierList = owner.getModifierList();
                if (psiModifierList == null) break block10;
                psiModifierList.setModifierProperty(this.modifierToInsert, true);
                break block10;
            }
            PsiModifierList psiModifierList = owner.getModifierList();
            if (psiModifierList == null) break block10;
            psiModifierList.addAnnotation(this.modifierToInsert);
        }
    }
}

