/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.intentions.conversions.strings;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pass;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.IntroduceTargetChooser;
import com.intellij.util.IncorrectOperationException;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.intentions.base.Intention;
import org.jetbrains.plugins.groovy.intentions.base.PsiElementPredicate;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElement;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;
import org.jetbrains.plugins.groovy.lang.psi.GroovyRecursiveElementVisitor;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrBinaryExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.literals.GrLiteral;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.literals.GrString;
import org.jetbrains.plugins.groovy.lang.psi.util.GrStringUtil;
import org.jetbrains.plugins.groovy.util.GStringConcatenationUtil;

public final class ConvertConcatenationToGstringIntention
extends Intention {
    @Override
    @NotNull
    protected PsiElementPredicate getElementPredicate() {
        return new GStringConcatenationUtil.ConvertibleToGStringPredicate();
    }

    private static List<GrExpression> collectExpressions(PsiFile file, int offset) {
        ArrayList<GrExpression> expressions = new ArrayList<GrExpression>();
        ConvertConcatenationToGstringIntention._collect(file, offset, expressions);
        if (expressions.isEmpty()) {
            ConvertConcatenationToGstringIntention._collect(file, offset, expressions);
        }
        return expressions;
    }

    private static void _collect(PsiFile file, int offset, List<GrExpression> expressions) {
        PsiElement elementAtCaret = file.findElementAt(offset);
        GrExpression expression = (GrExpression)PsiTreeUtil.getParentOfType((PsiElement)elementAtCaret, GrExpression.class);
        while (expression != null) {
            if (GStringConcatenationUtil.ConvertibleToGStringPredicate.satisfied(expression)) {
                expressions.add(expression);
            } else if (!expressions.isEmpty()) break;
            expression = (GrExpression)PsiTreeUtil.getParentOfType((PsiElement)expression, GrExpression.class);
        }
    }

    @Nullable
    public PsiElement getElementToMakeWritable(@NotNull PsiFile file) {
        if (file == null) {
            ConvertConcatenationToGstringIntention.$$$reportNull$$$0(0);
        }
        return file;
    }

    @Override
    public boolean startInWriteAction() {
        return false;
    }

    @Override
    protected void processIntention(@NotNull PsiElement element, @NotNull Project project, Editor editor) throws IncorrectOperationException {
        if (element == null) {
            ConvertConcatenationToGstringIntention.$$$reportNull$$$0(1);
        }
        if (project == null) {
            ConvertConcatenationToGstringIntention.$$$reportNull$$$0(2);
        }
        PsiFile file = element.getContainingFile();
        int offset = editor.getCaretModel().getOffset();
        List expressions = (List)ReadAction.compute(() -> ConvertConcatenationToGstringIntention.collectExpressions(file, offset));
        final Document document = editor.getDocument();
        if (expressions.size() == 1) {
            ConvertConcatenationToGstringIntention.invokeImpl((PsiElement)expressions.getFirst(), document);
        } else if (!expressions.isEmpty()) {
            if (ApplicationManager.getApplication().isUnitTestMode()) {
                ConvertConcatenationToGstringIntention.invokeImpl((PsiElement)expressions.getLast(), document);
                return;
            }
            IntroduceTargetChooser.showChooser((Editor)editor, (List)expressions, (Pass)new Pass<GrExpression>(this){

                public void pass(GrExpression selectedValue) {
                    ConvertConcatenationToGstringIntention.invokeImpl(selectedValue, document);
                }
            }, grExpression -> grExpression.getText());
        }
    }

    private static void invokeImpl(PsiElement element, Document document) {
        boolean isMultiline = ConvertConcatenationToGstringIntention.containsMultilineStrings((GrExpression)element);
        StringBuilder builder = new StringBuilder(element.getTextLength());
        if (element instanceof GrBinaryExpression) {
            GStringConcatenationUtil.convertToGString((GrBinaryExpression)element, builder, isMultiline);
        } else if (element instanceof GrLiteral) {
            GStringConcatenationUtil.appendOperandText((GrExpression)element, builder, isMultiline);
        } else {
            return;
        }
        String text = builder.toString();
        GroovyPsiElementFactory factory = GroovyPsiElementFactory.getInstance(element.getProject());
        GrExpression newExpr = factory.createExpressionFromText(GrStringUtil.addQuotes(text, true));
        CommandProcessor.getInstance().executeCommand(element.getProject(), () -> WriteAction.run(() -> {
            GrExpression expression = ((GrExpression)element).replaceWithExpression(newExpr, true);
            if (expression instanceof GrString) {
                GrStringUtil.removeUnnecessaryBracesInGString((GrString)expression);
            }
        }), null, null, document);
    }

    private static boolean containsMultilineStrings(GrExpression expr) {
        final Ref result2 = Ref.create((Object)false);
        expr.accept(new GroovyRecursiveElementVisitor(){

            @Override
            public void visitLiteralExpression(@NotNull GrLiteral literal) {
                if (literal == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (GrStringUtil.isMultilineStringLiteral(literal) && literal.getText().contains("\n")) {
                    result2.set((Object)true);
                }
            }

            @Override
            public void visitElement(@NotNull GroovyPsiElement element) {
                if (element == null) {
                    2.$$$reportNull$$$0(1);
                }
                if (!((Boolean)result2.get()).booleanValue()) {
                    super.visitElement(element);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "literal";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "element";
                        break;
                    }
                }
                objectArray2[1] = "org/jetbrains/plugins/groovy/intentions/conversions/strings/ConvertConcatenationToGstringIntention$2";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitLiteralExpression";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitElement";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        return (Boolean)result2.get();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/groovy/intentions/conversions/strings/ConvertConcatenationToGstringIntention";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getElementToMakeWritable";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "processIntention";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

