/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.jvm;

import com.intellij.lang.jvm.JvmElement;
import com.intellij.lang.jvm.source.JvmDeclarationSearcher;
import com.intellij.psi.PsiElement;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.GrNamedElement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrAnonymousClassDefinition;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod;
import org.jetbrains.plugins.groovy.lang.psi.impl.PsiImplUtil;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0012\u0010\t\u001a\u0004\u0018\u00010\b2\u0006\u0010\n\u001a\u00020\bH\u0016\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/plugins/groovy/jvm/GroovyDeclarationSearcher;", "Lcom/intellij/lang/jvm/source/JvmDeclarationSearcher;", "<init>", "()V", "findDeclarations", "", "Lcom/intellij/lang/jvm/JvmElement;", "declaringElement", "Lcom/intellij/psi/PsiElement;", "adjustIdentifierElement", "identifierElement", "intellij.groovy"})
public final class GroovyDeclarationSearcher
implements JvmDeclarationSearcher {
    @NotNull
    public Collection<JvmElement> findDeclarations(@NotNull PsiElement declaringElement) {
        Collection collection;
        Intrinsics.checkNotNullParameter((Object)declaringElement, (String)"declaringElement");
        if (declaringElement instanceof GrMethod) {
            GrMethod[] grMethodArray = PsiImplUtil.getMethodOrReflectedMethods((GrMethod)declaringElement);
            Intrinsics.checkNotNullExpressionValue((Object)grMethodArray, (String)"getMethodOrReflectedMethods(...)");
            collection = ArraysKt.toList((Object[])grMethodArray);
        } else {
            collection = declaringElement instanceof GrNamedElement && declaringElement instanceof JvmElement ? (Collection)CollectionsKt.listOf((Object)declaringElement) : (Collection)CollectionsKt.emptyList();
        }
        return collection;
    }

    @Nullable
    public PsiElement adjustIdentifierElement(@NotNull PsiElement identifierElement) {
        GrAnonymousClassDefinition parent;
        Intrinsics.checkNotNullParameter((Object)identifierElement, (String)"identifierElement");
        PsiElement psiElement = identifierElement.getParent();
        GrAnonymousClassDefinition grAnonymousClassDefinition = parent = psiElement instanceof GrAnonymousClassDefinition ? (GrAnonymousClassDefinition)psiElement : null;
        return (grAnonymousClassDefinition != null ? grAnonymousClassDefinition.getBaseClassReferenceGroovy() : null) == identifierElement ? (PsiElement)parent : null;
    }
}

