/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.typing;

import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiTreeUtil;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.api.GrFunctionalExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.GroovyReference;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.resolve.delegatesTo.DelegatesToInfo;
import org.jetbrains.plugins.groovy.lang.resolve.delegatesTo.GrDelegatesToUtilKt;
import org.jetbrains.plugins.groovy.lang.typing.GrTypeCalculator;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0012\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\u0002H\u0016\u00a8\u0006\b"}, d2={"Lorg/jetbrains/plugins/groovy/lang/typing/GrClosureOwnerDelegateTypeCalculator;", "Lorg/jetbrains/plugins/groovy/lang/typing/GrTypeCalculator;", "Lorg/jetbrains/plugins/groovy/lang/psi/api/statements/expressions/GrReferenceExpression;", "<init>", "()V", "getType", "Lcom/intellij/psi/PsiType;", "expression", "intellij.groovy.psi"})
public final class GrClosureOwnerDelegateTypeCalculator
implements GrTypeCalculator<GrReferenceExpression> {
    @Override
    @Nullable
    public PsiType getType(@NotNull GrReferenceExpression expression) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
        GroovyReference groovyReference = expression.getRValueReference();
        PsiElement psiElement = groovyReference != null ? groovyReference.resolve() : null;
        PsiMethod psiMethod = psiElement instanceof PsiMethod ? (PsiMethod)psiElement : null;
        if (psiMethod == null) {
            return null;
        }
        PsiMethod method = psiMethod;
        String string = method.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        String methodName = string;
        boolean delegate = Intrinsics.areEqual((Object)"getDelegate", (Object)methodName);
        if (!delegate && !Intrinsics.areEqual((Object)"getOwner", (Object)methodName)) {
            return null;
        }
        if (method.getParameterList().getParametersCount() != 0) {
            return null;
        }
        PsiClass closureClass = JavaPsiFacade.getInstance((Project)expression.getProject()).findClass("groovy.lang.Closure", expression.getResolveScope());
        if (closureClass == null || !Intrinsics.areEqual((Object)closureClass, (Object)method.getContainingClass())) {
            return null;
        }
        GrFunctionalExpression grFunctionalExpression = (GrFunctionalExpression)PsiTreeUtil.getParentOfType((PsiElement)expression, GrFunctionalExpression.class);
        if (grFunctionalExpression == null) {
            return null;
        }
        GrFunctionalExpression functionalExpression = grFunctionalExpression;
        if (delegate) {
            DelegatesToInfo delegatesToInfo = GrDelegatesToUtilKt.getDelegatesToInfo(functionalExpression);
            object = delegatesToInfo != null ? delegatesToInfo.getTypeToDelegate() : null;
        } else {
            object = functionalExpression.getOwnerType();
        }
        return object;
    }
}

