/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.refactoring.inline;

import com.intellij.java.refactoring.JavaRefactoringBundle;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.PsiFormatUtil;
import com.intellij.refactoring.JavaRefactoringSettings;
import com.intellij.refactoring.inline.InlineOptionsDialog;
import org.jetbrains.annotations.Nls;

final class InlineGroovyFieldDialog
extends InlineOptionsDialog {
    private final PsiField myField;

    InlineGroovyFieldDialog(Project project, PsiField field2, boolean invokedOnReference) {
        super(project, true, (PsiElement)field2);
        this.myField = field2;
        this.myInvokedOnReference = invokedOnReference;
        this.setTitle(InlineGroovyFieldDialog.getRefactoringName());
        this.init();
    }

    protected String getNameLabelText() {
        int options = this.myInvokedOnReference ? 4097 : 1;
        String fieldText = PsiFormatUtil.formatVariable((PsiVariable)this.myField, (int)options, (PsiSubstitutor)PsiSubstitutor.EMPTY);
        return JavaRefactoringBundle.message((String)"inline.field.field.name.label", (Object[])new Object[]{fieldText});
    }

    protected String getInlineThisText() {
        return JavaRefactoringBundle.message((String)"this.reference.only.and.keep.the.field", (Object[])new Object[0]);
    }

    protected String getInlineAllText() {
        return JavaRefactoringBundle.message((String)"all.references.and.remove.the.field", (Object[])new Object[0]);
    }

    protected boolean isInlineThis() {
        return JavaRefactoringSettings.getInstance().INLINE_FIELD_THIS;
    }

    protected void doAction() {
        if (this.getOKAction().isEnabled()) {
            JavaRefactoringSettings settings = JavaRefactoringSettings.getInstance();
            if (this.myRbInlineThisOnly.isEnabled() && this.myRbInlineAll.isEnabled()) {
                settings.INLINE_FIELD_THIS = this.isInlineThisOnly();
            }
            this.close(0);
        }
    }

    protected String getHelpId() {
        return "refactoring.inlineField";
    }

    @Nls(capitalization=Nls.Capitalization.Title)
    public static String getRefactoringName() {
        return JavaRefactoringBundle.message((String)"inline.field.title", (Object[])new Object[0]);
    }
}

