/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.refactoring.rename;

import com.intellij.lang.Language;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.refactoring.JavaRefactoringSettings;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.rename.naming.AutomaticParametersRenamer;
import com.intellij.refactoring.rename.naming.AutomaticRenamer;
import com.intellij.refactoring.rename.naming.AutomaticRenamerFactory;
import com.intellij.usageView.UsageInfo;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.GroovyLanguage;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J.\u0010\b\u001a\u00020\t2\b\u0010\u0006\u001a\u0004\u0018\u00010\u00072\b\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0010\u0010\f\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\u000e\u0018\u00010\rH\u0016J\b\u0010\u000f\u001a\u00020\u0005H\u0016J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0005H\u0016J\r\u0010\u0013\u001a\u00070\u000b\u00a2\u0006\u0002\b\u0014H\u0016\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/plugins/groovy/refactoring/rename/GroovyAutomaticParametersRenamerFactory;", "Lcom/intellij/refactoring/rename/naming/AutomaticRenamerFactory;", "<init>", "()V", "isApplicable", "", "element", "Lcom/intellij/psi/PsiElement;", "createRenamer", "Lcom/intellij/refactoring/rename/naming/AutomaticRenamer;", "newName", "", "usages", "", "Lcom/intellij/usageView/UsageInfo;", "isEnabled", "setEnabled", "", "enabled", "getOptionName", "Lcom/intellij/openapi/util/NlsContexts$Checkbox;", "intellij.groovy"})
public final class GroovyAutomaticParametersRenamerFactory
implements AutomaticRenamerFactory {
    public boolean isApplicable(@NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        if (!(element instanceof PsiParameter)) {
            return false;
        }
        PsiElement psiElement = ((PsiParameter)element).getDeclarationScope();
        Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"getDeclarationScope(...)");
        PsiElement declarationScope = psiElement;
        return declarationScope instanceof PsiMethod && !((PsiMethod)declarationScope).hasModifierProperty("static");
    }

    @NotNull
    public AutomaticRenamer createRenamer(@Nullable PsiElement element, @Nullable String newName, @Nullable Collection<? extends UsageInfo> usages) {
        Intrinsics.checkNotNull((Object)element, (String)"null cannot be cast to non-null type com.intellij.psi.PsiParameter");
        return (AutomaticRenamer)new AutomaticParametersRenamer((PsiParameter)element, newName, (Language)GroovyLanguage.INSTANCE);
    }

    public boolean isEnabled() {
        return JavaRefactoringSettings.getInstance().isRenameParameterInHierarchy();
    }

    public void setEnabled(boolean enabled) {
        JavaRefactoringSettings.getInstance().setRenameParameterInHierarchy(enabled);
    }

    @NotNull
    public String getOptionName() {
        String string = RefactoringBundle.message((String)"rename.parameters.hierarchy");
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }
}

