/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.httpClient.http.request;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.util.IntellijInternalApi;
import com.intellij.util.concurrency.AppExecutorUtil;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.util.NettyRuntime;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Service
@IntellijInternalApi
@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u000b\u001a\u00020\fH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0006\u001a\u00070\u0007\u00a2\u0006\u0002\b\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u00020\n8\u0000X\u0081\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/intellij/httpClient/http/request/HttpClientEventLoopHolder;", "Lcom/intellij/openapi/Disposable;", "<init>", "()V", "maxThreads", "", "executor", "Ljava/util/concurrent/ExecutorService;", "Lorg/jetbrains/annotations/NotNull;", "eventLoop", "Lio/netty/channel/nio/NioEventLoopGroup;", "dispose", "", "intellij.httpClient.executor"})
@ApiStatus.Internal
public final class HttpClientEventLoopHolder
implements Disposable {
    private final int maxThreads = NettyRuntime.availableProcessors();
    @NotNull
    private final ExecutorService executor;
    @JvmField
    @NotNull
    public final NioEventLoopGroup eventLoop;

    public HttpClientEventLoopHolder() {
        ExecutorService executorService = AppExecutorUtil.createBoundedApplicationPoolExecutor((String)"Intellij HttpClient Reactor Netty Pool", (int)this.maxThreads);
        Intrinsics.checkNotNullExpressionValue((Object)executorService, (String)"createBoundedApplicationPoolExecutor(...)");
        this.executor = executorService;
        this.eventLoop = new NioEventLoopGroup(this.maxThreads, (Executor)this.executor);
    }

    public void dispose() {
        this.eventLoop.shutdownGracefully().get(10L, TimeUnit.SECONDS);
    }
}

