/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.httpClient.http.request.run.js.graalvm.crypto.rsa;

import com.intellij.httpClient.http.request.run.js.graalvm.StringUtilsKt;
import com.intellij.httpClient.http.request.run.js.graalvm.crypto.rsa.CryptoKey;
import com.intellij.httpClient.http.request.run.js.graalvm.crypto.rsa.EncryptionAlgorithm;
import com.intellij.httpClient.http.request.run.js.graalvm.crypto.rsa.JsCryptoKey;
import com.intellij.httpClient.http.request.run.js.graalvm.crypto.rsa.JsEcdsaCryptoKey;
import com.intellij.httpClient.http.request.run.js.graalvm.crypto.rsa.JsRsaCryptoKey;
import com.intellij.httpClient.http.request.run.js.graalvm.crypto.rsa.KeyAlgorithm;
import com.intellij.httpClient.http.request.run.js.graalvm.crypto.rsa.RsaCryptoSupportKt;
import com.intellij.httpClient.http.request.run.js.graalvm.crypto.rsa.SigningAlgorithm;
import java.io.Serializable;
import java.math.BigInteger;
import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyPairGenerator;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Signature;
import java.security.interfaces.RSAPrivateKey;
import java.security.spec.ECGenParameterSpec;
import java.security.spec.MGF1ParameterSpec;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.PSSParameterSpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.crypto.Cipher;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.bouncycastle.asn1.eac.RSAPublicKey;
import org.graalvm.polyglot.Value;
import org.graalvm.polyglot.proxy.ProxyArray;
import org.graalvm.polyglot.proxy.ProxyObject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J+\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b\u00a2\u0006\u0002\u0010\rJ\u001c\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\f2\n\u0010\u0011\u001a\u0006\u0012\u0002\b\u00030\u0012J$\u0010\u0013\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00122\u0006\u0010\u0010\u001a\u00020\f2\u0006\u0010\u0014\u001a\u00020\u000f2\u0006\u0010\u0015\u001a\u00020\u0007J&\u0010\u0016\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0015\u001a\u00020\u00172\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00190\u00182\u0006\u0010\u001a\u001a\u00020\u000fJ&\u0010\u001b\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0015\u001a\u00020\u00172\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u001c0\u00182\u0006\u0010\u001a\u001a\u00020\u000fJ&\u0010\u001d\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u001e\u001a\u00020\u001f2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u001c0\u00122\u0006\u0010\u001a\u001a\u00020\u000fJ,\u0010 \u001a\u00020\t2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010!\u001a\u00020\u000f2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00190\u00122\u0006\u0010\u001a\u001a\u00020\u000fJ\u0012\u0010\"\u001a\u0004\u0018\u00010#2\u0006\u0010\u0011\u001a\u00020\fH\u0016J\u0012\u0010$\u001a\u0006\u0012\u0002\b\u00030\u0012*\u0004\u0018\u00010%H\u0002J!\u0010&\u001a\u0004\u0018\u00010\u001f2\u0010\u0010'\u001a\f\u0012\u0006\b\u0001\u0012\u00020%\u0018\u00010\u000bH\u0002\u00a2\u0006\u0002\u0010(J\u0013\u0010)\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u0016\u00a2\u0006\u0002\u0010*J\u0010\u0010+\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020\fH\u0016J\u001c\u0010,\u001a\u00020-2\b\u0010\u0011\u001a\u0004\u0018\u00010\f2\b\u0010.\u001a\u0004\u0018\u00010%H\u0016\u00a8\u0006/"}, d2={"Lcom/intellij/httpClient/http/request/run/js/graalvm/crypto/rsa/SubtleCrypto;", "Lorg/graalvm/polyglot/proxy/ProxyObject;", "<init>", "()V", "generateKeyInternal", "Lcom/intellij/httpClient/http/request/run/js/graalvm/crypto/rsa/CryptoKey;", "keyAlgorithm", "Lcom/intellij/httpClient/http/request/run/js/graalvm/crypto/rsa/KeyAlgorithm;", "exportable", "", "keyUsage", "", "", "(Lcom/intellij/httpClient/http/request/run/js/graalvm/crypto/rsa/KeyAlgorithm;Z[Ljava/lang/String;)Lcom/intellij/httpClient/http/request/run/js/graalvm/crypto/rsa/CryptoKey;", "exportKeyInternal", "", "format", "key", "Lcom/intellij/httpClient/http/request/run/js/graalvm/crypto/rsa/JsCryptoKey;", "importKeyInternal", "keyData", "algorithm", "encryptInternal", "Lcom/intellij/httpClient/http/request/run/js/graalvm/crypto/rsa/EncryptionAlgorithm;", "Lcom/intellij/httpClient/http/request/run/js/graalvm/crypto/rsa/JsRsaCryptoKey;", "Ljava/security/PublicKey;", "data", "decryptInternal", "Ljava/security/PrivateKey;", "signInternal", "signingAlgorithm", "Lcom/intellij/httpClient/http/request/run/js/graalvm/crypto/rsa/SigningAlgorithm;", "verifyInternal", "signature", "getMember", "", "extractKey", "Lorg/graalvm/polyglot/Value;", "extractSignatureAlgoritm", "arguments", "([Lorg/graalvm/polyglot/Value;)Lcom/intellij/httpClient/http/request/run/js/graalvm/crypto/rsa/SigningAlgorithm;", "getMemberKeys", "()[Ljava/lang/String;", "hasMember", "putMember", "", "value", "intellij.httpClient.executor"})
@SourceDebugExtension(value={"SMAP\nRsaCryptoSupport.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RsaCryptoSupport.kt\ncom/intellij/httpClient/http/request/run/js/graalvm/crypto/rsa/SubtleCrypto\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,525:1\n1#2:526\n*E\n"})
public final class SubtleCrypto
implements ProxyObject {
    /*
     * Unable to fully structure code
     */
    @Nullable
    public final CryptoKey generateKeyInternal(@NotNull KeyAlgorithm keyAlgorithm, boolean exportable, @NotNull String[] keyUsage) {
        block24: {
            Intrinsics.checkNotNullParameter((Object)keyAlgorithm, (String)"keyAlgorithm");
            Intrinsics.checkNotNullParameter((Object)keyUsage, (String)"keyUsage");
            v0 = keyAlgorithm.getName().toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"toLowerCase(...)");
            var4_4 = v0;
            switch (var4_4.hashCode()) {
                case 1479590339: {
                    if (!var4_4.equals("rsa-pss")) {
                        ** break;
                    }
                    ** GOTO lbl20
                }
                case 96324692: {
                    if (var4_4.equals("ecdsa")) break;
                    ** break;
                }
                case -1377387158: {
                    if (!var4_4.equals("rsa-oaep")) {
                        ** break;
                    }
                    ** GOTO lbl20
                }
                case 484063364: {
                    if (!var4_4.equals("rsassa-pkcs1-v1_5")) ** break;
lbl20:
                    // 3 sources

                    if (keyAlgorithm.getModulusLength() == null || keyAlgorithm.getPublicExponent() == null) {
                        return null;
                    }
                    v1 = keyAlgorithm.getHash();
                    if (v1 == null) {
                        v1 = "SHA-256";
                    }
                    if (!(Intrinsics.areEqual((Object)(hash = v1), (Object)"SHA-256") || Intrinsics.areEqual((Object)hash, (Object)"SHA-384") || Intrinsics.areEqual((Object)hash, (Object)"SHA-512"))) {
                        return null;
                    }
                    keyGen = KeyPairGenerator.getInstance("RSA");
                    random = SecureRandom.getInstanceStrong();
                    it = keyAlgorithm.getPublicExponent();
                    $i$a$-let-SubtleCrypto$generateKeyInternal$1 = false;
                    random.setSeed(it);
                    keyLength = keyAlgorithm.getModulusLength();
                    keyGen.initialize(keyLength, random);
                    keyPair = keyGen.generateKeyPair();
                    publicKey = new JsRsaCryptoKey<PublicKey>(keyPair.getPublic(), keyAlgorithm.getName(), hash, keyLength, exportable, keyUsage);
                    privateKey = new JsRsaCryptoKey<PrivateKey>(keyPair.getPrivate(), keyAlgorithm.getName(), hash, keyLength, exportable, keyUsage);
                    v2 = new CryptoKey((JsCryptoKey<PublicKey>)publicKey, (JsCryptoKey<PrivateKey>)privateKey);
                    break block24;
                }
            }
            keyGen = KeyPairGenerator.getInstance("EC");
            random = keyAlgorithm.getNamedCurve();
            if (random == null) ** GOTO lbl-1000
            tmp = -1;
            switch (random.hashCode()) {
                case 75272022: {
                    if (random.equals("P-256")) {
                        tmp = 1;
                    }
                    break;
                }
                case 75274807: {
                    if (random.equals("P-521")) {
                        tmp = 2;
                    }
                    break;
                }
                case 75273074: {
                    if (random.equals("P-384")) {
                        tmp = 3;
                    }
                    break;
                }
            }
            switch (tmp) {
                case 1: {
                    v3 = "secp256r1";
                    break;
                }
                case 3: {
                    v3 = "secp384r1";
                    break;
                }
                case 2: {
                    v3 = "secp521r1";
                    break;
                }
                default: lbl-1000:
                // 2 sources

                {
                    return null;
                }
            }
            ecSpecParameter = v3;
            keyGen.initialize(new ECGenParameterSpec(ecSpecParameter));
            keyPair = keyGen.generateKeyPair();
            publicKey = new JsEcdsaCryptoKey<PublicKey>(keyPair.getPublic(), keyAlgorithm.getName(), keyAlgorithm.getNamedCurve(), exportable, keyUsage);
            privateKey = new JsEcdsaCryptoKey<PrivateKey>(keyPair.getPrivate(), keyAlgorithm.getName(), keyAlgorithm.getNamedCurve(), exportable, keyUsage);
            v2 = new CryptoKey((JsCryptoKey<PublicKey>)publicKey, (JsCryptoKey<PrivateKey>)privateKey);
            break block24;
lbl81:
            // 5 sources

            v2 = null;
        }
        return v2;
    }

    @Nullable
    public final byte[] exportKeyInternal(@NotNull String format, @NotNull JsCryptoKey<?> key) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)format, (String)"format");
        Intrinsics.checkNotNullParameter(key, (String)"key");
        String string = format;
        if (Intrinsics.areEqual((Object)string, (Object)"pkcs8")) {
            Object obj = key.getKey();
            PrivateKey privateKey = obj instanceof PrivateKey ? (PrivateKey)obj : null;
            object = privateKey != null ? privateKey.getEncoded() : null;
        } else if (Intrinsics.areEqual((Object)string, (Object)"spki")) {
            Object obj = key.getKey();
            PublicKey publicKey = obj instanceof PublicKey ? (PublicKey)obj : null;
            object = publicKey != null ? publicKey.getEncoded() : null;
        } else {
            object = null;
        }
        return object;
    }

    @Nullable
    public final JsCryptoKey<?> importKeyInternal(@NotNull String format, @NotNull byte[] keyData, @NotNull KeyAlgorithm algorithm) {
        JsCryptoKey jsCryptoKey;
        block47: {
            block48: {
                String string;
                KeyFactory keyFactory;
                block45: {
                    KeyFactory keyFactory2;
                    Intrinsics.checkNotNullParameter((Object)format, (String)"format");
                    Intrinsics.checkNotNullParameter((Object)keyData, (String)"keyData");
                    Intrinsics.checkNotNullParameter((Object)algorithm, (String)"algorithm");
                    switch (algorithm.getName()) {
                        case "RSA-OAEP": 
                        case "RSA-PSS": 
                        case "RSASSA-PKCS1-v1_5": {
                            keyFactory2 = KeyFactory.getInstance("RSA");
                            break;
                        }
                        case "ECDSA": {
                            keyFactory2 = KeyFactory.getInstance("EC");
                            break;
                        }
                        default: {
                            return null;
                        }
                    }
                    keyFactory = keyFactory2;
                    string = format;
                    if (!Intrinsics.areEqual((Object)string, (Object)"pkcs8")) break block45;
                    PKCS8EncodedKeySpec privateKeyData = new PKCS8EncodedKeySpec(keyData);
                    PrivateKey privateKey = keyFactory.generatePrivate(privateKeyData);
                    switch (algorithm.getName()) {
                        case "RSA-OAEP": 
                        case "RSA-PSS": {
                            Serializable serializable;
                            String[] stringArray = new String[]{"decrypt", "sign"};
                            jsCryptoKey = new JsRsaCryptoKey<PrivateKey>(privateKey, algorithm.getName(), algorithm.getHash(), (serializable = privateKey instanceof RSAPrivateKey ? (RSAPrivateKey)privateKey : null) != null && (serializable = serializable.getModulus()) != null ? ((BigInteger)serializable).intValue() : 2024, true, stringArray);
                            break;
                        }
                        case "RSASSA-PKCS1-v1_5": {
                            Serializable serializable;
                            String[] stringArray = new String[]{"sign"};
                            jsCryptoKey = new JsRsaCryptoKey<PrivateKey>(privateKey, algorithm.getName(), algorithm.getHash(), (serializable = privateKey instanceof RSAPrivateKey ? (RSAPrivateKey)privateKey : null) != null && (serializable = serializable.getModulus()) != null ? ((BigInteger)serializable).intValue() : 2024, true, stringArray);
                            break;
                        }
                        case "ECDSA": {
                            String[] stringArray = new String[]{"sign"};
                            jsCryptoKey = new JsEcdsaCryptoKey<PrivateKey>(privateKey, algorithm.getName(), algorithm.getNamedCurve(), true, stringArray);
                            break;
                        }
                        default: {
                            jsCryptoKey = null;
                            break;
                        }
                    }
                    break block47;
                }
                if (!Intrinsics.areEqual((Object)string, (Object)"spki")) break block48;
                PublicKey publicKey = keyFactory.generatePublic(new X509EncodedKeySpec(keyData));
                switch (algorithm.getName()) {
                    case "RSA-OAEP": 
                    case "RSA-PSS": {
                        Object object;
                        String[] stringArray = new String[]{"encrypt", "verify"};
                        jsCryptoKey = new JsRsaCryptoKey<PublicKey>(publicKey, algorithm.getName(), algorithm.getHash(), (object = publicKey instanceof RSAPublicKey ? (RSAPublicKey)publicKey : null) != null && (object = object.getModulus()) != null ? ((BigInteger)object).intValue() : 2024, true, stringArray);
                        break;
                    }
                    case "RSASSA-PKCS1-v1_5": {
                        Object object;
                        String[] stringArray = new String[]{"verify"};
                        jsCryptoKey = new JsRsaCryptoKey<PublicKey>(publicKey, algorithm.getName(), algorithm.getHash(), (object = publicKey instanceof RSAPublicKey ? (RSAPublicKey)publicKey : null) != null && (object = object.getModulus()) != null ? ((BigInteger)object).intValue() : 2024, true, stringArray);
                        break;
                    }
                    case "ECDSA": {
                        String[] stringArray = new String[]{"verify"};
                        jsCryptoKey = new JsEcdsaCryptoKey<PublicKey>(publicKey, algorithm.getName(), algorithm.getNamedCurve(), true, stringArray);
                        break;
                    }
                    default: {
                        jsCryptoKey = null;
                        break;
                    }
                }
                break block47;
            }
            jsCryptoKey = null;
        }
        return jsCryptoKey;
    }

    @Nullable
    public final byte[] encryptInternal(@NotNull EncryptionAlgorithm algorithm, @NotNull JsRsaCryptoKey<PublicKey> key, @NotNull byte[] data) {
        Intrinsics.checkNotNullParameter((Object)algorithm, (String)"algorithm");
        Intrinsics.checkNotNullParameter(key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        if (!Intrinsics.areEqual((Object)algorithm.getName(), (Object)"RSA-OAEP")) {
            return null;
        }
        Cipher encryptCipher = Cipher.getInstance("RSA/ECB/OAEPWith" + key.getHash() + "AndMGF1Padding");
        encryptCipher.init(1, (Key)key.getKey());
        return encryptCipher.doFinal(data);
    }

    @Nullable
    public final byte[] decryptInternal(@NotNull EncryptionAlgorithm algorithm, @NotNull JsRsaCryptoKey<PrivateKey> key, @NotNull byte[] data) {
        Intrinsics.checkNotNullParameter((Object)algorithm, (String)"algorithm");
        Intrinsics.checkNotNullParameter(key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        if (!Intrinsics.areEqual((Object)algorithm.getName(), (Object)"RSA-OAEP")) {
            return null;
        }
        Cipher decryptCipher = Cipher.getInstance("RSA/ECB/OAEPWith" + key.getHash() + "AndMGF1Padding");
        decryptCipher.init(2, (Key)key.getKey());
        return decryptCipher.doFinal(data);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    public final byte[] signInternal(@NotNull SigningAlgorithm signingAlgorithm, @NotNull JsCryptoKey<PrivateKey> key, @NotNull byte[] data) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)signingAlgorithm, (String)"signingAlgorithm");
        Intrinsics.checkNotNullParameter(key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        if (!ArraysKt.contains((Object[])key.getUsages(), (Object)"sign")) {
            return null;
        }
        switch (signingAlgorithm.getName()) {
            case "RSASSA-PKCS1-v1_5": {
                String string;
                String string2 = signingAlgorithm.getHash();
                if (string2 == null) return null;
                int n = -1;
                switch (string2.hashCode()) {
                    case -1523886674: {
                        if (string2.equals("SHA-384")) {
                            n = 1;
                        }
                        break;
                    }
                    case -1523887726: {
                        if (string2.equals("SHA-256")) {
                            n = 2;
                        }
                        break;
                    }
                    case -1523884971: {
                        if (string2.equals("SHA-512")) {
                            n = 3;
                        }
                        break;
                    }
                }
                switch (n) {
                    case 2: {
                        string = "SHA256withRSA";
                        break;
                    }
                    case 1: {
                        string = "SHA384withRSA";
                        break;
                    }
                    case 3: {
                        string = "SHA512withRSA";
                        break;
                    }
                    default: {
                        return null;
                    }
                }
                Object signatureInstanceParams = string;
                object = Signature.getInstance((String)signatureInstanceParams);
                break;
            }
            case "RSA-PSS": {
                if (!(key instanceof JsRsaCryptoKey)) {
                    return null;
                }
                Object signatureInstanceParams = Signature.getInstance("RSASSA-PSS");
                Signature $this$signInternal_u24lambda_u240 = signatureInstanceParams;
                boolean bl = false;
                Long l = signingAlgorithm.getSaltLength();
                PSSParameterSpec pssSpec = new PSSParameterSpec(((JsRsaCryptoKey)key).getHash(), "MGF1", new MGF1ParameterSpec(((JsRsaCryptoKey)key).getHash()), l != null ? (int)l.longValue() : 64, 1);
                $this$signInternal_u24lambda_u240.setParameter(pssSpec);
                object = signatureInstanceParams;
                break;
            }
            case "ECDSA": {
                String string;
                String string2 = signingAlgorithm.getHash();
                if (string2 == null) return null;
                int n = -1;
                switch (string2.hashCode()) {
                    case -1523886674: {
                        if (string2.equals("SHA-384")) {
                            n = 1;
                        }
                        break;
                    }
                    case -1523887726: {
                        if (string2.equals("SHA-256")) {
                            n = 2;
                        }
                        break;
                    }
                    case -1523884971: {
                        if (string2.equals("SHA-512")) {
                            n = 3;
                        }
                        break;
                    }
                }
                switch (n) {
                    case 2: {
                        string = "SHA256withECDSA";
                        break;
                    }
                    case 1: {
                        string = "SHA384withECDSA";
                        break;
                    }
                    case 3: {
                        string = "SHA512withECDSA";
                        break;
                    }
                    default: {
                        return null;
                    }
                }
                String ecdsaParameter = string;
                object = Signature.getInstance(ecdsaParameter);
                break;
            }
            default: {
                return null;
            }
        }
        Signature signer = object;
        signer.initSign(key.getKey());
        signer.update(data);
        return signer.sign();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean verifyInternal(@NotNull SigningAlgorithm signingAlgorithm, @NotNull byte[] signature, @NotNull JsCryptoKey<PublicKey> key, @NotNull byte[] data) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)signingAlgorithm, (String)"signingAlgorithm");
        Intrinsics.checkNotNullParameter((Object)signature, (String)"signature");
        Intrinsics.checkNotNullParameter(key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        if (!ArraysKt.contains((Object[])key.getUsages(), (Object)"verify")) {
            return false;
        }
        switch (signingAlgorithm.getName()) {
            case "RSASSA-PKCS1-v1_5": {
                String string;
                String string2 = signingAlgorithm.getHash();
                if (string2 == null) return false;
                int n = -1;
                switch (string2.hashCode()) {
                    case -1523886674: {
                        if (string2.equals("SHA-384")) {
                            n = 1;
                        }
                        break;
                    }
                    case -1523887726: {
                        if (string2.equals("SHA-256")) {
                            n = 2;
                        }
                        break;
                    }
                    case -1523884971: {
                        if (string2.equals("SHA-512")) {
                            n = 3;
                        }
                        break;
                    }
                }
                switch (n) {
                    case 2: {
                        string = "SHA256withRSA";
                        break;
                    }
                    case 1: {
                        string = "SHA384withRSA";
                        break;
                    }
                    case 3: {
                        string = "SHA512withRSA";
                        break;
                    }
                    default: {
                        return false;
                    }
                }
                Object signatureParams = string;
                object = Signature.getInstance((String)signatureParams);
                break;
            }
            case "RSA-PSS": {
                Object signatureParams = Signature.getInstance("RSASSA-PSS");
                Signature $this$verifyInternal_u24lambda_u240 = signatureParams;
                boolean bl = false;
                if (!(key instanceof JsRsaCryptoKey)) {
                    return false;
                }
                Long l = signingAlgorithm.getSaltLength();
                PSSParameterSpec pssSpec = new PSSParameterSpec(((JsRsaCryptoKey)key).getHash(), "MGF1", new MGF1ParameterSpec(((JsRsaCryptoKey)key).getHash()), l != null ? (int)l.longValue() : 64, 1);
                $this$verifyInternal_u24lambda_u240.setParameter(pssSpec);
                object = signatureParams;
                break;
            }
            case "ECDSA": {
                String string;
                if (!(key instanceof JsEcdsaCryptoKey)) {
                    return false;
                }
                String string2 = signingAlgorithm.getHash();
                if (string2 == null) return false;
                int n = -1;
                switch (string2.hashCode()) {
                    case -1523886674: {
                        if (string2.equals("SHA-384")) {
                            n = 1;
                        }
                        break;
                    }
                    case -1523887726: {
                        if (string2.equals("SHA-256")) {
                            n = 2;
                        }
                        break;
                    }
                    case -1523884971: {
                        if (string2.equals("SHA-512")) {
                            n = 3;
                        }
                        break;
                    }
                }
                switch (n) {
                    case 2: {
                        string = "SHA256withECDSA";
                        break;
                    }
                    case 1: {
                        string = "SHA384withECDSA";
                        break;
                    }
                    case 3: {
                        string = "SHA512withECDSA";
                        break;
                    }
                    default: {
                        return false;
                    }
                }
                Object signatureParams = string;
                object = Signature.getInstance((String)signatureParams);
                break;
            }
            default: {
                return false;
            }
        }
        Signature verifier = object;
        verifier.initVerify(key.getKey());
        verifier.update(data);
        return verifier.verify(signature);
    }

    @Nullable
    public Object getMember(@NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        return switch (key) {
            case "generateKey" -> arg_0 -> SubtleCrypto.getMember$lambda$0(this, arg_0);
            case "encrypt" -> arg_0 -> SubtleCrypto.getMember$lambda$1(this, arg_0);
            case "decrypt" -> arg_0 -> SubtleCrypto.getMember$lambda$2(this, arg_0);
            case "sign" -> arg_0 -> SubtleCrypto.getMember$lambda$3(this, arg_0);
            case "verify" -> arg_0 -> SubtleCrypto.getMember$lambda$4(this, arg_0);
            case "exportKey" -> arg_0 -> SubtleCrypto.getMember$lambda$5(this, arg_0);
            case "importKey" -> arg_0 -> SubtleCrypto.getMember$lambda$6(this, arg_0);
            default -> null;
        };
    }

    private final JsCryptoKey<?> extractKey(Value $this$extractKey) {
        if ($this$extractKey != null && $this$extractKey.hasMember("_handle")) {
            Object object = $this$extractKey.getMember("_handle");
            if (object == null || (object = (JsCryptoKey)object.as(JsCryptoKey.class)) == null) {
                throw new IllegalArgumentException("Key is missing");
            }
            return object;
        }
        throw new IllegalArgumentException("Key is missing");
    }

    private final SigningAlgorithm extractSignatureAlgoritm(Value[] arguments) {
        Value[] valueArray = arguments;
        if (valueArray == null || (valueArray = (Value[])ArraysKt.getOrNull((Object[])valueArray, (int)0)) == null) {
            return null;
        }
        Value[] algo = valueArray;
        Object object = RsaCryptoSupportKt.access$getMemberOrNull((Value)algo, "name");
        if (object == null || (object = object.asString()) == null) {
            return null;
        }
        Object algorithmName = object;
        Value value2 = RsaCryptoSupportKt.access$getMemberOrNull((Value)algo, "saltLength");
        Long saltLength = value2 != null ? Long.valueOf(value2.asLong()) : null;
        Value value3 = RsaCryptoSupportKt.access$getMemberOrNull((Value)algo, "hash");
        String hash = value3 != null ? value3.asString() : null;
        return new SigningAlgorithm((String)algorithmName, saltLength, hash);
    }

    @NotNull
    public String[] getMemberKeys() {
        String[] stringArray = new String[]{"generateKey", "exportKey", "importKey", "encrypt", "decrypt", "sign", "verify"};
        return stringArray;
    }

    public boolean hasMember(@NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        return ArraysKt.contains((Object[])this.getMemberKeys(), (Object)key);
    }

    public void putMember(@Nullable String key, @Nullable Value value2) {
    }

    private static final Object getMember$lambda$0(SubtleCrypto this$0, Value[] arguments) {
        Object object;
        Object name;
        Value algorithmValue;
        Intrinsics.checkNotNull((Object)arguments);
        Value value2 = (Value)ArraysKt.getOrNull((Object[])arguments, (int)0);
        if (value2 != null) {
            algorithmValue = value2;
            boolean bl = false;
            Object object2 = RsaCryptoSupportKt.access$getMemberOrNull(algorithmValue, "name");
            if (object2 == null || (object2 = object2.asString()) == null) {
                throw new IllegalArgumentException("algorithm name is missing");
            }
            name = object2;
            object = RsaCryptoSupportKt.access$getMemberOrNull(algorithmValue, "hash");
            if (object == null || (object = object.asString()) == null) {
                throw new IllegalArgumentException("hash is missing");
            }
        } else {
            return null;
        }
        Object hash = object;
        Value value3 = RsaCryptoSupportKt.access$getMemberOrNull(algorithmValue, "modulusLength");
        Integer modulusLength = value3 != null ? Integer.valueOf(value3.asInt()) : null;
        Value value4 = RsaCryptoSupportKt.access$getMemberOrNull(algorithmValue, "publicExponent");
        byte[] publicExponent = (byte[])(value4 != null ? StringUtilsKt.asByteArray(value4) : null);
        Value value5 = RsaCryptoSupportKt.access$getMemberOrNull(algorithmValue, "namedCurve");
        String namedCurve = value5 != null ? value5.asString() : null;
        KeyAlgorithm algorithm = new KeyAlgorithm((String)name, modulusLength, publicExponent, (String)hash, namedCurve);
        Value value6 = (Value)ArraysKt.getOrNull((Object[])arguments, (int)1);
        if (value6 == null) {
            throw new IllegalArgumentException("extractable is missing");
        }
        boolean extractable = value6.asBoolean();
        String[] stringArray = (String[])ArraysKt.getOrNull((Object[])arguments, (int)2);
        if (stringArray == null || (stringArray = RsaCryptoSupportKt.access$asStringArray((Value)stringArray)) == null) {
            throw new IllegalArgumentException("keyUsage is missed");
        }
        String[] keyUsages = stringArray;
        CryptoKey key = this$0.generateKeyInternal(algorithm, extractable, keyUsages);
        Pair[] pairArray = new Pair[2];
        Pair[] pairArray2 = new Pair[5];
        pairArray2[0] = TuplesKt.to((Object)"type", (Object)"private");
        pairArray2[1] = TuplesKt.to((Object)"extractable", (Object)extractable);
        pairArray2[2] = TuplesKt.to((Object)"algorithm", (Object)ArraysKt.getOrNull((Object[])arguments, (int)0));
        pairArray2[3] = TuplesKt.to((Object)"usages", (Object)ArraysKt.getOrNull((Object[])arguments, (int)2));
        CryptoKey cryptoKey = key;
        pairArray2[4] = TuplesKt.to((Object)"_handle", cryptoKey != null ? cryptoKey.getPrivateKey() : null);
        pairArray[0] = TuplesKt.to((Object)"privateKey", (Object)ProxyObject.fromMap((Map)MapsKt.mapOf((Pair[])pairArray2)));
        pairArray2 = new Pair[5];
        pairArray2[0] = TuplesKt.to((Object)"type", (Object)"public");
        pairArray2[1] = TuplesKt.to((Object)"extractable", (Object)extractable);
        pairArray2[2] = TuplesKt.to((Object)"algorithm", (Object)ArraysKt.getOrNull((Object[])arguments, (int)0));
        pairArray2[3] = TuplesKt.to((Object)"usages", (Object)ArraysKt.getOrNull((Object[])arguments, (int)2));
        CryptoKey cryptoKey2 = key;
        pairArray2[4] = TuplesKt.to((Object)"_handle", cryptoKey2 != null ? cryptoKey2.getPublicKey() : null);
        pairArray[1] = TuplesKt.to((Object)"publicKey", (Object)ProxyObject.fromMap((Map)MapsKt.mapOf((Pair[])pairArray2)));
        return ProxyObject.fromMap((Map)MapsKt.mapOf((Pair[])pairArray));
    }

    private static final Object getMember$lambda$1(SubtleCrypto this$0, Value[] arguments) {
        Object object;
        JsCryptoKey<?> keyRaw;
        Object algorithmName;
        block6: {
            block5: {
                Intrinsics.checkNotNull((Object)arguments);
                Object object2 = (Value)ArraysKt.getOrNull((Object[])arguments, (int)0);
                if (object2 == null || (object2 = object2.getMember("name")) == null || (object2 = object2.asString()) == null) {
                    throw new IllegalArgumentException("algorithm name is missing");
                }
                algorithmName = object2;
                keyRaw = this$0.extractKey((Value)ArraysKt.getOrNull((Object[])arguments, (int)1));
                object = (Value)ArraysKt.getOrNull((Object[])arguments, (int)2);
                if (object == null) break block5;
                byte[] byArray = StringUtilsKt.asByteArray(object);
                object = byArray;
                if (byArray != null) break block6;
            }
            throw new IllegalArgumentException("Data is missing");
        }
        Object data = object;
        JsRsaCryptoKey jsRsaCryptoKey = keyRaw instanceof JsRsaCryptoKey ? (JsRsaCryptoKey)keyRaw : null;
        if (jsRsaCryptoKey == null) {
            throw new IllegalArgumentException("Invalid key");
        }
        JsRsaCryptoKey key = jsRsaCryptoKey;
        return this$0.encryptInternal(new EncryptionAlgorithm((String)algorithmName), key, (byte[])data);
    }

    private static final Object getMember$lambda$2(SubtleCrypto this$0, Value[] arguments) {
        Object object;
        JsCryptoKey<?> keyRaw;
        Object algorithmName;
        block6: {
            block5: {
                Intrinsics.checkNotNull((Object)arguments);
                Object object2 = (Value)ArraysKt.getOrNull((Object[])arguments, (int)0);
                if (object2 == null || (object2 = object2.getMember("name")) == null || (object2 = object2.asString()) == null) {
                    throw new IllegalArgumentException("algorithm name is missing");
                }
                algorithmName = object2;
                keyRaw = this$0.extractKey((Value)ArraysKt.getOrNull((Object[])arguments, (int)1));
                object = (Value)ArraysKt.getOrNull((Object[])arguments, (int)2);
                if (object == null) break block5;
                byte[] byArray = StringUtilsKt.asByteArray(object);
                object = byArray;
                if (byArray != null) break block6;
            }
            throw new IllegalArgumentException("Data is missing");
        }
        Object data = object;
        JsRsaCryptoKey jsRsaCryptoKey = keyRaw instanceof JsRsaCryptoKey ? (JsRsaCryptoKey)keyRaw : null;
        if (jsRsaCryptoKey == null) {
            throw new IllegalArgumentException("Invalid key");
        }
        JsRsaCryptoKey key = jsRsaCryptoKey;
        return this$0.decryptInternal(new EncryptionAlgorithm((String)algorithmName), key, (byte[])data);
    }

    private static final Object getMember$lambda$3(SubtleCrypto this$0, Value[] arguments) {
        Object object;
        JsCryptoKey<PrivateKey> keyRaw;
        SigningAlgorithm signingAlgorithm;
        block6: {
            block5: {
                SigningAlgorithm signingAlgorithm2 = this$0.extractSignatureAlgoritm(arguments);
                if (signingAlgorithm2 == null) {
                    throw new IllegalArgumentException("Invalid signing algorithm");
                }
                signingAlgorithm = signingAlgorithm2;
                Intrinsics.checkNotNull((Object)arguments);
                keyRaw = this$0.extractKey((Value)ArraysKt.getOrNull((Object[])arguments, (int)1));
                object = (Value)ArraysKt.getOrNull((Object[])arguments, (int)2);
                if (object == null) break block5;
                byte[] byArray = StringUtilsKt.asByteArray(object);
                object = byArray;
                if (byArray != null) break block6;
            }
            throw new IllegalArgumentException("Data is missing");
        }
        Object data = object;
        JsCryptoKey<PrivateKey> jsCryptoKey = keyRaw instanceof JsCryptoKey ? keyRaw : null;
        if (jsCryptoKey == null) {
            throw new IllegalArgumentException("Invalid key");
        }
        JsCryptoKey<PrivateKey> key = jsCryptoKey;
        return this$0.signInternal(signingAlgorithm, key, (byte[])data);
    }

    private static final Object getMember$lambda$4(SubtleCrypto this$0, Value[] arguments) {
        Object object;
        Object signature;
        JsCryptoKey<PublicKey> keyRaw;
        SigningAlgorithm signingAlgorithm;
        block11: {
            block10: {
                Object object2;
                block9: {
                    block8: {
                        SigningAlgorithm signingAlgorithm2 = this$0.extractSignatureAlgoritm(arguments);
                        if (signingAlgorithm2 == null) {
                            throw new IllegalArgumentException("Invalid signing algorithm");
                        }
                        signingAlgorithm = signingAlgorithm2;
                        Intrinsics.checkNotNull((Object)arguments);
                        keyRaw = this$0.extractKey((Value)ArraysKt.getOrNull((Object[])arguments, (int)1));
                        object2 = (Value)ArraysKt.getOrNull((Object[])arguments, (int)2);
                        if (object2 == null) break block8;
                        byte[] byArray = StringUtilsKt.asByteArray(object2);
                        object2 = byArray;
                        if (byArray != null) break block9;
                    }
                    throw new IllegalArgumentException("Signature is missing");
                }
                signature = object2;
                object = (Value)ArraysKt.getOrNull((Object[])arguments, (int)3);
                if (object == null) break block10;
                byte[] byArray = StringUtilsKt.asByteArray(object);
                object = byArray;
                if (byArray != null) break block11;
            }
            throw new IllegalArgumentException("Data is missing");
        }
        Object data = object;
        JsCryptoKey<PublicKey> jsCryptoKey = keyRaw instanceof JsCryptoKey ? keyRaw : null;
        if (jsCryptoKey == null) {
            throw new IllegalArgumentException("Invalid key");
        }
        JsCryptoKey<PublicKey> key = jsCryptoKey;
        return this$0.verifyInternal(signingAlgorithm, (byte[])signature, key, (byte[])data);
    }

    private static final Object getMember$lambda$5(SubtleCrypto this$0, Value[] arguments) {
        Intrinsics.checkNotNull((Object)arguments);
        Object object = (Value)ArraysKt.getOrNull((Object[])arguments, (int)0);
        if (object == null || (object = object.asString()) == null) {
            throw new IllegalArgumentException("format is missing");
        }
        Object format = object;
        Object object2 = (Value)ArraysKt.getOrNull((Object[])arguments, (int)1);
        if (object2 == null || (object2 = object2.getMember("_handle")) == null || (object2 = (JsCryptoKey)object2.as(JsCryptoKey.class)) == null) {
            throw new IllegalArgumentException("Key is missing");
        }
        Object keyRaw = object2;
        Object object3 = keyRaw instanceof JsCryptoKey ? keyRaw : null;
        if (object3 == null) {
            return null;
        }
        Object key = object3;
        return this$0.exportKeyInternal((String)format, (JsCryptoKey<?>)key);
    }

    private static final Object getMember$lambda$6(SubtleCrypto this$0, Value[] arguments) {
        Pair pair;
        Object obj;
        JsCryptoKey<?> key;
        String string;
        Object name;
        Object[] obj2;
        Object object;
        Object format;
        block18: {
            block17: {
                Intrinsics.checkNotNull((Object)arguments);
                Object object2 = (Value)ArraysKt.getOrNull((Object[])arguments, (int)0);
                if (object2 == null || (object2 = object2.asString()) == null) {
                    throw new IllegalArgumentException("format is missing");
                }
                format = object2;
                object = (Value)ArraysKt.getOrNull((Object[])arguments, (int)1);
                if (object == null) break block17;
                byte[] byArray = StringUtilsKt.asByteArray(object);
                object = byArray;
                if (byArray != null) break block18;
            }
            throw new IllegalArgumentException("key is missing");
        }
        Object keyData = object;
        Object[] objectArray = (Object[])ArraysKt.getOrNull((Object[])arguments, (int)2);
        if (objectArray != null) {
            obj2 = objectArray;
            boolean bl = false;
            Object object3 = RsaCryptoSupportKt.access$getMemberOrNull((Value)obj2, "name");
            if (object3 == null || (object3 = object3.asString()) == null) {
                throw new IllegalArgumentException("algorithm name is missing");
            }
            name = object3;
            Value value2 = RsaCryptoSupportKt.access$getMemberOrNull((Value)obj2, "hash");
            if (value2 != null) {
                Value hash = value2;
                boolean bl2 = false;
                if (hash.isString()) {
                    string = hash.asString();
                } else if (hash.hasMember("name")) {
                    Value value3 = hash.getMember("name");
                    string = value3 != null ? value3.asString() : null;
                } else {
                    hash.getContext().eval("js", (CharSequence)"throw 'Error: Invalid hash (it's expected \"SHA-256|SHA-384|SHA-512\" or { name = \"SHA-256|SHA-384|SHA-512\"})'");
                    string = "";
                }
            } else {
                string = null;
            }
        } else {
            return null;
        }
        String hash = string;
        Value value4 = RsaCryptoSupportKt.access$getMemberOrNull((Value)obj2, "namedCurve");
        String namedCurve = value4 != null ? value4.asString() : null;
        KeyAlgorithm algorithm = new KeyAlgorithm((String)name, null, null, hash, namedCurve);
        JsCryptoKey<?> jsCryptoKey = key = this$0.importKeyInternal((String)format, (byte[])keyData, algorithm);
        Object object4 = obj = jsCryptoKey != null ? jsCryptoKey.getKey() : null;
        if (obj instanceof PrivateKey) {
            obj2 = new String[]{"decrypt", "sign"};
            pair = TuplesKt.to((Object)"private", (Object)ProxyArray.fromList((List)CollectionsKt.listOf((Object[])obj2)));
        } else if (obj instanceof PublicKey) {
            obj2 = new String[]{"encrypt", "verify"};
            pair = TuplesKt.to((Object)"public", (Object)ProxyArray.fromList((List)CollectionsKt.listOf((Object[])obj2)));
        } else {
            return null;
        }
        Pair pair2 = pair;
        String type = (String)pair2.component1();
        ProxyArray usage = (ProxyArray)pair2.component2();
        Pair[] pairArray = new Pair[5];
        pairArray[0] = TuplesKt.to((Object)"type", (Object)type);
        pairArray[1] = TuplesKt.to((Object)"extractable", (Object)true);
        Pair[] pairArray2 = new Pair[]{TuplesKt.to((Object)"name", (Object)algorithm.getName()), TuplesKt.to((Object)"hash", (Object)ProxyObject.fromMap((Map)MapsKt.mapOf((Pair)TuplesKt.to((Object)"name", (Object)algorithm.getHash())))), TuplesKt.to((Object)"namedCurve", (Object)algorithm.getNamedCurve())};
        pairArray[2] = TuplesKt.to((Object)"algorithm", (Object)ProxyObject.fromMap((Map)MapsKt.mapOf((Pair[])pairArray2)));
        pairArray[3] = TuplesKt.to((Object)"usages", (Object)usage);
        pairArray[4] = TuplesKt.to((Object)"_handle", key);
        return ProxyObject.fromMap((Map)MapsKt.mapOf((Pair[])pairArray));
    }
}

