/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.httpClient.jsonPath;

import com.intellij.codeInsight.intention.preview.IntentionPreviewInfo;
import com.intellij.codeInspection.LocalQuickFixAndIntentionActionOnPsiElement;
import com.intellij.httpClient.execution.RestClientBundle;
import com.intellij.httpClient.http.request.HttpRequestPsiFile;
import com.intellij.httpClient.jsonPath.JsonPathUtilKt;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010\u000e\u001a\u00020\u0007H\u0016J\b\u0010\u000f\u001a\u00020\u0007H\u0016J3\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u0018\u001a\u00020\u00032\u0006\u0010\u0019\u001a\u00020\u0003H\u0096\u0002J \u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\b\u0010\u001c\u001a\u00020\u0007H\u0002R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u001d"}, d2={"Lcom/intellij/httpClient/jsonPath/WrapVariableFix;", "Lcom/intellij/codeInspection/LocalQuickFixAndIntentionActionOnPsiElement;", "element", "Lcom/intellij/psi/PsiElement;", "rangeInDocument", "Lcom/intellij/openapi/util/TextRange;", "variable", "", "<init>", "(Lcom/intellij/psi/PsiElement;Lcom/intellij/openapi/util/TextRange;Ljava/lang/String;)V", "getRangeInDocument", "()Lcom/intellij/openapi/util/TextRange;", "getVariable", "()Ljava/lang/String;", "getFamilyName", "getText", "invoke", "", "project", "Lcom/intellij/openapi/project/Project;", "psiFile", "Lcom/intellij/psi/PsiFile;", "editor", "Lcom/intellij/openapi/editor/Editor;", "startElement", "endElement", "generatePreview", "Lcom/intellij/codeInsight/intention/preview/IntentionPreviewInfo;", "doubleQuoted", "intellij.restClient"})
final class WrapVariableFix
extends LocalQuickFixAndIntentionActionOnPsiElement {
    @NotNull
    private final TextRange rangeInDocument;
    @NotNull
    private final String variable;

    public WrapVariableFix(@NotNull PsiElement element, @NotNull TextRange rangeInDocument, @NotNull String variable) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)rangeInDocument, (String)"rangeInDocument");
        Intrinsics.checkNotNullParameter((Object)variable, (String)"variable");
        super(element);
        this.rangeInDocument = rangeInDocument;
        this.variable = variable;
    }

    @NotNull
    public final TextRange getRangeInDocument() {
        return this.rangeInDocument;
    }

    @NotNull
    public final String getVariable() {
        return this.variable;
    }

    @NotNull
    public String getFamilyName() {
        String string = RestClientBundle.message("http.client.code.style.inspection.add.wrap.with.quotes.fix.text", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    @NotNull
    public String getText() {
        return this.getFamilyName();
    }

    public void invoke(@NotNull Project project, @NotNull PsiFile psiFile, @Nullable Editor editor2, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)psiFile, (String)"psiFile");
        Intrinsics.checkNotNullParameter((Object)startElement, (String)"startElement");
        Intrinsics.checkNotNullParameter((Object)endElement, (String)"endElement");
        HttpRequestPsiFile httpRequestPsiFile = JsonPathUtilKt.retrieveHostHttpFile(psiFile);
        if (httpRequestPsiFile == null || (httpRequestPsiFile = httpRequestPsiFile.getViewProvider()) == null || (httpRequestPsiFile = httpRequestPsiFile.getDocument()) == null) {
            return;
        }
        HttpRequestPsiFile document = httpRequestPsiFile;
        document.replaceString(this.rangeInDocument.getStartOffset(), this.rangeInDocument.getEndOffset(), this.doubleQuoted());
        PsiDocumentManager.getInstance((Project)project).commitDocument((Document)document);
    }

    @NotNull
    public IntentionPreviewInfo generatePreview(@NotNull Project project, @NotNull Editor editor2, @NotNull PsiFile psiFile) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)psiFile, (String)"psiFile");
        return (IntentionPreviewInfo)new IntentionPreviewInfo.CustomDiff(psiFile.getFileType(), "", this.doubleQuoted());
    }

    private final String doubleQuoted() {
        return "\"" + this.variable + "\"";
    }
}

