/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.httpClient.retrofit.minimal;

import com.intellij.httpClient.retrofit.minimal.RetrofitConstants;
import com.intellij.microservices.url.FrameworkUrlPathSpecification;
import com.intellij.microservices.url.UrlConstants;
import com.intellij.microservices.url.references.UrlPathContext;
import com.intellij.microservices.url.references.UrlPksParser;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PartiallyKnownString;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.uast.UAnnotation;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UMethod;
import org.jetbrains.uast.UParameter;
import org.jetbrains.uast.UastContextKt;
import org.jetbrains.uast.UastUtils;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u000e\u0010\f\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u000eJ\u001c\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00110\u00102\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0018\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00110\u0010*\u00020\u0013H\u0002J\u0018\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00110\u0010*\u00020\u0013H\u0002J \u0010\u0015\u001a\u0004\u0018\u00010\u00132\u0006\u0010\r\u001a\u00020\u000e2\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00110\u0017H\u0002J\u0018\u0010\u0018\u001a\u00020\u00112\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0019\u001a\u00020\u0011H\u0002R\u0014\u0010\u0004\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u001a"}, d2={"Lcom/intellij/httpClient/retrofit/minimal/RetrofitUrlPathSpecification;", "Lcom/intellij/microservices/url/FrameworkUrlPathSpecification;", "<init>", "()V", "parser", "Lcom/intellij/microservices/url/references/UrlPksParser;", "getParser", "()Lcom/intellij/microservices/url/references/UrlPksParser;", "getUrlPathContext", "Lcom/intellij/microservices/url/references/UrlPathContext;", "declaration", "Lcom/intellij/psi/PsiElement;", "getUrlPathContextForMethod", "uMethod", "Lorg/jetbrains/uast/UMethod;", "getMethodAndPath", "Lkotlin/Pair;", "", "simpleAnnotation", "Lorg/jetbrains/uast/UAnnotation;", "customMethodAnnotation", "findRetrofitAnnotation", "expectedAnnotation", "", "inflateWithQueryParameters", "urlPath", "intellij.httpClient.retrofit.minimal"})
@SourceDebugExtension(value={"SMAP\nRetrofitUrlPathSpecification.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RetrofitUrlPathSpecification.kt\ncom/intellij/httpClient/retrofit/minimal/RetrofitUrlPathSpecification\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 UastContext.kt\norg/jetbrains/uast/UastContextKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,86:1\n1#2:87\n1#2:104\n1#2:118\n212#3:88\n176#3:89\n1807#4,3:90\n1642#4,10:93\n1915#4:103\n1916#4:105\n1652#4:106\n1642#4,10:107\n1915#4:117\n1916#4:119\n1652#4:120\n*S KotlinDebug\n*F\n+ 1 RetrofitUrlPathSpecification.kt\ncom/intellij/httpClient/retrofit/minimal/RetrofitUrlPathSpecification\n*L\n74#1:104\n75#1:118\n23#1:88\n23#1:89\n69#1:90,3\n74#1:93,10\n74#1:103\n74#1:105\n74#1:106\n75#1:107,10\n75#1:117\n75#1:119\n75#1:120\n*E\n"})
public final class RetrofitUrlPathSpecification
extends FrameworkUrlPathSpecification {
    @NotNull
    public static final RetrofitUrlPathSpecification INSTANCE = new RetrofitUrlPathSpecification();

    private RetrofitUrlPathSpecification() {
    }

    @NotNull
    public UrlPksParser getParser() {
        UrlPksParser urlPksParser;
        UrlPksParser it = urlPksParser = super.getParser();
        boolean bl = false;
        it.setShouldHaveScheme(false);
        it.setParseQueryParameters(false);
        return urlPksParser;
    }

    @NotNull
    public UrlPathContext getUrlPathContext(@NotNull PsiElement declaration) {
        UMethod uMethod;
        block6: {
            block5: {
                UElement uElement;
                UElement uElement2;
                Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
                PsiElement $this$getUastParentOfType_u24default$iv = declaration;
                boolean strict$iv = false;
                boolean $i$f$getUastParentOfType = false;
                UAnnotation uAnnotation = (UAnnotation)UastContextKt.getUastParentOfType((PsiElement)$this$getUastParentOfType_u24default$iv, UAnnotation.class, (boolean)strict$iv);
                if (uAnnotation != null) {
                    uElement2 = (UElement)uAnnotation;
                } else {
                    PsiElement $this$toUElementOfType$iv = declaration;
                    boolean $i$f$toUElementOfType = false;
                    uElement2 = UastContextKt.toUElement((PsiElement)$this$toUElementOfType$iv, UMethod.class);
                }
                UElement uElement3 = uElement = uElement2;
                Object uMethod2 = uElement3 instanceof UAnnotation ? UastUtils.getContainingUMethod((UElement)uElement) : (uElement3 instanceof UMethod ? (UMethod)uElement : null);
                uMethod = uMethod2;
                if (uMethod == null) break block5;
                UMethod p0 = uMethod;
                boolean bl = false;
                UrlPathContext urlPathContext = this.getUrlPathContextForMethod(p0);
                uMethod = urlPathContext;
                if (urlPathContext != null) break block6;
            }
            uMethod = UrlPathContext.Companion.emptyRoot();
        }
        return uMethod;
    }

    @NotNull
    public final UrlPathContext getUrlPathContextForMethod(@NotNull UMethod uMethod) {
        Intrinsics.checkNotNullParameter((Object)uMethod, (String)"uMethod");
        Pair<String, String> pair = this.getMethodAndPath(uMethod);
        String httpMethod = (String)pair.component1();
        String urlPath = (String)pair.component2();
        UrlPksParser.ParsedPksUrlPath parsedPksUrl = this.getParser().parseUrlPath(new PartiallyKnownString(urlPath));
        UrlPathContext baseContext = UrlPathContext.Companion.supportingSchemes$default((UrlPathContext.Companion)UrlPathContext.Companion, (List)UrlConstants.HTTP_SCHEMES, null, (int)2, null).withMethod(httpMethod);
        return baseContext.withPaths(CollectionsKt.listOf((Object)parsedPksUrl.getUrlPath())).withFullUrlComputation(() -> RetrofitUrlPathSpecification.getUrlPathContextForMethod$lambda$0(uMethod, urlPath, baseContext));
    }

    private final Pair<String, String> getMethodAndPath(UMethod uMethod) {
        Object object = this.findRetrofitAnnotation(uMethod, RetrofitConstants.INSTANCE.getBASE_RETROFIT_HTTP_METHOD_ANNOTATIONS());
        if (object == null || (object = this.simpleAnnotation((UAnnotation)object)) == null) {
            UAnnotation uAnnotation = this.findRetrofitAnnotation(uMethod, CollectionsKt.listOf((Object)"retrofit2.http.HTTP"));
            object = uAnnotation != null ? this.customMethodAnnotation(uAnnotation) : TuplesKt.to((Object)"GET", (Object)"");
        }
        return object;
    }

    private final Pair<String, String> simpleAnnotation(UAnnotation $this$simpleAnnotation) {
        Object object;
        String httpMethod;
        String string = $this$simpleAnnotation.getQualifiedName();
        if (string == null || (string = StringsKt.substringAfterLast$default((String)string, (String)".", null, (int)2, null)) == null) {
            string = httpMethod = "GET";
        }
        if ((object = $this$simpleAnnotation.findAttributeValue("value")) == null || (object = UastUtils.evaluateString((UExpression)object)) == null) {
            object = "";
        }
        Object urlPath = object;
        return TuplesKt.to((Object)httpMethod, (Object)urlPath);
    }

    private final Pair<String, String> customMethodAnnotation(UAnnotation $this$customMethodAnnotation) {
        Object object;
        Object httpMethod;
        Object object2 = $this$customMethodAnnotation.findAttributeValue("method");
        if (object2 == null || (object2 = UastUtils.evaluateString((UExpression)object2)) == null) {
            object2 = httpMethod = "GET";
        }
        if ((object = $this$customMethodAnnotation.findAttributeValue("path")) == null || (object = UastUtils.evaluateString((UExpression)object)) == null) {
            object = "";
        }
        Object urlPath = object;
        return TuplesKt.to((Object)httpMethod, (Object)urlPath);
    }

    private final UAnnotation findRetrofitAnnotation(UMethod uMethod, List<String> expectedAnnotation) {
        Object v1;
        block5: {
            Iterable iterable = uMethod.getUAnnotations();
            for (Object t : iterable) {
                boolean bl;
                block4: {
                    UAnnotation annotation = (UAnnotation)t;
                    boolean bl2 = false;
                    Iterable $this$any$iv = expectedAnnotation;
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl = false;
                    } else {
                        for (Object element$iv : $this$any$iv) {
                            String it = (String)element$iv;
                            boolean bl3 = false;
                            if (!Intrinsics.areEqual((Object)annotation.getQualifiedName(), (Object)it)) continue;
                            bl = true;
                            break block4;
                        }
                        bl = false;
                    }
                }
                if (!bl) continue;
                v1 = t;
                break block5;
            }
            v1 = null;
        }
        return v1;
    }

    private final String inflateWithQueryParameters(UMethod uMethod, String urlPath) {
        UParameter it;
        boolean bl;
        Object element$iv$iv;
        Object element$iv$iv$iv;
        Iterable $this$mapNotNullTo$iv$iv;
        Iterable $this$mapNotNull$iv;
        Iterable iterable = uMethod.getUastParameters();
        boolean $i$f$mapNotNull = false;
        void var6_5 = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        Iterable $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            UAnnotation it$iv$iv;
            Object v0;
            block4: {
                element$iv$iv = element$iv$iv$iv = iterator.next();
                bl = false;
                it = (UParameter)element$iv$iv;
                boolean bl2 = false;
                Iterable iterable2 = it.getUAnnotations();
                for (Object t : iterable2) {
                    UAnnotation annotation = (UAnnotation)t;
                    boolean bl3 = false;
                    if (!Intrinsics.areEqual((Object)annotation.getQualifiedName(), (Object)"retrofit2.http.Query")) continue;
                    v0 = t;
                    break block4;
                }
                v0 = null;
            }
            if ((UAnnotation)v0 == null) continue;
            boolean bl4 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        $this$mapNotNull$iv = (List)destination$iv$iv;
        $i$f$mapNotNull = false;
        $this$mapNotNullTo$iv$iv = $this$mapNotNull$iv;
        destination$iv$iv = new ArrayList();
        $i$f$mapNotNullTo = false;
        $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        $i$f$forEach = false;
        iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            String it$iv$iv;
            element$iv$iv = element$iv$iv$iv = iterator.next();
            bl = false;
            it = (UAnnotation)element$iv$iv;
            boolean bl5 = false;
            UExpression uExpression = it.findAttributeValue("value");
            if ((uExpression != null ? UastUtils.evaluateString((UExpression)uExpression) : null) == null) continue;
            it$iv$iv = it$iv$iv;
            boolean bl6 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List queryParameterNames = (List)destination$iv$iv;
        if (queryParameterNames.isEmpty()) {
            return urlPath;
        }
        String query = CollectionsKt.joinToString$default((Iterable)queryParameterNames, (CharSequence)"&", (CharSequence)"?", null, (int)0, null, RetrofitUrlPathSpecification::inflateWithQueryParameters$lambda$2, (int)28, null);
        return StringsKt.removeSuffix((String)urlPath, (CharSequence)"/") + query;
    }

    private static final UrlPathContext getUrlPathContextForMethod$lambda$0(UMethod $uMethod, String $urlPath, UrlPathContext $baseContext) {
        UrlPksParser.ParsedPksUrlPath parsedPksUrl = INSTANCE.getParser().parseUrlPath(new PartiallyKnownString(INSTANCE.inflateWithQueryParameters($uMethod, $urlPath)));
        return $baseContext.withPaths(CollectionsKt.listOf((Object)parsedPksUrl.getUrlPath()));
    }

    private static final CharSequence inflateWithQueryParameters$lambda$2(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it + "=value";
    }
}

