/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.sqlite;

import com.intellij.database.Dbms;
import com.intellij.database.data.types.ColumnRef;
import com.intellij.database.data.types.ContainsInIndexedTextOperation;
import com.intellij.database.data.types.FormatTester;
import com.intellij.database.data.types.PredicateOperation;
import com.intellij.database.data.types.PredicateValue;
import com.intellij.database.data.types.PredicatesHelper;
import com.intellij.database.data.types.PredicatesUtilKt;
import com.intellij.database.data.types.StringPredicateValue;
import com.intellij.database.data.types.domain.Domain;
import com.intellij.database.dialects.base.BasePredicatesHelper;
import com.intellij.database.dialects.sqlite.model.SqliteVirtualTable;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicTableOrView;
import com.intellij.database.model.basic.BasicTableOrViewColumn;
import com.intellij.database.util.DbImplUtilCore;
import com.intellij.database.util.DdlBuilder;
import com.intellij.database.util.Version;
import com.intellij.openapi.util.text.StringUtil;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J.\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\b2\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u0014J&\u0010\u0016\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u000f\u001a\u00020\u00102\b\u0010\u0018\u001a\u0004\u0018\u00010\u00192\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u0014R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\u00020\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u001a"}, d2={"Lcom/intellij/database/dialects/sqlite/SqlitePredicatesHelper;", "Lcom/intellij/database/dialects/base/BasePredicatesHelper;", "dbms", "Lcom/intellij/database/Dbms;", "<init>", "(Lcom/intellij/database/Dbms;)V", "ftsModules", "", "", "supportsInOperator", "", "getSupportsInOperator", "()Z", "ftsPredicate", "Lcom/intellij/database/data/types/PredicatesHelper$PredicateProducer;", "columnRef", "Lcom/intellij/database/data/types/ColumnRef;", "value", "Lcom/intellij/database/data/types/PredicateValue;", "alias", "version", "Lcom/intellij/database/util/Version;", "getFormatTester", "Lcom/intellij/database/data/types/FormatTester;", "domain", "Lcom/intellij/database/data/types/domain/Domain;", "intellij.database.dialects.sqlite"})
@SourceDebugExtension(value={"SMAP\nSqlitePredicatesHelper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SqlitePredicatesHelper.kt\ncom/intellij/database/dialects/sqlite/SqlitePredicatesHelper\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,44:1\n1#2:45\n*E\n"})
public final class SqlitePredicatesHelper
extends BasePredicatesHelper {
    @NotNull
    private final Set<String> ftsModules;

    public SqlitePredicatesHelper(@NotNull Dbms dbms) {
        Intrinsics.checkNotNullParameter((Object)dbms, (String)"dbms");
        super(dbms);
        Object[] objectArray = new String[]{"FTS4", "FTS5"};
        this.ftsModules = SetsKt.setOf((Object[])objectArray);
    }

    public boolean getSupportsInOperator() {
        return true;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    protected PredicatesHelper.PredicateProducer ftsPredicate(@NotNull ColumnRef columnRef, @NotNull PredicateValue value, @Nullable String alias, @Nullable Version version) {
        String string;
        Intrinsics.checkNotNullParameter((Object)columnRef, (String)"columnRef");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        BasicTableOrViewColumn column = PredicatesUtilKt.toBasicColumn((ColumnRef)columnRef);
        if (column == null || !(value instanceof StringPredicateValue)) {
            return null;
        }
        BasicTableOrView basicTableOrView = column.getTable();
        SqliteVirtualTable sqliteVirtualTable = basicTableOrView instanceof SqliteVirtualTable ? (SqliteVirtualTable)basicTableOrView : null;
        if (sqliteVirtualTable == null) {
            return null;
        }
        SqliteVirtualTable table = sqliteVirtualTable;
        Iterable iterable = this.ftsModules;
        Object object = table.getModuleRef();
        if (object != null && (object = object.getName((BasicElement)table.getModule())) != null) {
            void it;
            Object object2 = object;
            Iterable iterable2 = iterable;
            boolean bl = false;
            string = StringUtil.toUpperCase((String)it);
            iterable = iterable2;
        } else {
            string = null;
        }
        if (!CollectionsKt.contains((Iterable)iterable, string)) {
            return null;
        }
        return new PredicatesHelper.PredicateProducer(CollectionsKt.listOf((Object)columnRef), value, (PredicateOperation)ContainsInIndexedTextOperation.INSTANCE, arg_0 -> SqlitePredicatesHelper.ftsPredicate$lambda$1(alias, columnRef, value, this, arg_0));
    }

    @Nullable
    protected FormatTester getFormatTester(@NotNull ColumnRef columnRef, @Nullable Domain domain, @Nullable Version version) {
        Intrinsics.checkNotNullParameter((Object)columnRef, (String)"columnRef");
        return null;
    }

    private static final Unit ftsPredicate$lambda$1(String $alias, ColumnRef $columnRef, PredicateValue $value, SqlitePredicatesHelper this$0, DdlBuilder builder) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        DdlBuilder ddlBuilder = PredicatesUtilKt.identifier((DdlBuilder)builder, (String)$alias, (ColumnRef)$columnRef).space().keyword("MATCH").space();
        Intrinsics.checkNotNullExpressionValue((Object)ddlBuilder, (String)"space(...)");
        PredicatesUtilKt.value((DdlBuilder)ddlBuilder, (PredicateValue)$value, (ColumnRef)$columnRef, (Dbms)this$0.getDbms(), (DbImplUtilCore.StringLiteralDecorator)DbImplUtilCore.StringLiteralDecorator.PLAIN);
        return Unit.INSTANCE;
    }
}

