/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.filters;

import com.intellij.execution.filters.ExceptionInfo;
import com.intellij.execution.filters.ExceptionInfoCache;
import com.intellij.execution.filters.ExceptionLineParser;
import com.intellij.execution.filters.ExceptionLineParserFactory;
import com.intellij.execution.filters.ExceptionLineRefiner;
import com.intellij.execution.filters.Filter;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.psi.search.GlobalSearchScope;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExceptionFilter
implements Filter,
DumbAware {
    final ExceptionInfoCache myCache;
    private final ExceptionLineParserFactory myFactory;
    private ExceptionLineRefiner myNextLineRefiner;

    public ExceptionFilter(@NotNull GlobalSearchScope scope) {
        if (scope == null) {
            ExceptionFilter.$$$reportNull$$$0(0);
        }
        this.myFactory = ExceptionLineParserFactory.getInstance();
        this.myCache = new ExceptionInfoCache(Objects.requireNonNull(scope.getProject()), scope);
    }

    public ExceptionFilter(@NotNull Project project, @NotNull GlobalSearchScope scope) {
        if (project == null) {
            ExceptionFilter.$$$reportNull$$$0(1);
        }
        if (scope == null) {
            ExceptionFilter.$$$reportNull$$$0(2);
        }
        this.myFactory = ExceptionLineParserFactory.getInstance();
        this.myCache = new ExceptionInfoCache(project, scope);
    }

    public Filter.Result applyFilter(@NotNull String line, int textEndOffset) {
        List<Filter.ResultItem> exceptionResults;
        ExceptionLineParser worker;
        Filter.Result result;
        if (line == null) {
            ExceptionFilter.$$$reportNull$$$0(3);
        }
        if ((result = (worker = this.myFactory.create(this.myCache)).execute(line, textEndOffset, this.myNextLineRefiner)) == null) {
            ExceptionInfo exceptionInfo;
            ExceptionLineRefiner refiner = this.myNextLineRefiner;
            if (refiner != null) {
                this.myNextLineRefiner = refiner.consumeNextLine(line);
                if (this.myNextLineRefiner != null) {
                    return null;
                }
            }
            this.myNextLineRefiner = (exceptionInfo = ExceptionInfo.parseMessage(line, textEndOffset)) == null ? null : exceptionInfo.getPositionRefiner();
            return null;
        }
        ExceptionInfo prevLineException = this.myNextLineRefiner == null ? null : this.myNextLineRefiner.getExceptionInfo();
        ExceptionLineRefiner nextRefiner = null;
        ExceptionLineRefiner refiner = this.myNextLineRefiner;
        if (refiner != null) {
            nextRefiner = refiner.consumeNextLine(line);
        }
        this.myNextLineRefiner = nextRefiner == null ? worker.getLocationRefiner() : nextRefiner;
        if (prevLineException != null && !(exceptionResults = this.getExceptionClassNameItems(prevLineException)).isEmpty()) {
            exceptionResults.add((Filter.ResultItem)result);
            return new Filter.Result(exceptionResults);
        }
        return result;
    }

    @ApiStatus.Internal
    @Nullable
    public ExceptionLineRefiner getLocationRefiner() {
        return this.myNextLineRefiner;
    }

    @NotNull
    List<Filter.ResultItem> getExceptionClassNameItems(ExceptionInfo prevLineException) {
        List<Filter.ResultItem> list = Collections.emptyList();
        if (list == null) {
            ExceptionFilter.$$$reportNull$$$0(4);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "line";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/execution/filters/ExceptionFilter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/execution/filters/ExceptionFilter";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getExceptionClassNameItems";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "applyFilter";
                break;
            }
            case 4: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4 -> new IllegalStateException(string);
        };
    }
}

