/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.swagger.core.actions;

import com.intellij.ide.scratch.ScratchFileService;
import com.intellij.ide.scratch.ScratchRootType;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.swagger.core.SwSpecificationDetectionKt;
import com.intellij.swagger.core.SwaggerResult;
import com.intellij.swagger.core.ui.SpecificationReferencesInlineHelper;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b \u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\u00032\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0010\u0010\r\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0012\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0018\u0010\u0012\u001a\u00020\t2\u0006\u0010\u0013\u001a\u00020\u000f2\u0006\u0010\n\u001a\u00020\u000bH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/intellij/swagger/core/actions/SwGenerateSelfContainedSpecificationAction;", "Lcom/intellij/openapi/actionSystem/AnAction;", "preferJsonOverYaml", "", "<init>", "(Z)V", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "update", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "isAvailable", "actionPerformed", "generateSelfContainedSpecification", "", "psiFile", "Lcom/intellij/psi/PsiFile;", "saveAndOpenScratch", "content", "intellij.swagger.core"})
@SourceDebugExtension(value={"SMAP\nSwGenerateSelfContainedSpecificationAction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SwGenerateSelfContainedSpecificationAction.kt\ncom/intellij/swagger/core/actions/SwGenerateSelfContainedSpecificationAction\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,83:1\n13#2:84\n*S KotlinDebug\n*F\n+ 1 SwGenerateSelfContainedSpecificationAction.kt\ncom/intellij/swagger/core/actions/SwGenerateSelfContainedSpecificationAction\n*L\n53#1:84\n*E\n"})
public abstract class SwGenerateSelfContainedSpecificationAction
extends AnAction {
    private final boolean preferJsonOverYaml;

    public SwGenerateSelfContainedSpecificationAction(boolean preferJsonOverYaml) {
        this.preferJsonOverYaml = preferJsonOverYaml;
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }

    public void update(@NotNull AnActionEvent e) {
        Presentation presentation;
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Presentation $this$update_u24lambda_u240 = presentation = e.getPresentation();
        boolean bl = false;
        boolean available = this.isAvailable(e);
        $this$update_u24lambda_u240.setEnabled(available);
        $this$update_u24lambda_u240.setVisible(available);
    }

    private final boolean isAvailable(AnActionEvent e) {
        PsiFile psiFile = (PsiFile)e.getData(CommonDataKeys.PSI_FILE);
        if (psiFile == null) {
            return false;
        }
        PsiFile psiFile2 = psiFile;
        return SwSpecificationDetectionKt.detectIsSwaggerLikeSpecificationFile$default(psiFile2, false, 2, null);
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        PsiFile psiFile = (PsiFile)e.getData(CommonDataKeys.PSI_FILE);
        if (psiFile == null) {
            return;
        }
        PsiFile psiFile2 = psiFile;
        String string = this.generateSelfContainedSpecification(psiFile2);
        if (string == null) {
            return;
        }
        String specification = string;
        this.saveAndOpenScratch(specification, e);
    }

    private final String generateSelfContainedSpecification(PsiFile psiFile) {
        SwaggerResult<String> result2;
        SpecificationReferencesInlineHelper referencesInlineHelper = new SpecificationReferencesInlineHelper(0, 1, null);
        SwaggerResult<String> specificationTextJson = referencesInlineHelper.prepareSpecificationText$intellij_swagger_core(psiFile);
        if (specificationTextJson.isFailure()) {
            boolean $i$f$logger = false;
            Logger logger = Logger.getInstance(SwGenerateSelfContainedSpecificationAction.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.warn("Unable to prepare self-contained specification text, abort export");
            return null;
        }
        String textJson = specificationTextJson.getSuccessOrThrow();
        return this.preferJsonOverYaml ? textJson : ((result2 = referencesInlineHelper.convertJsonToYaml$intellij_swagger_core(textJson, psiFile)).isFailure() ? null : result2.getSuccessOrThrow());
    }

    private final void saveAndOpenScratch(String content, AnActionEvent e) {
        Project project = (Project)e.getData(CommonDataKeys.PROJECT);
        if (project == null) {
            return;
        }
        Project project2 = project;
        PsiFile psiFile = (PsiFile)e.getData(CommonDataKeys.PSI_FILE);
        if (psiFile == null) {
            return;
        }
        PsiFile specification = psiFile;
        String string = FileUtil.sanitizeFileName((String)FileUtil.getNameWithoutExtension((String)specification.getName()));
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"sanitizeFileName(...)");
        String originalSpecificationName = string;
        String extension = this.preferJsonOverYaml ? ".json" : ".yaml";
        String generatedSpecificationName = originalSpecificationName + ".self-contained" + extension;
        VirtualFile generatedFile = ScratchRootType.getInstance().findFile(project2, generatedSpecificationName, ScratchFileService.Option.create_new_always);
        ActionsKt.runWriteAction(() -> SwGenerateSelfContainedSpecificationAction.saveAndOpenScratch$lambda$0(generatedFile, content));
        FileEditorManager $this$saveAndOpenScratch_u24lambda_u241 = FileEditorManager.getInstance((Project)project2);
        boolean bl = false;
        if (!$this$saveAndOpenScratch_u24lambda_u241.isFileOpen(generatedFile)) {
            $this$saveAndOpenScratch_u24lambda_u241.openFile(generatedFile, true);
        }
    }

    private static final Unit saveAndOpenScratch$lambda$0(VirtualFile $generatedFile, String $content) {
        VfsUtil.saveText((VirtualFile)$generatedFile, (String)$content);
        return Unit.INSTANCE;
    }
}

