/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.swagger.core.codegen;

import com.intellij.openapi.projectRoots.ProjectJdkTable;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.swagger.core.SwaggerBundle;
import com.intellij.swagger.core.SwaggerUtilsKt;
import com.intellij.swagger.core.codegen.SwJavaInfo;
import com.intellij.util.SystemProperties;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.SpreadBuilder;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u0000\u0016\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0004\u001a\u0012\u0010\u0000\u001a\u00020\u00012\b\b\u0001\u0010\u0002\u001a\u00020\u0001H\u0000\u001a\u000e\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004H\u0000\u001a\b\u0010\u0006\u001a\u00020\u0005H\u0000\u001a\u000e\u0010\u0007\u001a\u00020\u00012\u0006\u0010\b\u001a\u00020\u0001\u00a8\u0006\t"}, d2={"findJdkPathByShortName", "", "name", "getAllKnownJdks", "", "Lcom/intellij/swagger/core/codegen/SwJavaInfo;", "getDefaultJavaDistribution", "findJavaExecutableByJavaHomePath", "homePath", "intellij.swagger.core"})
@SourceDebugExtension(value={"SMAP\nSwJdkUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SwJdkUtils.kt\ncom/intellij/swagger/core/codegen/SwJdkUtilsKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,57:1\n296#2,2:58\n1807#2,3:62\n1642#2,10:66\n1915#2:76\n1916#2:78\n1652#2:79\n1696#2,8:82\n3938#3:60\n4474#3:61\n4475#3:65\n1#4:77\n37#5,2:80\n*S KotlinDebug\n*F\n+ 1 SwJdkUtils.kt\ncom/intellij/swagger/core/codegen/SwJdkUtilsKt\n*L\n16#1:58,2\n24#1:62,3\n26#1:66,10\n26#1:76\n26#1:78\n26#1:79\n31#1:82,8\n21#1:60\n21#1:61\n21#1:65\n26#1:77\n29#1:80,2\n*E\n"})
public final class SwJdkUtilsKt {
    @NotNull
    public static final String findJdkPathByShortName(@NlsSafe @NotNull String name2) {
        Object object;
        Object v0;
        block2: {
            Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
            Iterable $this$firstOrNull$iv = SwJdkUtilsKt.getAllKnownJdks();
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                SwJavaInfo it = (SwJavaInfo)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getName(), (Object)name2)) continue;
                v0 = element$iv;
                break block2;
            }
            v0 = null;
        }
        if ((object = (SwJavaInfo)v0) == null || (object = ((SwJavaInfo)object).getExecutablePath()) == null) {
            object = name2;
        }
        return object;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Collection<SwJavaInfo> getAllKnownJdks() {
        void $this$mapNotNullTo$iv$iv;
        Iterator element$iv$iv2;
        Iterable $this$filterTo$iv$iv;
        SwJavaInfo defaultJava = SwJdkUtilsKt.getDefaultJavaDistribution();
        Sdk[] sdkArray = ProjectJdkTable.getInstance().getAllJdks();
        Intrinsics.checkNotNullExpressionValue((Object)sdkArray, (String)"getAllJdks(...)");
        Object[] $this$filter$iv = sdkArray;
        boolean $i$f$filter = false;
        Object[] objectArray = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Iterator element$iv$iv2 : $this$filterTo$iv$iv) {
            boolean bl;
            block8: {
                Sdk sdk = (Sdk)element$iv$iv2;
                boolean bl2 = false;
                Intrinsics.checkNotNullExpressionValue((Object)sdk.getSdkType().getName(), (String)"getName(...)");
                Object[] objectArray2 = new String[]{"java", "kotlin", "android"};
                Iterable $this$any$iv = CollectionsKt.listOf((Object[])objectArray2);
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        String sdkTypeId;
                        String it = (String)element$iv;
                        boolean bl3 = false;
                        if (!StringsKt.contains((CharSequence)sdkTypeId, (CharSequence)it, (boolean)true)) continue;
                        bl = true;
                        break block8;
                    }
                    bl = false;
                }
            }
            if (!bl) continue;
            destination$iv$iv.add(element$iv$iv2);
        }
        Iterable $this$mapNotNull$iv = (List)destination$iv$iv;
        boolean $i$f$mapNotNull = false;
        $this$filterTo$iv$iv = $this$mapNotNull$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        element$iv$iv2 = $this$forEach$iv$iv$iv.iterator();
        while (element$iv$iv2.hasNext()) {
            SwJavaInfo swJavaInfo;
            Object element$iv$iv$iv;
            Object element$iv$iv3 = element$iv$iv$iv = element$iv$iv2.next();
            boolean bl = false;
            Sdk it = (Sdk)element$iv$iv3;
            boolean bl4 = false;
            if (it.getHomePath() == null) {
                swJavaInfo = null;
            } else {
                String homePath;
                String string = SwJdkUtilsKt.findJavaExecutableByJavaHomePath(homePath);
                String string2 = it.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getName(...)");
                swJavaInfo = new SwJavaInfo(string, string2);
            }
            if (swJavaInfo == null) continue;
            SwJavaInfo it$iv$iv = swJavaInfo;
            boolean bl5 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        Collection $this$toTypedArray$iv = (List)destination$iv$iv;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        SwJavaInfo[] jdkArray = thisCollection$iv.toArray(new SwJavaInfo[0]);
        $this$toTypedArray$iv = new SpreadBuilder(2);
        $this$toTypedArray$iv.add(defaultJava);
        $this$toTypedArray$iv.addSpread(jdkArray);
        Iterable $this$distinctBy$iv = CollectionsKt.listOf((Object[])$this$toTypedArray$iv.toArray(new SwJavaInfo[$this$toTypedArray$iv.size()]));
        boolean $i$f$distinctBy = false;
        HashSet<String> set$iv = new HashSet<String>();
        ArrayList list$iv = new ArrayList();
        for (Object e$iv : $this$distinctBy$iv) {
            SwJavaInfo it = (SwJavaInfo)e$iv;
            boolean bl = false;
            String key$iv = it.getExecutablePath();
            if (!set$iv.add(key$iv)) continue;
            list$iv.add(e$iv);
        }
        return list$iv;
    }

    @NotNull
    public static final SwJavaInfo getDefaultJavaDistribution() {
        String string = SystemProperties.getJavaHome();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getJavaHome(...)");
        return new SwJavaInfo(SwJdkUtilsKt.findJavaExecutableByJavaHomePath(string), SwaggerBundle.message("run.configuration.default.java.executable.title", new Object[0]));
    }

    @NotNull
    public static final String findJavaExecutableByJavaHomePath(@NotNull String homePath) {
        String string;
        StringBuilder stringBuilder;
        Intrinsics.checkNotNullParameter((Object)homePath, (String)"homePath");
        String string2 = FileUtil.toSystemIndependentName((String)homePath);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toSystemIndependentName(...)");
        String systemIndependentJavaHome = string2;
        StringBuilder $this$findJavaExecutableByJavaHomePath_u24lambda_u240 = stringBuilder = new StringBuilder();
        boolean bl = false;
        String systemDependentName = SystemInfo.isWindows ? "java.exe" : "java";
        $this$findJavaExecutableByJavaHomePath_u24lambda_u240.append("bin");
        $this$findJavaExecutableByJavaHomePath_u24lambda_u240.append("/");
        $this$findJavaExecutableByJavaHomePath_u24lambda_u240.append(systemDependentName);
        String executableSuffix = stringBuilder.toString();
        if (StringsKt.endsWith$default((String)systemIndependentJavaHome, (String)executableSuffix, (boolean)false, (int)2, null)) {
            string = systemIndependentJavaHome;
        } else {
            StringBuilder stringBuilder2;
            StringBuilder $this$findJavaExecutableByJavaHomePath_u24lambda_u241 = stringBuilder2 = new StringBuilder();
            boolean bl2 = false;
            $this$findJavaExecutableByJavaHomePath_u24lambda_u241.append(systemIndependentJavaHome);
            $this$findJavaExecutableByJavaHomePath_u24lambda_u241.append("/");
            $this$findJavaExecutableByJavaHomePath_u24lambda_u241.append(executableSuffix);
            string = stringBuilder2.toString();
        }
        String javaExecutable = string;
        return SwaggerUtilsKt.toSystemDependentPath(javaExecutable);
    }
}

