/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.kubernetes.helm;

import com.intellij.codeWithMe.ClientId;
import com.intellij.kubernetes.YamlUtilKt;
import com.intellij.kubernetes.helm.chart.Chart;
import com.intellij.kubernetes.helm.model.HelmModelProvider;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.vdurmont.semver4j.Requirement;
import com.vdurmont.semver4j.Semver;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.yaml.meta.impl.YamlMetaTypeProvider;
import org.jetbrains.yaml.meta.model.YamlMetaType;
import org.jetbrains.yaml.psi.YAMLKeyValue;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u0000B\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u001a\u000e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003\u001a \u0010\u0012\u001a\u0004\u0018\u0001H\u0013\"\n\b\u0000\u0010\u0013\u0018\u0001*\u00020\u0014*\u00020\u000fH\u0086\b\u00a2\u0006\u0002\u0010\u0015\u001a\u0010\u0010\u0016\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u0018\u001a\u00020\u0003\u001a\u0012\u0010\u0019\u001a\u00020\u0001*\u00020\u00172\u0006\u0010\u001a\u001a\u00020\u0003\"\u0015\u0010\u0004\u001a\u00020\u0001*\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0006\"\u0017\u0010\u0007\u001a\u0004\u0018\u00010\b*\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000b\"\u001c\u0010\f\u001a\t\u0018\u00010\r\u00a2\u0006\u0002\b\u000e*\u00020\u000f8F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u001b"}, d2={"isValidGoTemplateIdentifier", "", "name", "", "isChartsTemplateElement", "Lcom/intellij/psi/PsiElement;", "(Lcom/intellij/psi/PsiElement;)Z", "helmMetaTypeProvider", "Lorg/jetbrains/yaml/meta/impl/YamlMetaTypeProvider;", "Lcom/intellij/psi/PsiFile;", "getHelmMetaTypeProvider", "(Lcom/intellij/psi/PsiFile;)Lorg/jetbrains/yaml/meta/impl/YamlMetaTypeProvider;", "valueHelmMetaTypeProxy", "Lorg/jetbrains/yaml/meta/impl/YamlMetaTypeProvider$MetaTypeProxy;", "Lorg/jetbrains/annotations/Nullable;", "Lorg/jetbrains/yaml/psi/YAMLKeyValue;", "getValueHelmMetaTypeProxy", "(Lorg/jetbrains/yaml/psi/YAMLKeyValue;)Lorg/jetbrains/yaml/meta/impl/YamlMetaTypeProvider$MetaTypeProxy;", "valueHelmMetaType", "T", "Lorg/jetbrains/yaml/meta/model/YamlMetaType;", "(Lorg/jetbrains/yaml/psi/YAMLKeyValue;)Lorg/jetbrains/yaml/meta/model/YamlMetaType;", "buildDependencyVersionRequirementWoExceptions", "Lcom/vdurmont/semver4j/Requirement;", "semVerSpec", "isSatisfiedWoExceptions", "semVer", "intellij.clouds.kubernetes.backend"})
@SourceDebugExtension(value={"SMAP\nHelmUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HelmUtil.kt\ncom/intellij/kubernetes/helm/HelmUtilKt\n+ 2 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n+ 3 service.kt\ncom/intellij/openapi/components/ServiceKt\n*L\n1#1,49:1\n1107#2,2:50\n42#3,3:52\n*S KotlinDebug\n*F\n+ 1 HelmUtil.kt\ncom/intellij/kubernetes/helm/HelmUtilKt\n*L\n19#1:50,2\n24#1:52,3\n*E\n"})
public final class HelmUtilKt {
    public static final boolean isValidGoTemplateIdentifier(@NotNull String name) {
        boolean bl;
        block2: {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            if (((CharSequence)name).length() == 0) {
                return false;
            }
            CharSequence $this$any$iv = name;
            boolean $i$f$any = false;
            for (int i = 0; i < $this$any$iv.length(); ++i) {
                char element$iv;
                char it = element$iv = $this$any$iv.charAt(i);
                boolean bl2 = false;
                if (!(!Character.isLetterOrDigit(it) && it != '_')) continue;
                bl = true;
                break block2;
            }
            bl = false;
        }
        return !bl && !Character.isDigit(StringsKt.first((CharSequence)name));
    }

    public static final boolean isChartsTemplateElement(@NotNull PsiElement $this$isChartsTemplateElement) {
        Intrinsics.checkNotNullParameter((Object)$this$isChartsTemplateElement, (String)"<this>");
        return Chart.Companion.isChartsTemplateFile(YamlUtilKt.getVfsFile((PsiElement)$this$isChartsTemplateElement));
    }

    @Nullable
    public static final YamlMetaTypeProvider getHelmMetaTypeProvider(@NotNull PsiFile $this$helmMetaTypeProvider) {
        Intrinsics.checkNotNullParameter((Object)$this$helmMetaTypeProvider, (String)"<this>");
        boolean $i$f$service = false;
        Class<HelmModelProvider> serviceClass$iv = HelmModelProvider.class;
        Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
        if (object == null) {
            throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
        }
        return ((HelmModelProvider)object).getMetaTypeProvider($this$helmMetaTypeProvider);
    }

    @Nullable
    public static final YamlMetaTypeProvider.MetaTypeProxy getValueHelmMetaTypeProxy(@NotNull YAMLKeyValue $this$valueHelmMetaTypeProxy) {
        Intrinsics.checkNotNullParameter((Object)$this$valueHelmMetaTypeProxy, (String)"<this>");
        PsiFile psiFile = $this$valueHelmMetaTypeProxy.getContainingFile();
        return psiFile != null && (psiFile = psiFile.getOriginalFile()) != null && (psiFile = HelmUtilKt.getHelmMetaTypeProvider(psiFile)) != null ? psiFile.getKeyValueMetaType($this$valueHelmMetaTypeProxy) : null;
    }

    public static final /* synthetic */ <T extends YamlMetaType> T valueHelmMetaType(YAMLKeyValue $this$valueHelmMetaType) {
        Intrinsics.checkNotNullParameter((Object)$this$valueHelmMetaType, (String)"<this>");
        boolean $i$f$valueHelmMetaType = false;
        YamlMetaTypeProvider.MetaTypeProxy metaTypeProxy = HelmUtilKt.getValueHelmMetaTypeProxy($this$valueHelmMetaType);
        Object object = metaTypeProxy != null ? metaTypeProxy.getMetaType() : null;
        Intrinsics.reifiedOperationMarker((int)2, (String)"T");
        return (T)object;
    }

    @Nullable
    public static final Requirement buildDependencyVersionRequirementWoExceptions(@NotNull String semVerSpec) {
        Requirement requirement;
        Intrinsics.checkNotNullParameter((Object)semVerSpec, (String)"semVerSpec");
        try {
            requirement = Requirement.buildNPM((String)semVerSpec);
        }
        catch (Exception e) {
            requirement = null;
        }
        return requirement;
    }

    public static final boolean isSatisfiedWoExceptions(@NotNull Requirement $this$isSatisfiedWoExceptions, @NotNull String semVer) {
        Intrinsics.checkNotNullParameter((Object)$this$isSatisfiedWoExceptions, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)semVer, (String)"semVer");
        try {
            return $this$isSatisfiedWoExceptions.isSatisfiedBy(new Semver(semVer, Semver.SemverType.NPM));
        }
        catch (Exception e) {
            return false;
        }
    }
}

