/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.kubernetes.helm.werf;

import com.intellij.kubernetes.YamlUtilKt;
import com.intellij.kubernetes.helm.CustomChartSupport;
import com.intellij.kubernetes.helm.chart.Chart;
import com.intellij.kubernetes.helm.model.HelmObject;
import com.intellij.kubernetes.helm.model.HelmObjectMetaClass;
import com.intellij.kubernetes.helm.model.HelmResolveTarget;
import com.intellij.kubernetes.helm.model.PathInChart;
import com.intellij.kubernetes.helm.model.SimpleHelmObject;
import com.intellij.kubernetes.helm.model.spec.Definition;
import com.intellij.kubernetes.helm.model.spec.ModelSpecKt;
import com.intellij.kubernetes.helm.werf.GlobalWerfObject;
import com.intellij.kubernetes.helm.werf.WerfChartSupportKt;
import com.intellij.kubernetes.helm.werf.WerfObject;
import com.intellij.kubernetes.helm.werf.WerfUtilKt;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.yaml.meta.impl.YamlMetaTypeProvider;
import org.jetbrains.yaml.meta.model.Field;
import org.jetbrains.yaml.meta.model.YamlMetaType;
import org.jetbrains.yaml.psi.YAMLDocument;
import org.jetbrains.yaml.psi.YAMLFile;
import org.jetbrains.yaml.psi.YAMLMapping;
import org.jetbrains.yaml.psi.YAMLValue;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J(\u0010\b\u001a\u001a\u0012\u0016\u0012\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\f0\u000b\u0012\u0004\u0012\u00020\r0\n0\t2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0007H\u0016J\u0012\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0012\u0010\u0017\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\u001a\u0010&\u001a\u00020\f2\b\u0010'\u001a\u0004\u0018\u00010\u00072\u0006\u0010(\u001a\u00020)H\u0002R'\u0010\u001b\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u001d0\u001c8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b \u0010!\u001a\u0004\b\u001e\u0010\u001fR\u001b\u0010\"\u001a\u00020\u00148BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b%\u0010!\u001a\u0004\b#\u0010$\u00a8\u0006*"}, d2={"Lcom/intellij/kubernetes/helm/werf/WerfChartSupport;", "Lcom/intellij/kubernetes/helm/CustomChartSupport;", "<init>", "()V", "getCustomChartInfo", "Lcom/intellij/kubernetes/helm/CustomChartSupport$CustomChartInfo;", "chartDirCandidate", "Lcom/intellij/openapi/vfs/VirtualFile;", "collectObjects", "", "Lkotlin/Pair;", "", "", "Lcom/intellij/kubernetes/helm/model/HelmObject;", "chart", "Lcom/intellij/kubernetes/helm/chart/Chart;", "isValueContainer", "", "file", "getMetaTypeProvider", "Lorg/jetbrains/yaml/meta/impl/YamlMetaTypeProvider;", "psiFile", "Lcom/intellij/psi/PsiFile;", "getResolveTarget", "Lcom/intellij/kubernetes/helm/model/HelmResolveTarget;", "pathInChart", "Lcom/intellij/kubernetes/helm/model/PathInChart;", "werfSchemas", "", "Lcom/intellij/kubernetes/helm/model/spec/Definition;", "getWerfSchemas", "()Ljava/util/Map;", "werfSchemas$delegate", "Lkotlin/Lazy;", "werfYamlProvider", "getWerfYamlProvider", "()Lorg/jetbrains/yaml/meta/impl/YamlMetaTypeProvider;", "werfYamlProvider$delegate", "calculateWerfProjectName", "werfFile", "project", "Lcom/intellij/openapi/project/Project;", "intellij.clouds.kubernetes.backend"})
@SourceDebugExtension(value={"SMAP\nWerfChartSupport.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WerfChartSupport.kt\ncom/intellij/kubernetes/helm/werf/WerfChartSupport\n+ 2 MiscUtil.kt\ncom/intellij/kubernetes/MiscUtilKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,85:1\n133#2:86\n133#2:87\n133#2:88\n133#2:89\n1#3:90\n*S KotlinDebug\n*F\n+ 1 WerfChartSupport.kt\ncom/intellij/kubernetes/helm/werf/WerfChartSupport\n*L\n22#1:86\n39#1:87\n53#1:88\n56#1:89\n*E\n"})
public final class WerfChartSupport
implements CustomChartSupport {
    @NotNull
    private final Lazy werfSchemas$delegate = LazyKt.lazy(WerfChartSupport::werfSchemas_delegate$lambda$0);
    @NotNull
    private final Lazy werfYamlProvider$delegate = LazyKt.lazy(() -> WerfChartSupport.werfYamlProvider_delegate$lambda$0(this));

    @Override
    @Nullable
    public CustomChartSupport.CustomChartInfo getCustomChartInfo(@NotNull VirtualFile chartDirCandidate) {
        CustomChartSupport.CustomChartInfo customChartInfo;
        Intrinsics.checkNotNullParameter((Object)chartDirCandidate, (String)"chartDirCandidate");
        boolean condition$iv = Intrinsics.areEqual((Object)chartDirCandidate.getName(), (Object)".helm");
        boolean $i$f$doIf = false;
        if (condition$iv) {
            boolean bl = false;
            customChartInfo = new CustomChartSupport.CustomChartInfo("werf", arg_0 -> WerfChartSupport.getCustomChartInfo$lambda$0$0(this, chartDirCandidate, arg_0));
        } else {
            customChartInfo = null;
        }
        return customChartInfo;
    }

    @Override
    @NotNull
    public Collection<Pair<List<String>, HelmObject>> collectObjects(@NotNull Chart chart) {
        List list;
        Intrinsics.checkNotNullParameter((Object)chart, (String)"chart");
        boolean condition$iv = WerfChartSupportKt.access$isWerf(chart);
        boolean $i$f$doIf = false;
        if (condition$iv) {
            boolean bl = false;
            Object[] objectArray = new Pair[3];
            Object[] objectArray2 = new String[]{"Values", "werf"};
            objectArray[0] = TuplesKt.to((Object)CollectionsKt.listOf((Object[])objectArray2), (Object)new WerfObject(chart));
            objectArray2 = new String[]{"Values", "global", "werf"};
            objectArray[1] = TuplesKt.to((Object)CollectionsKt.listOf((Object[])objectArray2), (Object)new GlobalWerfObject(chart));
            objectArray2 = new String[]{"Values", "global", "env"};
            objectArray[2] = TuplesKt.to((Object)CollectionsKt.listOf((Object[])objectArray2), (Object)new SimpleHelmObject(){
                private final String description;
                {
                    this.description = "Name of a CI/CD environment used during the current deploy process";
                }

                public String getDescription() {
                    return this.description;
                }
            });
            list = CollectionsKt.listOf((Object[])objectArray);
        } else {
            list = null;
        }
        return list != null ? (Collection)list : (Collection)CollectionsKt.emptyList();
    }

    @Override
    public boolean isValueContainer(@NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return YamlUtilKt.isYamlWithName((String)"werf", (CharSequence)file.getNameSequence());
    }

    @Override
    @Nullable
    public YamlMetaTypeProvider getMetaTypeProvider(@NotNull PsiFile psiFile) {
        YamlMetaTypeProvider yamlMetaTypeProvider;
        Intrinsics.checkNotNullParameter((Object)psiFile, (String)"psiFile");
        VirtualFile virtualFile = YamlUtilKt.getVfsFile((PsiElement)((PsiElement)psiFile));
        boolean condition$iv = YamlUtilKt.isYamlWithName((String)"werf", (CharSequence)(virtualFile != null ? virtualFile.getNameSequence() : null));
        boolean $i$f$doIf = false;
        if (condition$iv) {
            boolean bl = false;
            yamlMetaTypeProvider = this.getWerfYamlProvider();
        } else {
            yamlMetaTypeProvider = null;
        }
        return yamlMetaTypeProvider;
    }

    @Override
    @Nullable
    public HelmResolveTarget getResolveTarget(@NotNull PathInChart pathInChart) {
        HelmResolveTarget helmResolveTarget;
        Intrinsics.checkNotNullParameter((Object)pathInChart, (String)"pathInChart");
        boolean condition$iv = WerfChartSupportKt.access$isWerf(pathInChart.getChart()) && WerfUtilKt.isWerfImageNamePath(pathInChart.getObjectPath());
        boolean $i$f$doIf = false;
        if (condition$iv) {
            boolean bl = false;
            helmResolveTarget = WerfUtilKt.imageNameResolveTarget(pathInChart.getChart(), (String)CollectionsKt.last(pathInChart.getObjectPath().getFullPath()));
        } else {
            helmResolveTarget = null;
        }
        return helmResolveTarget;
    }

    private final Map<String, Definition> getWerfSchemas() {
        Lazy lazy = this.werfSchemas$delegate;
        return (Map)lazy.getValue();
    }

    private final YamlMetaTypeProvider getWerfYamlProvider() {
        Lazy lazy = this.werfYamlProvider$delegate;
        return (YamlMetaTypeProvider)lazy.getValue();
    }

    private final String calculateWerfProjectName(VirtualFile werfFile, Project project) {
        Object object;
        block5: {
            VirtualFile virtualFile;
            block4: {
                Object object2;
                object = werfFile;
                if (object == null || (object = YamlUtilKt.getYamlPsi((VirtualFile)object, (Project)project)) == null || (object = WerfUtilKt.findWerfProjectName((YAMLFile)object)) == null || (object = YamlUtilKt.getEffectiveText((YAMLValue)((YAMLValue)object))) == null) break block4;
                Object p0 = object2 = object;
                boolean bl = false;
                object = ((CharSequence)p0).length() > 0 ? object2 : null;
                if (object != null) break block5;
            }
            if (((virtualFile = werfFile) != null && (virtualFile = virtualFile.getParent()) != null ? virtualFile.getName() : (object = null)) == null) {
                object = "werf";
            }
        }
        return object;
    }

    private static final Chart.Info getCustomChartInfo$lambda$0$0(WerfChartSupport this$0, VirtualFile $chartDirCandidate, Project it) {
        VirtualFile virtualFile = $chartDirCandidate.getParent();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getParent(...)");
        VirtualFile virtualFile2 = YamlUtilKt.findYamlWithName((VirtualFile)virtualFile, (String)"werf");
        Intrinsics.checkNotNull((Object)it);
        return new Chart.Info(this$0.calculateWerfProjectName(virtualFile2, it), "v2", "1.0.0", null, false);
    }

    private static final Map werfSchemas_delegate$lambda$0() {
        return ModelSpecKt.loadObjects("helm-spec/werf.json");
    }

    private static final Field werfYamlProvider_delegate$lambda$0$0(WerfChartSupport this$0, YAMLDocument it) {
        Field field2;
        YAMLMapping topLevelMapping;
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        YAMLMapping yAMLMapping = topLevelMapping = YamlUtilKt.getTopLevelMapping((YAMLDocument)it);
        if ((yAMLMapping != null ? yAMLMapping.getKeyValueByKey("project") : null) != null) {
            field2 = new Field("Meta", (YamlMetaType)new HelmObjectMetaClass("Meta", (Definition)MapsKt.getValue(this$0.getWerfSchemas(), (Object)"Meta")));
        } else {
            YAMLMapping yAMLMapping2 = topLevelMapping;
            field2 = (yAMLMapping2 != null ? yAMLMapping2.getKeyValueByKey("image") : null) != null ? (topLevelMapping.getKeyValueByKey("dockerfile") != null ? new Field("Dockerfile", (YamlMetaType)new HelmObjectMetaClass("Dockerfile", (Definition)MapsKt.getValue(this$0.getWerfSchemas(), (Object)"Dockerfile"))) : (topLevelMapping.getKeyValueByKey("from") != null ? new Field("Stapel", (YamlMetaType)new HelmObjectMetaClass("Stapel", (Definition)MapsKt.getValue(this$0.getWerfSchemas(), (Object)"Stapel"))) : new Field("UnknownImage", (YamlMetaType)new HelmObjectMetaClass("UnknownImage", (Definition)MapsKt.getValue(this$0.getWerfSchemas(), (Object)"UnknownImage"))))) : new Field("Unknown", (YamlMetaType)new HelmObjectMetaClass("Unknown", (Definition)MapsKt.getValue(this$0.getWerfSchemas(), (Object)"Unknown")));
        }
        return field2;
    }

    private static final long werfYamlProvider_delegate$lambda$0$1() {
        return 0L;
    }

    private static final YamlMetaTypeProvider werfYamlProvider_delegate$lambda$0(WerfChartSupport this$0) {
        return new YamlMetaTypeProvider(arg_0 -> WerfChartSupport.werfYamlProvider_delegate$lambda$0$0(this$0, arg_0), WerfChartSupport::werfYamlProvider_delegate$lambda$0$1);
    }
}

