/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.kubernetes.logs;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.RegexOption;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\f\b\u0016\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\u000e\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u0003J&\u0010\u0010\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0005H\u0016R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\u0006\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\f\u00a8\u0006\u0011"}, d2={"Lcom/intellij/kubernetes/logs/KubernetesTextLogFilterSettings;", "", "request", "", "matchCase", "", "useRegex", "<init>", "(Ljava/lang/String;ZZ)V", "getRequest", "()Ljava/lang/String;", "getMatchCase", "()Z", "getUseRegex", "apply", "text", "copy", "intellij.clouds.kubernetes.backend"})
public class KubernetesTextLogFilterSettings {
    @NotNull
    private final String request;
    private final boolean matchCase;
    private final boolean useRegex;

    public KubernetesTextLogFilterSettings(@NotNull String request, boolean matchCase, boolean useRegex) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        this.request = request;
        this.matchCase = matchCase;
        this.useRegex = useRegex;
    }

    @NotNull
    public String getRequest() {
        return this.request;
    }

    public boolean getMatchCase() {
        return this.matchCase;
    }

    public boolean getUseRegex() {
        return this.useRegex;
    }

    public final boolean apply(@NotNull String text) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        if (this.getUseRegex()) {
            Regex regex = this.getMatchCase() ? new Regex(this.getRequest()) : new Regex(this.getRequest(), RegexOption.IGNORE_CASE);
            bl = regex.containsMatchIn((CharSequence)text);
        } else {
            bl = this.getMatchCase() ? StringsKt.contains$default((CharSequence)text, (CharSequence)this.getRequest(), (boolean)false, (int)2, null) : StringsKt.contains((CharSequence)text, (CharSequence)this.getRequest(), (boolean)true);
        }
        return bl;
    }

    @NotNull
    public KubernetesTextLogFilterSettings copy(@NotNull String request, boolean matchCase, boolean useRegex) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        return new KubernetesTextLogFilterSettings(request, matchCase, useRegex);
    }

    public static /* synthetic */ KubernetesTextLogFilterSettings copy$default(KubernetesTextLogFilterSettings kubernetesTextLogFilterSettings, String string, boolean bl, boolean bl2, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: copy");
        }
        if ((n & 1) != 0) {
            string = kubernetesTextLogFilterSettings.getRequest();
        }
        if ((n & 2) != 0) {
            bl = kubernetesTextLogFilterSettings.getMatchCase();
        }
        if ((n & 4) != 0) {
            bl2 = kubernetesTextLogFilterSettings.getUseRegex();
        }
        return kubernetesTextLogFilterSettings.copy(string, bl, bl2);
    }
}

