/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.kubernetes.logs.ui;

import com.intellij.kubernetes.i18n.KubernetesBundle;
import com.intellij.kubernetes.logs.KubernetesTextFilterModel;
import com.intellij.kubernetes.logs.KubernetesTextLogFilterSettings;
import com.intellij.kubernetes.logs.ui.MyActionButton;
import com.intellij.kubernetes.logs.ui.MyK8sLogTextFilterField;
import com.intellij.kubernetes.logs.ui.TextFilterField;
import com.intellij.kubernetes.view.ui.KubernetesConsolePanel;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ex.ActionButtonLook;
import com.intellij.openapi.actionSystem.impl.ActionButton;
import com.intellij.openapi.actionSystem.impl.ActionToolbarImpl;
import com.intellij.openapi.actionSystem.impl.FieldInplaceActionButtonLook;
import com.intellij.ui.SearchTextField;
import com.intellij.ui.components.SearchFieldWithExtension;
import java.awt.Dimension;
import java.util.function.Supplier;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u0000:\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\u001a\u001e\u0010\u0006\u001a\u00020\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u000b\u001a\u00020\fH\u0000\u001a\u001e\u0010\r\u001a\u00020\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u000b\u001a\u00020\fH\u0000\u001a\u001a\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002\"\u0014\u0010\u0000\u001a\u00020\u0001X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0002\u0010\u0003\"\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"logActionsToolbarPlaceName", "", "getLogActionsToolbarPlaceName", "()Ljava/lang/String;", "MAGIC_DEBOUNCE_MS", "", "buildLogsFilterField", "Lcom/intellij/kubernetes/logs/ui/MyK8sLogTextFilterField;", "textFilterModel", "Lcom/intellij/kubernetes/logs/KubernetesTextFilterModel;", "Lcom/intellij/kubernetes/logs/KubernetesTextLogFilterSettings;", "parentDisposable", "Lcom/intellij/openapi/Disposable;", "buildPatternsFilterField", "createTextActionsToolbar", "Lcom/intellij/openapi/actionSystem/ActionToolbar;", "editor", "Ljavax/swing/JComponent;", "addActions", "", "intellij.clouds.kubernetes.backend"})
public final class KubernetesLogFilterTabPanelKt {
    @NotNull
    private static final String logActionsToolbarPlaceName = KubernetesConsolePanel.class.getSimpleName() + "#Toolbar";
    private static final int MAGIC_DEBOUNCE_MS = 1000;

    @NotNull
    public static final String getLogActionsToolbarPlaceName() {
        return logActionsToolbarPlaceName;
    }

    @NotNull
    public static final MyK8sLogTextFilterField buildLogsFilterField(@NotNull KubernetesTextFilterModel<KubernetesTextLogFilterSettings> textFilterModel, @NotNull Disposable parentDisposable) {
        Intrinsics.checkNotNullParameter(textFilterModel, (String)"textFilterModel");
        Intrinsics.checkNotNullParameter((Object)parentDisposable, (String)"parentDisposable");
        TextFilterField field2 = new TextFilterField(textFilterModel, parentDisposable){

            public String getOnEmptyText() {
                String string = KubernetesBundle.message((String)"k8s.logs.filter.logs.text", (Object[])new Object[0]);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                return string;
            }

            public String getTooltipText() {
                String string = KubernetesBundle.message((String)"k8s.logs.enter.text.or.regex.to.filter.logs", (Object[])new Object[0]);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                return string;
            }
        };
        ActionToolbar filterToolbar = KubernetesLogFilterTabPanelKt.createTextActionsToolbar((JComponent)field2.getTextEditor(), true);
        JComponent jComponent = filterToolbar.getComponent();
        Intrinsics.checkNotNullExpressionValue((Object)jComponent, (String)"getComponent(...)");
        MyK8sLogTextFilterField textFilterField = new MyK8sLogTextFilterField(new SearchFieldWithExtension(jComponent, (SearchTextField)field2), field2);
        return textFilterField;
    }

    @NotNull
    public static final MyK8sLogTextFilterField buildPatternsFilterField(@NotNull KubernetesTextFilterModel<KubernetesTextLogFilterSettings> textFilterModel, @NotNull Disposable parentDisposable) {
        Intrinsics.checkNotNullParameter(textFilterModel, (String)"textFilterModel");
        Intrinsics.checkNotNullParameter((Object)parentDisposable, (String)"parentDisposable");
        TextFilterField field2 = new TextFilterField(textFilterModel, parentDisposable){

            public String getOnEmptyText() {
                String string = KubernetesBundle.message((String)"k8s.logs.filter.patterns.text", (Object[])new Object[0]);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                return string;
            }

            public String getTooltipText() {
                String string = KubernetesBundle.message((String)"k8s.logs.enter.text.or.regex.to.filter.patterns", (Object[])new Object[0]);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                return string;
            }
        };
        ActionToolbar filterToolbar = KubernetesLogFilterTabPanelKt.createTextActionsToolbar((JComponent)field2.getTextEditor(), false);
        JComponent jComponent = filterToolbar.getComponent();
        Intrinsics.checkNotNullExpressionValue((Object)jComponent, (String)"getComponent(...)");
        MyK8sLogTextFilterField textFilterField = new MyK8sLogTextFilterField(new SearchFieldWithExtension(jComponent, (SearchTextField)field2), field2);
        return textFilterField;
    }

    private static final ActionToolbar createTextActionsToolbar(JComponent editor, boolean addActions) {
        DefaultActionGroup defaultActionGroup;
        if (addActions) {
            AnAction anAction = ActionManager.getInstance().getAction("Kubernetes.Log.TextFilterSettings");
            Intrinsics.checkNotNull((Object)anAction, (String)"null cannot be cast to non-null type com.intellij.openapi.actionSystem.DefaultActionGroup");
            defaultActionGroup = (DefaultActionGroup)anAction;
        } else {
            defaultActionGroup = new DefaultActionGroup();
        }
        DefaultActionGroup textActionGroup = defaultActionGroup;
        String string = logActionsToolbarPlaceName;
        ActionToolbarImpl toolbar2 = new ActionToolbarImpl(textActionGroup, string){

            protected ActionButton createToolbarButton(AnAction action, ActionButtonLook look, String place, Presentation presentation, Supplier<? extends Dimension> minimumSize) {
                Intrinsics.checkNotNullParameter((Object)action, (String)"action");
                Intrinsics.checkNotNullParameter((Object)place, (String)"place");
                Intrinsics.checkNotNullParameter((Object)presentation, (String)"presentation");
                Intrinsics.checkNotNullParameter(minimumSize, (String)"minimumSize");
                MyActionButton button = new MyActionButton(action, presentation);
                button.setFocusable(true);
                this.applyToolbarLook(look, presentation, (JComponent)((Object)button));
                return button;
            }

            protected boolean canReuseActionButton(ActionButton oldActionButton, Presentation newPresentation) {
                Intrinsics.checkNotNullParameter((Object)oldActionButton, (String)"oldActionButton");
                Intrinsics.checkNotNullParameter((Object)newPresentation, (String)"newPresentation");
                return Intrinsics.areEqual(oldActionButton.getClass(), MyActionButton.class);
            }
        };
        toolbar2.setCustomButtonLook((ActionButtonLook)new FieldInplaceActionButtonLook());
        toolbar2.setReservePlaceAutoPopupIcon(false);
        toolbar2.setTargetComponent(editor);
        return (ActionToolbar)toolbar2;
    }
}

