/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.kubernetes.references;

import com.intellij.codeInsight.TargetElementUtil;
import com.intellij.kubernetes.KubernetesResolver;
import com.intellij.kubernetes.KubernetesUtilKt;
import com.intellij.kubernetes.MiscUtilKt;
import com.intellij.kubernetes.i18n.KubernetesBundle;
import com.intellij.kubernetes.references.InClusterElement;
import com.intellij.kubernetes.references.KubernetesResourceReference;
import com.intellij.kubernetes.references.KubernetesResourceRenameHandler;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.CoroutinesKt;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.Project;
import com.intellij.platform.ide.progress.TasksKt;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.SearchScope;
import com.intellij.refactoring.BaseRefactoringProcessor;
import com.intellij.refactoring.rename.RenameDialog;
import com.intellij.refactoring.rename.RenameHandler;
import com.intellij.ui.JBColor;
import com.intellij.ui.components.JBLabel;
import com.intellij.usageView.UsageInfo;
import com.intellij.usageView.UsageViewDescriptor;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.swing.JPanel;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.yaml.YAMLElementGenerator;
import org.jetbrains.yaml.psi.YAMLKeyValue;
import org.jetbrains.yaml.psi.YAMLScalar;
import org.jetbrains.yaml.psi.YAMLValue;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J/\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u0096\u0002J2\u0010\u0010\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00150\u00122\u0006\u0010\u0016\u001a\u00020\u0017J0\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u000e\u0010\u0018\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u001a0\u00192\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u0096\u0002\u00a2\u0006\u0002\u0010\u001bJ&\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00150\u00122\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"H\u0002J\u0014\u0010#\u001a\u0004\u0018\u00010\"2\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u0002\u00a8\u0006$"}, d2={"Lcom/intellij/kubernetes/references/KubernetesResourceRenameHandler;", "Lcom/intellij/refactoring/rename/RenameHandler;", "<init>", "()V", "isAvailableOnDataContext", "", "dataContext", "Lcom/intellij/openapi/actionSystem/DataContext;", "invoke", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "file", "Lcom/intellij/psi/PsiFile;", "rename", "targets", "", "Lorg/jetbrains/yaml/psi/YAMLValue;", "usages", "Lcom/intellij/usageView/UsageInfo;", "newName", "", "elements", "", "Lcom/intellij/psi/PsiElement;", "(Lcom/intellij/openapi/project/Project;[Lcom/intellij/psi/PsiElement;Lcom/intellij/openapi/actionSystem/DataContext;)V", "findUsages", "scope", "Lcom/intellij/psi/search/SearchScope;", "resolver", "Lcom/intellij/kubernetes/KubernetesResolver;", "ref", "Lcom/intellij/kubernetes/references/KubernetesResourceReference;", "getKubernetesResourceReference", "intellij.clouds.kubernetes.backend"})
@SourceDebugExtension(value={"SMAP\nKubernetesResourceRenameHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KubernetesResourceRenameHandler.kt\ncom/intellij/kubernetes/references/KubernetesResourceRenameHandler\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,156:1\n777#2:157\n873#2,2:158\n1586#2:160\n1661#2,3:161\n1915#2,2:164\n1915#2,2:166\n*S KotlinDebug\n*F\n+ 1 KubernetesResourceRenameHandler.kt\ncom/intellij/kubernetes/references/KubernetesResourceRenameHandler\n*L\n53#1:157\n53#1:158,2\n145#1:160\n145#1:161,3\n126#1:164,2\n132#1:166,2\n*E\n"})
public final class KubernetesResourceRenameHandler
implements RenameHandler {
    public boolean isAvailableOnDataContext(@NotNull DataContext dataContext) {
        Intrinsics.checkNotNullParameter((Object)dataContext, (String)"dataContext");
        return this.getKubernetesResourceReference(dataContext) != null;
    }

    /*
     * WARNING - void declaration
     */
    public void invoke(@NotNull Project project, @Nullable Editor editor, @Nullable PsiFile file, @Nullable DataContext dataContext) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        if (dataContext == null) {
            return;
        }
        KubernetesResourceReference kubernetesResourceReference = this.getKubernetesResourceReference(dataContext);
        if (kubernetesResourceReference == null) {
            return;
        }
        KubernetesResourceReference ref = kubernetesResourceReference;
        KubernetesResourceReference.ResourceInfo resourceInfo = ref.getResourceInfo();
        if (resourceInfo == null) {
            return;
        }
        KubernetesResourceReference.ResourceInfo resourceInfo2 = resourceInfo;
        String string = KubernetesBundle.message((String)"KubernetesResourceRenameHandler.searching.for.reference", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        Collection targets2 = (Collection)TasksKt.runWithModalProgressBlocking((Project)project, (String)string, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Collection<? extends PsiElement>>, Object>(ref, null){
            int label;
            final /* synthetic */ KubernetesResourceReference $ref;
            {
                this.$ref = $ref;
                super(2, $completion);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object $result) {
                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        this.label = 1;
                        Object object2 = CoroutinesKt.readAction(() -> invoke.targets.1.invokeSuspend$lambda$0(this.$ref), (Continuation)((Continuation)this));
                        if (object2 != object) return object2;
                        return object;
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        Object object2 = $result;
                        return object2;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Collection<? extends PsiElement>> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }

            private static final Collection invokeSuspend$lambda$0(KubernetesResourceReference $ref) {
                return MiscUtilKt.resolveToPsi((PsiReference)$ref);
            }
        }));
        Iterable $this$filter$iv = targets2;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            PsiElement it = (PsiElement)element$iv$iv;
            boolean bl = false;
            if (!(!(it instanceof InClusterElement))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List inSourceTargets = (List)destination$iv$iv;
        PsiElement psiElement = (PsiElement)CollectionsKt.firstOrNull((Iterable)targets2);
        if (psiElement == null) {
            return;
        }
        PsiElement mainTarget = psiElement;
        RenameDialog dialog2 = new RenameDialog(project, mainTarget, editor, resourceInfo2, targets2, inSourceTargets, this, ref){
            final /* synthetic */ Project $project;
            final /* synthetic */ KubernetesResourceReference.ResourceInfo $resourceInfo;
            final /* synthetic */ Collection<PsiElement> $targets;
            final /* synthetic */ List<PsiElement> $inSourceTargets;
            final /* synthetic */ KubernetesResourceRenameHandler this$0;
            final /* synthetic */ KubernetesResourceReference $ref;
            {
                this.$project = $project;
                this.$resourceInfo = $resourceInfo;
                this.$targets = $targets;
                this.$inSourceTargets = $inSourceTargets;
                this.this$0 = $receiver;
                this.$ref = $ref;
                super($project, $mainTarget, null, $editor);
            }

            protected void canRun() {
                super.canRun();
                String string = this.getNewName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getNewName(...)");
                if (!KubernetesUtilKt.isResourceNameValid(string)) {
                    throw new ConfigurationException(KubernetesBundle.message((String)"KubernetesResourceRenameHandler.invalid.name.error", (Object[])new Object[0]));
                }
            }

            protected boolean areButtonsValid() {
                return true;
            }

            protected boolean isToSearchForTextOccurrencesForRename() {
                return false;
            }

            protected boolean isToSearchInCommentsForRename() {
                return false;
            }

            protected String getFullName() {
                return this.$resourceInfo.getKind() + " \"" + this.$resourceInfo.getName() + "\"";
            }

            /*
             * WARNING - void declaration
             */
            protected void createCheckboxes(JPanel panel2, GridBagConstraints gbConstraints) {
                block1: {
                    super.createCheckboxes(panel2, gbConstraints);
                    this.getCbSearchInComments().setVisible(false);
                    if (this.$targets.size() == this.$inSourceTargets.size()) break block1;
                    JPanel jPanel = panel2;
                    if (jPanel != null) {
                        void it;
                        JBLabel jBLabel;
                        JBLabel jBLabel2 = jBLabel = new JBLabel(KubernetesBundle.message((String)"KubernetesResourceRenameHandler.unable.noInClusterRenames.warning", (Object[])new Object[0]));
                        JPanel jPanel2 = jPanel;
                        boolean bl = false;
                        it.setForeground((Color)new JBColor(new Color(127, 127, 0), new Color(127, 127, 0)));
                        jPanel2.add((Component)jBLabel, gbConstraints);
                    }
                }
            }

            public void performRename(String newName) {
                Intrinsics.checkNotNullParameter((Object)newName, (String)"newName");
                this.invokeRefactoring(new BaseRefactoringProcessor(this.$project, this.$inSourceTargets, this.$resourceInfo, this.this$0, this, this.$ref, newName){
                    private final KubernetesResolver resolver;
                    final /* synthetic */ Project $project;
                    final /* synthetic */ List<PsiElement> $inSourceTargets;
                    final /* synthetic */ KubernetesResourceReference.ResourceInfo $resourceInfo;
                    final /* synthetic */ KubernetesResourceRenameHandler this$0;
                    final /* synthetic */ invoke.dialog.1 this$1;
                    final /* synthetic */ KubernetesResourceReference $ref;
                    final /* synthetic */ String $newName;
                    {
                        this.$project = $project;
                        this.$inSourceTargets = $inSourceTargets;
                        this.$resourceInfo = $resourceInfo;
                        this.this$0 = $receiver;
                        this.this$1 = $receiver2;
                        this.$ref = $ref;
                        this.$newName = $newName;
                        super($project);
                        ComponentManager $this$service$iv = (ComponentManager)$project;
                        boolean $i$f$service = false;
                        Class<KubernetesResolver> serviceClass$iv = KubernetesResolver.class;
                        Object object = $this$service$iv.getService(serviceClass$iv);
                        if (object == null) {
                            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
                        }
                        this.resolver = (KubernetesResolver)object;
                    }

                    public final KubernetesResolver getResolver() {
                        return this.resolver;
                    }

                    protected UsageViewDescriptor createUsageViewDescriptor(UsageInfo[] usages) {
                        Intrinsics.checkNotNullParameter((Object)usages, (String)"usages");
                        return new UsageViewDescriptor(this.$inSourceTargets, this.$resourceInfo){
                            final /* synthetic */ List<PsiElement> $inSourceTargets;
                            final /* synthetic */ KubernetesResourceReference.ResourceInfo $resourceInfo;
                            {
                                this.$inSourceTargets = $inSourceTargets;
                                this.$resourceInfo = $resourceInfo;
                            }

                            public PsiElement[] getElements() {
                                Collection $this$toTypedArray$iv = this.$inSourceTargets;
                                boolean $i$f$toTypedArray = false;
                                Collection thisCollection$iv = $this$toTypedArray$iv;
                                return thisCollection$iv.toArray(new PsiElement[0]);
                            }

                            public String getProcessedElementsHeader() {
                                Object[] objectArray = new Object[]{this.$resourceInfo.getName()};
                                String string = KubernetesBundle.message((String)"KubernetesResourceRenameHandler.processed.elements.header", (Object[])objectArray);
                                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                                return string;
                            }

                            public String getCodeReferencesText(int usagesCount, int filesCount) {
                                Object[] objectArray = new Object[]{usagesCount, filesCount};
                                String string = KubernetesBundle.message((String)"KubernetesResourceRenameHandler.code.references.text", (Object[])objectArray);
                                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                                return string;
                            }
                        };
                    }

                    protected UsageInfo[] findUsages() {
                        SearchScope searchScope = this.this$1.getRefactoringScope();
                        Intrinsics.checkNotNullExpressionValue((Object)searchScope, (String)"getRefactoringScope(...)");
                        Collection $this$toTypedArray$iv = KubernetesResourceRenameHandler.access$findUsages(this.this$0, searchScope, this.resolver, this.$ref);
                        boolean $i$f$toTypedArray = false;
                        Collection thisCollection$iv = $this$toTypedArray$iv;
                        return thisCollection$iv.toArray(new UsageInfo[0]);
                    }

                    /*
                     * WARNING - void declaration
                     */
                    protected void performRefactoring(UsageInfo[] usages) {
                        void $this$mapNotNullTo$iv$iv;
                        void $this$mapNotNull$iv;
                        Intrinsics.checkNotNullParameter((Object)usages, (String)"usages");
                        Iterable iterable = this.$inSourceTargets;
                        Project project = this.$project;
                        KubernetesResourceRenameHandler kubernetesResourceRenameHandler = this.this$0;
                        boolean $i$f$mapNotNull = false;
                        void var4_6 = $this$mapNotNull$iv;
                        Collection destination$iv$iv = new ArrayList<E>();
                        boolean $i$f$mapNotNullTo = false;
                        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                        boolean $i$f$forEach = false;
                        Iterator<T> iterator = $this$forEach$iv$iv$iv.iterator();
                        while (iterator.hasNext()) {
                            YAMLValue it$iv$iv;
                            T element$iv$iv$iv;
                            T element$iv$iv = element$iv$iv$iv = iterator.next();
                            boolean bl = false;
                            PsiElement it = (PsiElement)element$iv$iv;
                            boolean bl2 = false;
                            if ((it instanceof YAMLValue ? (YAMLValue)it : null) == null) continue;
                            it$iv$iv = it$iv$iv;
                            boolean bl3 = false;
                            destination$iv$iv.add(it$iv$iv);
                        }
                        List list = (List)destination$iv$iv;
                        kubernetesResourceRenameHandler.rename(project, list, ArraysKt.asList((Object[])usages), this.$newName);
                    }

                    protected String getCommandName() {
                        String string = KubernetesBundle.message((String)"KubernetesResourceRenameHandler.command.name", (Object[])new Object[0]);
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                        return string;
                    }
                });
                this.close(0);
            }
        };
        RenameDialog.showRenameDialog((DataContext)dataContext, (RenameDialog)dialog2);
    }

    public final void rename(@NotNull Project project, @NotNull Collection<? extends YAMLValue> targets2, @NotNull Collection<? extends UsageInfo> usages, @NotNull String newName) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(targets2, (String)"targets");
        Intrinsics.checkNotNullParameter(usages, (String)"usages");
        Intrinsics.checkNotNullParameter((Object)newName, (String)"newName");
        WriteCommandAction.runWriteCommandAction((Project)project, () -> KubernetesResourceRenameHandler.rename$lambda$0(project, usages, targets2, newName));
    }

    public void invoke(@NotNull Project project, @NotNull PsiElement[] elements, @Nullable DataContext dataContext) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)elements, (String)"elements");
    }

    /*
     * WARNING - void declaration
     */
    private final Collection<UsageInfo> findUsages(SearchScope scope2, KubernetesResolver resolver, KubernetesResourceReference ref) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        KubernetesResourceReference.ResourceInfo resourceInfo = ref.getResourceInfo();
        if (resourceInfo == null) {
            return CollectionsKt.emptyList();
        }
        KubernetesResourceReference.ResourceInfo resourceInfo2 = resourceInfo;
        Iterable iterable = resolver.findKubernetesObjectReferrers(scope2, ref.getElement(), resourceInfo2.getName(), resourceInfo2.getKind());
        boolean $i$f$map = false;
        void var7_7 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            YAMLKeyValue yAMLKeyValue = (YAMLKeyValue)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            YAMLValue yAMLValue = it.getValue();
            Intrinsics.checkNotNull((Object)yAMLValue);
            collection.add(new UsageInfo((PsiElement)yAMLValue, false));
        }
        return (List)destination$iv$iv;
    }

    private final KubernetesResourceReference getKubernetesResourceReference(DataContext dataContext) {
        if (dataContext == null) {
            return null;
        }
        Editor editor = (Editor)CommonDataKeys.EDITOR.getData(dataContext);
        if (editor == null) {
            return null;
        }
        Editor editor2 = editor;
        PsiReference psiReference = TargetElementUtil.findReference((Editor)editor2);
        return psiReference instanceof KubernetesResourceReference ? (KubernetesResourceReference)psiReference : null;
    }

    private static final void rename$lambda$0(Project $project, Collection $usages, Collection $targets, String $newName) {
        UsageInfo it;
        YAMLElementGenerator gen = YAMLElementGenerator.getInstance((Project)$project);
        Iterable $this$forEach$iv = $usages;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            YAMLKeyValue newVal;
            YAMLScalar usageElement;
            it = (UsageInfo)element$iv;
            boolean bl = false;
            PsiElement psiElement = it.getElement();
            if ((psiElement instanceof YAMLScalar ? (YAMLScalar)psiElement : null) == null) continue;
            usageElement = usageElement;
            Intrinsics.checkNotNullExpressionValue((Object)gen.createYamlKeyValue("dummyKey", $newName), (String)"createYamlKeyValue(...)");
            YAMLValue yAMLValue = newVal.getValue();
            Intrinsics.checkNotNull((Object)yAMLValue);
            usageElement.replace((PsiElement)yAMLValue);
        }
        $this$forEach$iv = $targets;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            YAMLKeyValue newVal;
            it = (YAMLValue)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)gen.createYamlKeyValue("dummyKey", $newName), (String)"createYamlKeyValue(...)");
            YAMLValue yAMLValue = newVal.getValue();
            Intrinsics.checkNotNull((Object)yAMLValue);
            it.replace((PsiElement)yAMLValue);
        }
    }

    public static final /* synthetic */ Collection access$findUsages(KubernetesResourceRenameHandler $this, SearchScope scope2, KubernetesResolver resolver, KubernetesResourceReference ref) {
        return $this.findUsages(scope2, resolver, ref);
    }
}

