/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.kubernetes.ui.intentions;

import com.intellij.kubernetes.helm.HelmDependencyRepository;
import com.intellij.kubernetes.helm.dependencies.HelmIndex;
import com.intellij.kubernetes.helm.dependencies.HelmIndexKt;
import com.intellij.kubernetes.helm.dependencies.dto.HubRepoDto;
import com.intellij.kubernetes.i18n.KubernetesBundle;
import com.intellij.kubernetes.ui.intentions.HelmConvertRepositoryIntentionActionBase;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.project.Project;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J\b\u0010\u0006\u001a\u00020\u0005H\u0016J\u001a\u0010\u0007\u001a\u0004\u0018\u00010\u00052\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\f"}, d2={"Lcom/intellij/kubernetes/ui/intentions/HelmConvertRepositoryUrlToAliasAction;", "Lcom/intellij/kubernetes/ui/intentions/HelmConvertRepositoryIntentionActionBase;", "<init>", "()V", "getFamilyName", "", "getText", "getValueToSwitchTo", "project", "Lcom/intellij/openapi/project/Project;", "repo", "Lcom/intellij/kubernetes/helm/HelmDependencyRepository;", "intellij.clouds.kubernetes.backend"})
@SourceDebugExtension(value={"SMAP\nHelmIntentions.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HelmIntentions.kt\ncom/intellij/kubernetes/ui/intentions/HelmConvertRepositoryUrlToAliasAction\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,155:1\n30#2,2:156\n1#3:158\n*S KotlinDebug\n*F\n+ 1 HelmIntentions.kt\ncom/intellij/kubernetes/ui/intentions/HelmConvertRepositoryUrlToAliasAction\n*L\n108#1:156,2\n*E\n"})
public final class HelmConvertRepositoryUrlToAliasAction
extends HelmConvertRepositoryIntentionActionBase {
    @NotNull
    public String getFamilyName() {
        String string = KubernetesBundle.message((String)"HelmConvertRepositoryUrlToAliasAction.family.name", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    @NotNull
    public String getText() {
        String string = KubernetesBundle.message((String)"HelmConvertRepositoryUrlToAliasAction.text", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    @Override
    @Nullable
    public String getValueToSwitchTo(@NotNull Project project, @NotNull HelmDependencyRepository repo) {
        String string;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)repo, (String)"repo");
        if (repo.getSpecifiedUrl() == null) {
            return null;
        }
        ComponentManager $this$service$iv = (ComponentManager)project;
        boolean $i$f$service = false;
        Class<HelmIndex> serviceClass$iv = HelmIndex.class;
        Object object = $this$service$iv.getService(serviceClass$iv);
        if (object == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        Object object2 = HelmIndexKt.findAddedRepoByUrl((HelmIndex)object, repo.getSpecifiedUrl());
        if (object2 != null && (object2 = ((HubRepoDto)object2).getName()) != null) {
            Object it = object2;
            boolean bl = false;
            string = "alias:" + (String)it;
        } else {
            string = null;
        }
        return string;
    }
}

