/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.quarkus.config.datasource.action;

import com.intellij.lang.properties.psi.Property;
import com.intellij.lang.properties.psi.impl.PropertiesFileImpl;
import com.intellij.microservices.jvm.config.properties.MicroservicePropertiesDocument;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.persistence.database.ConfigDataSourceProvider;
import com.intellij.persistence.database.DataSourcePropertyWithPrefixDataInfo;
import com.intellij.persistence.database.KeyPrefixInfo;
import com.intellij.persistence.database.config.properties.processor.PropertiesConfigDataSourceSinglePropertyProcessor;
import com.intellij.psi.PsiElement;
import com.intellij.quarkus.config.QsConfigUtils;
import com.intellij.quarkus.config.datasource.QsDataSourceConfigType;
import com.intellij.quarkus.config.datasource.QsDataSourceProvider;
import com.intellij.quarkus.config.datasource.QsPropertiesConfigDatasourceLineMarkerProviderKt;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001c\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0016J\u0012\u0010\u0014\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\"\u0010\u0017\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u0002H\u0016J\u001e\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001e0\u000b2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u001f\u001a\u00020 H\u0016R \u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u001a\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00020\u000bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006!"}, d2={"Lcom/intellij/quarkus/config/datasource/action/QsPropertiesConfigDataSourceSinglePropertyProcessor;", "Lcom/intellij/persistence/database/config/properties/processor/PropertiesConfigDataSourceSinglePropertyProcessor;", "Lcom/intellij/quarkus/config/datasource/QsDataSourceConfigType;", "Lcom/intellij/persistence/database/DataSourcePropertyWithPrefixDataInfo;", "<init>", "()V", "dataSourceProvider", "Lcom/intellij/persistence/database/ConfigDataSourceProvider;", "getDataSourceProvider", "()Lcom/intellij/persistence/database/ConfigDataSourceProvider;", "supportedDataSourceTypes", "", "getSupportedDataSourceTypes", "()Ljava/util/List;", "isApplicable", "", "module", "Lcom/intellij/openapi/module/Module;", "project", "Lcom/intellij/openapi/project/Project;", "findFirstApplicableConfigType", "key", "", "convertToInfo", "property", "Lcom/intellij/lang/properties/psi/Property;", "documentId", "", "type", "getDocuments", "Lcom/intellij/microservices/jvm/config/properties/MicroservicePropertiesDocument;", "file", "Lcom/intellij/lang/properties/psi/impl/PropertiesFileImpl;", "intellij.quarkus"})
final class QsPropertiesConfigDataSourceSinglePropertyProcessor
extends PropertiesConfigDataSourceSinglePropertyProcessor<QsDataSourceConfigType, DataSourcePropertyWithPrefixDataInfo> {
    @NotNull
    private final ConfigDataSourceProvider<QsDataSourceConfigType, DataSourcePropertyWithPrefixDataInfo> dataSourceProvider = new QsDataSourceProvider();
    @NotNull
    private final List<QsDataSourceConfigType> supportedDataSourceTypes = (List)QsDataSourceConfigType.getEntries();

    @NotNull
    public ConfigDataSourceProvider<QsDataSourceConfigType, DataSourcePropertyWithPrefixDataInfo> getDataSourceProvider() {
        return this.dataSourceProvider;
    }

    @NotNull
    public List<QsDataSourceConfigType> getSupportedDataSourceTypes() {
        return this.supportedDataSourceTypes;
    }

    public boolean isApplicable(@Nullable Module module, @Nullable Project project) {
        return QsPropertiesConfigDatasourceLineMarkerProviderKt.hasQuarkus(module, project);
    }

    @Nullable
    public QsDataSourceConfigType findFirstApplicableConfigType(@NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        String keyWithoutProfile = QsConfigUtils.INSTANCE.trimProfile(key);
        return (QsDataSourceConfigType)super.findFirstApplicableConfigType(keyWithoutProfile);
    }

    @Nullable
    public DataSourcePropertyWithPrefixDataInfo convertToInfo(@NotNull Property property, int documentId, @NotNull QsDataSourceConfigType type) {
        Intrinsics.checkNotNullParameter((Object)property, (String)"property");
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        String string = property.getKey();
        if (string == null) {
            return null;
        }
        String key = string;
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)((PsiElement)property));
        if (module == null) {
            return null;
        }
        Module module2 = module;
        KeyPrefixInfo keyPrefixInfo = QsPropertiesConfigDatasourceLineMarkerProviderKt.getPrefixInfo(key, type, module2);
        if (keyPrefixInfo == null) {
            return null;
        }
        KeyPrefixInfo prefixInfo = keyPrefixInfo;
        return new DataSourcePropertyWithPrefixDataInfo((PsiElement)property, documentId, prefixInfo, module2);
    }

    @NotNull
    public List<MicroservicePropertiesDocument> getDocuments(@NotNull Module module, @NotNull PropertiesFileImpl file) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        List list = file.getProperties();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getProperties(...)");
        return CollectionsKt.listOf((Object)new MicroservicePropertiesDocument(list, 0));
    }
}

