/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.quarkus.config.hints;

import com.intellij.microservices.jvm.config.ConfigKeyPathReference;
import com.intellij.microservices.jvm.config.MetaConfigKey;
import com.intellij.microservices.jvm.config.hints.BooleanHintReferenceProvider;
import com.intellij.microservices.jvm.config.hints.ClassHintReferenceProvider;
import com.intellij.microservices.jvm.config.hints.DoubleHintReferenceProvider;
import com.intellij.microservices.jvm.config.hints.EncodingHintReferenceProvider;
import com.intellij.microservices.jvm.config.hints.FloatHintReferenceProvider;
import com.intellij.microservices.jvm.config.hints.HintReferenceProvider;
import com.intellij.microservices.jvm.config.hints.IntegerHintReferenceProvider;
import com.intellij.microservices.jvm.config.hints.LocaleHintReferenceProvider;
import com.intellij.microservices.jvm.config.hints.LongHintReferenceProvider;
import com.intellij.microservices.jvm.config.hints.StaticValuesHintReferenceProvider;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.paths.GlobalPathReferenceProvider;
import com.intellij.openapi.paths.WebReference;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceBase;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiWildcardType;
import com.intellij.psi.impl.beanProperties.BeanPropertyElement;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.quarkus.config.QsConfigUtils;
import com.intellij.quarkus.config.hints.QsDurationHintReferenceProvider;
import com.intellij.quarkus.config.hints.QsEnumHintReferenceProvider;
import com.intellij.quarkus.config.hints.QsMemorySizeHintReferenceProvider;
import com.intellij.util.ProcessingContext;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.ArraysKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.APP})
@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u0000 \u001e2\u00020\u0001:\u0001\u001eB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003JA\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\u00052\u0006\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u00102\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u00132\u0006\u0010\u0015\u001a\u00020\u0016\u00a2\u0006\u0002\u0010\u0017J\u001b\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\f0\u00052\u0006\u0010\u0011\u001a\u00020\u0010H\u0002\u00a2\u0006\u0002\u0010\u0019J\u0014\u0010\u001a\u001a\u0004\u0018\u00010\n2\b\u0010\u001b\u001a\u0004\u0018\u00010\u001cH\u0002J\u0012\u0010\u001d\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002R\u0016\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0007R\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lcom/intellij/quarkus/config/hints/QsHintReferencesProvider;", "", "<init>", "()V", "KNOWN_LOGGING_LEVELS", "", "", "[Ljava/lang/String;", "myByTypeProviders", "", "Lcom/intellij/microservices/jvm/config/hints/HintReferenceProvider;", "getValueReferences", "Lcom/intellij/psi/PsiReference;", "key", "Lcom/intellij/microservices/jvm/config/MetaConfigKey;", "keyPsiElement", "Lcom/intellij/psi/PsiElement;", "valuePsiElement", "valueTextRanges", "", "Lcom/intellij/openapi/util/TextRange;", "context", "Lcom/intellij/util/ProcessingContext;", "(Lcom/intellij/microservices/jvm/config/MetaConfigKey;Lcom/intellij/psi/PsiElement;Lcom/intellij/psi/PsiElement;Ljava/util/List;Lcom/intellij/util/ProcessingContext;)[Lcom/intellij/psi/PsiReference;", "getEraseOtherReferences", "(Lcom/intellij/psi/PsiElement;)[Lcom/intellij/psi/PsiReference;", "getByTypeProvider", "valueType", "Lcom/intellij/psi/PsiType;", "getPojoValueProvider", "Companion", "intellij.quarkus"})
public final class QsHintReferencesProvider {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String[] KNOWN_LOGGING_LEVELS;
    @NotNull
    private final Map<String, HintReferenceProvider> myByTypeProviders;

    public QsHintReferencesProvider() {
        String[] stringArray = new String[]{"ALL", "OFF", "SEVERE", "WARNING", "INFO", "CONFIG", "FINE", "FINER", "FINEST", "FATAL", "ERROR", "WARN", "INFO", "DEBUG", "TRACE"};
        this.KNOWN_LOGGING_LEVELS = stringArray;
        stringArray = new Pair[13];
        stringArray[0] = TuplesKt.to((Object)"java.lang.Boolean", (Object)new BooleanHintReferenceProvider());
        stringArray[1] = TuplesKt.to((Object)"java.lang.Integer", (Object)new IntegerHintReferenceProvider());
        stringArray[2] = TuplesKt.to((Object)"java.lang.Long", (Object)new LongHintReferenceProvider());
        stringArray[3] = TuplesKt.to((Object)"java.lang.Double", (Object)new DoubleHintReferenceProvider());
        stringArray[4] = TuplesKt.to((Object)"java.lang.Float", (Object)new FloatHintReferenceProvider());
        stringArray[5] = TuplesKt.to((Object)"java.util.OptionalInt", (Object)new IntegerHintReferenceProvider());
        stringArray[6] = TuplesKt.to((Object)"java.util.OptionalLong", (Object)new LongHintReferenceProvider());
        stringArray[7] = TuplesKt.to((Object)"java.util.OptionalDouble", (Object)new DoubleHintReferenceProvider());
        stringArray[8] = TuplesKt.to((Object)"java.nio.charset.Charset", (Object)new EncodingHintReferenceProvider());
        stringArray[9] = TuplesKt.to((Object)"java.util.Locale", (Object)new LocaleHintReferenceProvider());
        stringArray[10] = TuplesKt.to((Object)"java.time.Duration", (Object)((Object)new QsDurationHintReferenceProvider()));
        stringArray[11] = TuplesKt.to((Object)"io.quarkus.runtime.configuration.MemorySize", (Object)((Object)new QsMemorySizeHintReferenceProvider()));
        String[] stringArray2 = this.KNOWN_LOGGING_LEVELS;
        stringArray[12] = TuplesKt.to((Object)"java.util.logging.Level", (Object)new StaticValuesHintReferenceProvider(true, false, null, Arrays.copyOf(stringArray2, stringArray2.length)));
        this.myByTypeProviders = MapsKt.mapOf((Pair[])stringArray);
    }

    @NotNull
    public final PsiReference[] getValueReferences(@NotNull MetaConfigKey key, @Nullable PsiElement keyPsiElement, @NotNull PsiElement valuePsiElement, @NotNull List<? extends TextRange> valueTextRanges, @NotNull ProcessingContext context) {
        PsiReference[] psiReferenceArray;
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)valuePsiElement, (String)"valuePsiElement");
        Intrinsics.checkNotNullParameter(valueTextRanges, (String)"valueTextRanges");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        HintReferenceProvider byTypeProvider = this.getByTypeProvider(key.getEffectiveValueElementType());
        if (byTypeProvider != null) {
            PsiReference[] psiReferenceArray2 = byTypeProvider.getReferences(valuePsiElement, valueTextRanges, context);
            Intrinsics.checkNotNullExpressionValue((Object)psiReferenceArray2, (String)"getReferences(...)");
            return psiReferenceArray2;
        }
        if (keyPsiElement == null) {
            Intrinsics.checkNotNullExpressionValue((Object)PsiReference.EMPTY_ARRAY, (String)"EMPTY_ARRAY");
            return PsiReference.EMPTY_ARRAY;
        }
        if (!MetaConfigKey.MAP_OR_INDEXED_WITHOUT_KEY_HINTS_CONDITION.value((Object)key)) {
            return this.getEraseOtherReferences(valuePsiElement);
        }
        HintReferenceProvider pojoReferenceProvider = this.getPojoValueProvider(keyPsiElement);
        if (pojoReferenceProvider != null) {
            PsiReference[] psiReferenceArray3 = pojoReferenceProvider.getReferences(valuePsiElement, valueTextRanges, context);
            Intrinsics.checkNotNull((Object)psiReferenceArray3);
            psiReferenceArray = psiReferenceArray3;
        } else {
            psiReferenceArray = this.getEraseOtherReferences(valuePsiElement);
        }
        return psiReferenceArray;
    }

    private final PsiReference[] getEraseOtherReferences(PsiElement valuePsiElement) {
        if (WebReference.isWebReferenceWorthy((PsiElement)valuePsiElement) && valuePsiElement.textContains(':')) {
            String string = ElementManipulators.getValueText((PsiElement)valuePsiElement);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getValueText(...)");
            String valueText = string;
            if (GlobalPathReferenceProvider.isWebReferenceUrl((String)valueText)) {
                Intrinsics.checkNotNullExpressionValue((Object)PsiReference.EMPTY_ARRAY, (String)"EMPTY_ARRAY");
                return PsiReference.EMPTY_ARRAY;
            }
        }
        PsiReference[] psiReferenceArray = new PsiReference[1];
        Intrinsics.checkNotNullExpressionValue((Object)PsiReferenceBase.createSelfReference((PsiElement)valuePsiElement, (PsiElement)valuePsiElement), (String)"createSelfReference(...)");
        return psiReferenceArray;
    }

    private final HintReferenceProvider getByTypeProvider(PsiType valueType) {
        if (valueType == null) {
            return null;
        }
        PsiType type = QsConfigUtils.INSTANCE.unwrapOptional(valueType);
        if (!type.isValid()) {
            return null;
        }
        if (type instanceof PsiPrimitiveType) {
            return this.myByTypeProviders.get(((PsiPrimitiveType)type).getBoxedTypeName());
        }
        PsiClass psiClass = PsiTypesUtil.getPsiClass((PsiType)type);
        if (psiClass == null) {
            return null;
        }
        PsiClass typeClass = psiClass;
        if (typeClass.isEnum()) {
            return (HintReferenceProvider)new QsEnumHintReferenceProvider(typeClass);
        }
        String string = typeClass.getQualifiedName();
        if (string == null) {
            return null;
        }
        String typeFqn = string;
        if (Intrinsics.areEqual((Object)"java.lang.Class", (Object)typeFqn)) {
            Intrinsics.checkNotNull((Object)type, (String)"null cannot be cast to non-null type com.intellij.psi.PsiClassType");
            PsiType[] psiTypeArray = ((PsiClassType)type).getParameters();
            Intrinsics.checkNotNullExpressionValue((Object)psiTypeArray, (String)"getParameters(...)");
            PsiType[] parameters = psiTypeArray;
            if (parameters.length != 1) {
                return (HintReferenceProvider)new ClassHintReferenceProvider(null, false, Boolean.valueOf(true));
            }
            PsiType psiType = parameters[0];
            PsiWildcardType psiWildcardType = psiType instanceof PsiWildcardType ? (PsiWildcardType)psiType : null;
            if (psiWildcardType == null) {
                return null;
            }
            PsiWildcardType typeParameter = psiWildcardType;
            return (HintReferenceProvider)new ClassHintReferenceProvider(typeParameter.getExtendsBound().getCanonicalText(), false, Boolean.valueOf(true));
        }
        return this.myByTypeProviders.get(typeFqn);
    }

    private final HintReferenceProvider getPojoValueProvider(PsiElement keyPsiElement) {
        PsiReference[] psiReferenceArray = keyPsiElement.getReferences();
        Intrinsics.checkNotNullExpressionValue((Object)psiReferenceArray, (String)"getReferences(...)");
        Object object = ArraysKt.lastOrNull((Object[])psiReferenceArray);
        ConfigKeyPathReference configKeyPathReference = object instanceof ConfigKeyPathReference ? (ConfigKeyPathReference)object : null;
        if (configKeyPathReference == null) {
            return null;
        }
        ConfigKeyPathReference lastReference = configKeyPathReference;
        if (lastReference.getPathType() != ConfigKeyPathReference.PathType.BEAN_PROPERTY) {
            return null;
        }
        PsiElement psiElement = lastReference.resolve();
        BeanPropertyElement beanPropertyElement = psiElement instanceof BeanPropertyElement ? (BeanPropertyElement)psiElement : null;
        if (beanPropertyElement == null) {
            return null;
        }
        BeanPropertyElement resolve = beanPropertyElement;
        PsiType psiType = resolve.getPropertyType();
        Intrinsics.checkNotNull((Object)psiType);
        return this.getByTypeProvider(psiType);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0004\u001a\u00020\u0005\u00a8\u0006\u0006"}, d2={"Lcom/intellij/quarkus/config/hints/QsHintReferencesProvider$Companion;", "", "<init>", "()V", "getInstance", "Lcom/intellij/quarkus/config/hints/QsHintReferencesProvider;", "intellij.quarkus"})
    @SourceDebugExtension(value={"SMAP\nQsHintReferencesProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 QsHintReferencesProvider.kt\ncom/intellij/quarkus/config/hints/QsHintReferencesProvider$Companion\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,117:1\n30#2,2:118\n*S KotlinDebug\n*F\n+ 1 QsHintReferencesProvider.kt\ncom/intellij/quarkus/config/hints/QsHintReferencesProvider$Companion\n*L\n23#1:118,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final QsHintReferencesProvider getInstance() {
            Application application = ApplicationManager.getApplication();
            Intrinsics.checkNotNullExpressionValue((Object)application, (String)"getApplication(...)");
            ComponentManager $this$service$iv = (ComponentManager)application;
            boolean $i$f$service = false;
            Class<QsHintReferencesProvider> serviceClass$iv = QsHintReferencesProvider.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            return (QsHintReferencesProvider)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

