/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.committed;

import com.intellij.CommonBundle;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.AbstractVcsHelper;
import com.intellij.openapi.vcs.CommittedChangesProvider;
import com.intellij.openapi.vcs.RepositoryLocation;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.changes.committed.CommittedChangesCache;
import com.intellij.openapi.vcs.ui.VcsBalloonProblemNotifier;
import com.intellij.openapi.vcs.versionBrowser.ChangeBrowserSettings;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.vcsUtil.VcsUtil;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u0000&\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a \u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u001a\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002\u00a8\u0006\f"}, d2={"showCommittedChanges", "", "vcs", "Lcom/intellij/openapi/vcs/AbstractVcs;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "settings", "Lcom/intellij/openapi/vcs/versionBrowser/ChangeBrowserSettings;", "askMaxCount", "", "project", "Lcom/intellij/openapi/project/Project;", "intellij.platform.vcs.impl"})
public final class BrowseCommittedChangesActionKt {
    private static final void showCommittedChanges(AbstractVcs vcs, VirtualFile file, ChangeBrowserSettings settings) {
        int maxCount;
        if (!settings.isAnyFilterSpecified()) {
            Project project = vcs.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            v1 = BrowseCommittedChangesActionKt.askMaxCount(project);
        } else {
            v1 = maxCount = 0;
        }
        if (maxCount < 0) {
            return;
        }
        RepositoryLocation repositoryLocation = CommittedChangesCache.getInstance(vcs.getProject()).getLocationCache().getLocation(vcs, VcsUtil.getFilePath((VirtualFile)file), false);
        if (repositoryLocation == null) {
            Object[] objectArray = new Object[]{file.getPresentableUrl()};
            VcsBalloonProblemNotifier.showOverVersionControlView(vcs.getProject(), VcsBundle.message((String)"changes.notification.content.repository.location.not.found.for", (Object[])objectArray), MessageType.ERROR);
            return;
        }
        AbstractVcsHelper abstractVcsHelper = AbstractVcsHelper.getInstance((Project)vcs.getProject());
        CommittedChangesProvider committedChangesProvider = vcs.getCommittedChangesProvider();
        Intrinsics.checkNotNull((Object)committedChangesProvider);
        abstractVcsHelper.openCommittedChangesTab(committedChangesProvider, repositoryLocation, settings, maxCount, null);
    }

    private static final int askMaxCount(Project project) {
        return switch (Messages.showYesNoCancelDialog((Project)project, (String)VcsBundle.message((String)"browse.changes.no.filter.prompt", (Object[])new Object[0]), (String)VcsBundle.message((String)"browse.changes.title", (Object[])new Object[0]), (String)VcsBundle.message((String)"browse.changes.show.recent.button", (Object[])new Object[0]), (String)VcsBundle.message((String)"browse.changes.show.all.button", (Object[])new Object[0]), (String)CommonBundle.getCancelButtonText(), (Icon)Messages.getQuestionIcon())) {
            case 2 -> -1;
            case 0 -> 50;
            default -> 0;
        };
    }

    public static final /* synthetic */ void access$showCommittedChanges(AbstractVcs vcs, VirtualFile file, ChangeBrowserSettings settings) {
        BrowseCommittedChangesActionKt.showCommittedChanges(vcs, file, settings);
    }
}

