/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cwm.plugin.following;

import com.intellij.codeWithMe.ClientId;
import com.intellij.cwm.plugin.common.control.CodeWithMeColors;
import com.intellij.cwm.plugin.common.users.ConnectableUser;
import com.intellij.cwm.plugin.following.FollowMeManagerKt;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.jetbrains.codeWithMe.model.RdUserId;
import com.jetbrains.codeWithMe.model.RdUserModel;
import com.jetbrains.codeWithMe.model.RdUserProperties;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.reactive.IMutablePropertyBase;
import com.jetbrains.rd.util.reactive.IMutableViewableMap;
import com.jetbrains.rd.util.reactive.IProperty;
import com.jetbrains.rd.util.reactive.ISource;
import com.jetbrains.rd.util.reactive.IViewableMap;
import com.jetbrains.rd.util.reactive.OptProperty;
import com.jetbrains.rd.util.reactive.Property;
import com.jetbrains.rd.util.reactive.SourceExKt;
import com.jetbrains.rd.util.reactive.ViewableMap;
import com.jetbrains.rdserver.BackendUserSettings;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010$\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0010!\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010 \n\u0002\b\u0003\b&\u0018\u0000 A2\u00020\u0001:\u0001AB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010$\u001a\u00020%H$J \u0010&\u001a\u00020%2\u0006\u0010'\u001a\u00020\n2\u0006\u0010(\u001a\u00020\n2\u0006\u0010)\u001a\u00020\u000bH$J\u0010\u0010*\u001a\u00020%2\u0006\u0010\u0002\u001a\u00020\u0003H\u0004J\u001e\u0010-\u001a\u00020%2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010.\u001a\u00020\n2\u0006\u0010/\u001a\u000200J\u000e\u00101\u001a\u00020\u000b2\u0006\u0010.\u001a\u00020\nJ\u0010\u0010\u001d\u001a\u0004\u0018\u00010\u000e2\u0006\u00102\u001a\u00020\rJ\u0010\u0010\u001d\u001a\u00020\u000e2\u0006\u0010.\u001a\u00020\nH\u0007J\u0016\u00103\u001a\u00020%2\u0006\u0010(\u001a\u00020\n2\u0006\u00104\u001a\u00020\nJ\u000e\u00105\u001a\u00020%2\u0006\u0010(\u001a\u00020\nJ\u000e\u00106\u001a\u0002072\u0006\u00104\u001a\u00020\nJ\u000e\u00108\u001a\u0002072\u0006\u0010(\u001a\u00020\nJ\u0016\u00109\u001a\u0002072\u0006\u0010(\u001a\u00020\n2\u0006\u00104\u001a\u00020\nJ\u0016\u0010:\u001a\u0002072\u0006\u0010;\u001a\u00020\n2\u0006\u0010<\u001a\u00020\nJ\u000e\u0010=\u001a\u0002072\u0006\u0010>\u001a\u00020\nJ\u0014\u0010#\u001a\b\u0012\u0004\u0012\u00020\n0?2\u0006\u00104\u001a\u00020\nJ\u0014\u0010@\u001a\b\u0012\u0004\u0012\u00020\n0?2\u0006\u00104\u001a\u00020\nR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u00110\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001d\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\u00138F\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u001d\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u00110\u00138F\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0015R\u001d\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u00110\u00198F\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001bR\u001d\u0010\u001c\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e0\u00138F\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u0015R\u0017\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00070\u001f\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!R\u001d\u0010\"\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\n0\u00138F\u00a2\u0006\u0006\u001a\u0004\b#\u0010\u0015R\u0014\u0010+\u001a\b\u0012\u0004\u0012\u00020\u00070,X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006B"}, d2={"Lcom/intellij/cwm/plugin/following/FollowMeManager;", "", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "<init>", "(Lcom/jetbrains/rd/util/lifetime/Lifetime;)V", "nextId", "", "myUsers", "Lcom/jetbrains/rd/util/reactive/ViewableMap;", "Lcom/intellij/codeWithMe/ClientId;", "Lcom/jetbrains/codeWithMe/model/RdUserModel;", "myUserProperties", "Lcom/jetbrains/codeWithMe/model/RdUserId;", "Lcom/jetbrains/codeWithMe/model/RdUserProperties;", "myFollowers", "myConnectableUsers", "Lcom/intellij/cwm/plugin/common/users/ConnectableUser;", "users", "Lcom/jetbrains/rd/util/reactive/IViewableMap;", "getUsers", "()Lcom/jetbrains/rd/util/reactive/IViewableMap;", "connectableUsers", "getConnectableUsers", "connectedUsers", "", "getConnectedUsers", "()Ljava/util/Map;", "userProperties", "getUserProperties", "telephonyUsersCounter", "Lcom/jetbrains/rd/util/reactive/OptProperty;", "getTelephonyUsersCounter", "()Lcom/jetbrains/rd/util/reactive/OptProperty;", "followers", "getFollowers", "assertIsDispatchThread", "", "onFollowingRetargeted", "transitiveFollowId", "who", "whomUser", "initializeHostUser", "occupiedColorBuckets", "", "registerUser", "clientId", "userName", "", "getUser", "rdUserId", "registerFollower", "whom", "unregisterFollower", "isHostFollowingClient", "", "isClientFollowingHost", "isFollowing", "isFullSyncBetween", "user1", "user2", "isFullSyncBetweenHostAndClient", "client", "", "getFollowersWithoutHost", "Companion", "intellij.cwm.plugin"})
@SourceDebugExtension(value={"SMAP\nFollowMeManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FollowMeManager.kt\ncom/intellij/cwm/plugin/following/FollowMeManager\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 6 Logger.kt\ncom/jetbrains/rd/platform/util/LoggerKt\n*L\n1#1,253:1\n540#2:254\n525#2,6:255\n60#3,5:261\n60#3,5:277\n13#3:283\n1#4:266\n777#5:267\n873#5,2:268\n1586#5:270\n1661#5,3:271\n777#5:274\n873#5,2:275\n13#6:282\n*S KotlinDebug\n*F\n+ 1 FollowMeManager.kt\ncom/intellij/cwm/plugin/following/FollowMeManager\n*L\n88#1:254\n88#1:255,6\n146#1:261,5\n154#1:277,5\n68#1:283\n246#1:267\n246#1:268,2\n246#1:270\n246#1:271,3\n250#1:274\n250#1:275,2\n68#1:282\n*E\n"})
public abstract class FollowMeManager {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Lifetime lifetime;
    private int nextId;
    @NotNull
    private final ViewableMap<ClientId, RdUserModel> myUsers;
    @NotNull
    private final ViewableMap<RdUserId, RdUserProperties> myUserProperties;
    @NotNull
    private final ViewableMap<ClientId, ClientId> myFollowers;
    @NotNull
    private final ViewableMap<ClientId, ConnectableUser> myConnectableUsers;
    @NotNull
    private final OptProperty<Integer> telephonyUsersCounter;
    @NotNull
    private final List<Integer> occupiedColorBuckets;
    @NotNull
    private static final Logger LOG;

    public FollowMeManager(@NotNull Lifetime lifetime) {
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        this.lifetime = lifetime;
        this.myUsers = new ViewableMap(null, 1, null);
        this.myUserProperties = new ViewableMap(null, 1, null);
        this.myFollowers = new ViewableMap(null, 1, null);
        this.myConnectableUsers = new ViewableMap(null, 1, null);
        this.telephonyUsersCounter = new OptProperty((Object)0);
        FollowMeManagerKt.flowInto((ISource)this.myUsers, this.lifetime, (IMutableViewableMap)this.myConnectableUsers, FollowMeManager::_init_$lambda$0);
        this.occupiedColorBuckets = new ArrayList();
    }

    @NotNull
    public final IViewableMap<ClientId, RdUserModel> getUsers() {
        return (IViewableMap)this.myUsers;
    }

    @NotNull
    public final IViewableMap<ClientId, ConnectableUser> getConnectableUsers() {
        return (IViewableMap)this.myConnectableUsers;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Map<ClientId, ConnectableUser> getConnectedUsers() {
        void $this$filterTo$iv$iv;
        Map $this$filter$iv = MapsKt.toMap((Map)((Map)this.myConnectableUsers));
        boolean $i$f$filter = false;
        Map map2 = $this$filter$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$filterTo = false;
        Iterator iterator = $this$filterTo$iv$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry element$iv$iv;
            Map.Entry entry = element$iv$iv = iterator.next();
            boolean bl = false;
            if (!((Boolean)((ConnectableUser)entry.getValue()).getConnected().getValue()).booleanValue()) continue;
            destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
        }
        return destination$iv$iv;
    }

    @NotNull
    public final IViewableMap<RdUserId, RdUserProperties> getUserProperties() {
        return (IViewableMap)this.myUserProperties;
    }

    @NotNull
    public final OptProperty<Integer> getTelephonyUsersCounter() {
        return this.telephonyUsersCounter;
    }

    @NotNull
    public final IViewableMap<ClientId, ClientId> getFollowers() {
        return (IViewableMap)this.myFollowers;
    }

    protected abstract void assertIsDispatchThread();

    protected abstract void onFollowingRetargeted(@NotNull ClientId var1, @NotNull ClientId var2, @NotNull RdUserModel var3);

    protected final void initializeHostUser(@NotNull Lifetime lifetime) {
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        this.registerUser(lifetime, ClientId.Companion.getLocalId(), BackendUserSettings.INSTANCE.getHostUserName());
    }

    public final void registerUser(@NotNull Lifetime lifetime, @NotNull ClientId clientId, @NotNull String userName) {
        RdUserProperties rdUserProperties;
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        Intrinsics.checkNotNullParameter((Object)clientId, (String)"clientId");
        Intrinsics.checkNotNullParameter((Object)userName, (String)"userName");
        this.assertIsDispatchThread();
        boolean bl2 = bl = !this.getUsers().containsKey((Object)clientId);
        if (_Assertions.ENABLED && !bl) {
            boolean $i$a$-assert-FollowMeManager$registerUser$22 = false;
            String $i$a$-assert-FollowMeManager$registerUser$22 = "User is already registered in FollowingMeManager. User client id: " + clientId;
            throw new AssertionError((Object)$i$a$-assert-FollowMeManager$registerUser$22);
        }
        int newBucket = CodeWithMeColors.INSTANCE.calculateColorBucketForUser(userName, this.occupiedColorBuckets);
        this.occupiedColorBuckets.add(newBucket);
        RdUserId rdUserId = new RdUserId(clientId.getValue());
        Map map2 = (Map)this.myUserProperties;
        RdUserProperties property = rdUserProperties = new RdUserProperties();
        boolean bl3 = false;
        this.getConnectableUsers().view(lifetime, (arg_0, arg_1) -> FollowMeManager.registerUser$lambda$1$0(rdUserId, property, arg_0, arg_1));
        map2.put(rdUserId, rdUserProperties);
        RdUserModel userModel = new RdUserModel(rdUserId, userName, newBucket);
        ((Map)this.myUsers).put(clientId, userModel);
        Logger $this$debug_u24default$iv = LOG;
        Throwable t$iv = null;
        boolean $i$f$debug = false;
        if ($this$debug_u24default$iv.isDebugEnabled()) {
            Logger logger = $this$debug_u24default$iv;
            boolean bl4 = false;
            logger.debug("Register new user (name: '" + userName + "', client id: " + clientId.getValue() + ")", t$iv);
        }
        lifetime.onTermination(() -> FollowMeManager.registerUser$lambda$3(this, clientId, newBucket, rdUserId, userName));
    }

    @NotNull
    public final RdUserModel getUser(@NotNull ClientId clientId) {
        Intrinsics.checkNotNullParameter((Object)clientId, (String)"clientId");
        this.assertIsDispatchThread();
        RdUserModel rdUserModel = (RdUserModel)this.getUsers().get((Object)clientId);
        if (rdUserModel == null) {
            throw new IllegalStateException(("Can not find user for ClientId=" + clientId).toString());
        }
        return rdUserModel;
    }

    @Nullable
    public final RdUserProperties getUserProperties(@NotNull RdUserId rdUserId) {
        Intrinsics.checkNotNullParameter((Object)rdUserId, (String)"rdUserId");
        this.assertIsDispatchThread();
        return (RdUserProperties)this.getUserProperties().get((Object)rdUserId);
    }

    @Deprecated(message="Do not use. To be removed after ClientId -> RdUserId")
    @NotNull
    public final RdUserProperties getUserProperties(@NotNull ClientId clientId) {
        Intrinsics.checkNotNullParameter((Object)clientId, (String)"clientId");
        this.assertIsDispatchThread();
        RdUserProperties rdUserProperties = (RdUserProperties)this.getUserProperties().get((Object)new RdUserId(clientId.getValue()));
        if (rdUserProperties == null) {
            throw new IllegalStateException(("Can not find user for ClientId=" + clientId).toString());
        }
        return rdUserProperties;
    }

    public final void registerFollower(@NotNull ClientId who, @NotNull ClientId whom) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)who, (String)"who");
        Intrinsics.checkNotNullParameter((Object)whom, (String)"whom");
        this.assertIsDispatchThread();
        boolean bl2 = bl = !Intrinsics.areEqual((Object)who, (Object)whom);
        if (_Assertions.ENABLED && !bl) {
            boolean $i$a$-assert-FollowMeManager$registerFollower$22 = false;
            String $i$a$-assert-FollowMeManager$registerFollower$22 = "Can not follower yourself, ClientId=" + who;
            throw new AssertionError((Object)$i$a$-assert-FollowMeManager$registerFollower$22);
        }
        RdUserModel whoUser = this.getUser(who);
        RdUserModel whomUser = this.getUser(whom);
        LOG.info("User '" + whoUser.getName() + "' with ClientId=" + who + " follows user '" + whomUser.getName() + "' ith ClientId=" + whom);
        ClientId transitiveFollowId = (ClientId)this.getFollowers().get((Object)whom);
        ((Map)this.myFollowers).put(who, whom);
        if (transitiveFollowId != null && !Intrinsics.areEqual((Object)transitiveFollowId, (Object)who)) {
            ((Map)this.myFollowers).put(who, transitiveFollowId);
            this.onFollowingRetargeted(transitiveFollowId, who, whomUser);
        }
    }

    public final void unregisterFollower(@NotNull ClientId who) {
        Intrinsics.checkNotNullParameter((Object)who, (String)"who");
        this.assertIsDispatchThread();
        RdUserModel whoUser = this.getUser(who);
        LOG.info("User '" + whoUser.getName() + "' with ClientId=" + who + " stops following");
        this.myFollowers.remove((Object)who);
    }

    public final boolean isHostFollowingClient(@NotNull ClientId whom) {
        Intrinsics.checkNotNullParameter((Object)whom, (String)"whom");
        return this.isFollowing(ClientId.Companion.getLocalId(), whom);
    }

    public final boolean isClientFollowingHost(@NotNull ClientId who) {
        Intrinsics.checkNotNullParameter((Object)who, (String)"who");
        return this.isFollowing(who, ClientId.Companion.getLocalId());
    }

    public final boolean isFollowing(@NotNull ClientId who, @NotNull ClientId whom) {
        Intrinsics.checkNotNullParameter((Object)who, (String)"who");
        Intrinsics.checkNotNullParameter((Object)whom, (String)"whom");
        return Intrinsics.areEqual((Object)this.getFollowers().get((Object)who), (Object)whom);
    }

    public final boolean isFullSyncBetween(@NotNull ClientId user1, @NotNull ClientId user2) {
        Intrinsics.checkNotNullParameter((Object)user1, (String)"user1");
        Intrinsics.checkNotNullParameter((Object)user2, (String)"user2");
        return this.isFollowing(user1, user2) && this.isFollowing(user2, user1);
    }

    public final boolean isFullSyncBetweenHostAndClient(@NotNull ClientId client) {
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        return this.isFollowing(ClientId.Companion.getLocalId(), client) && this.isFollowing(client, ClientId.Companion.getLocalId());
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<ClientId> getFollowers(@NotNull ClientId whom) {
        void $this$mapTo$iv$iv;
        Map.Entry it;
        Iterable $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)whom, (String)"whom");
        Iterable $this$filter$iv = this.getFollowers().entrySet();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (Map.Entry)element$iv$iv;
            boolean bl = false;
            if (!Intrinsics.areEqual(it.getValue(), (Object)whom)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (Map.Entry)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add((ClientId)it.getKey());
        }
        return CollectionsKt.toList((Iterable)((List)destination$iv$iv));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<ClientId> getFollowersWithoutHost(@NotNull ClientId whom) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)whom, (String)"whom");
        Iterable $this$filter$iv = this.getFollowers(whom);
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            ClientId it = (ClientId)element$iv$iv;
            boolean bl = false;
            if (!(!Intrinsics.areEqual((Object)it, (Object)ClientId.Companion.getLocalId()))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return CollectionsKt.toList((Iterable)((List)destination$iv$iv));
    }

    private static final ConnectableUser _init_$lambda$0(RdUserModel user) {
        Intrinsics.checkNotNullParameter((Object)user, (String)"user");
        return new ConnectableUser(user, (IProperty)new Property((Object)true));
    }

    private static final Unit registerUser$lambda$1$0(RdUserId $rdUserId, RdUserProperties $property, Lifetime connectableUserLifetime, Map.Entry event) {
        Intrinsics.checkNotNullParameter((Object)connectableUserLifetime, (String)"connectableUserLifetime");
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (!Intrinsics.areEqual((Object)((ClientId)event.getKey()).getValue(), (Object)$rdUserId.getClientIdValue())) {
            return Unit.INSTANCE;
        }
        SourceExKt.flowInto((ISource)((ISource)((ConnectableUser)event.getValue()).getConnected()), (Lifetime)connectableUserLifetime, (IMutablePropertyBase)((IMutablePropertyBase)$property.getConnected()));
        return Unit.INSTANCE;
    }

    private static final Unit registerUser$lambda$3(FollowMeManager this$0, ClientId $clientId, int $newBucket, RdUserId $rdUserId, String $userName) {
        this$0.assertIsDispatchThread();
        boolean bl = this$0.getUsers().containsKey((Object)$clientId);
        if (_Assertions.ENABLED && !bl) {
            boolean $i$a$-assert-FollowMeManager$registerUser$4$22 = false;
            String $i$a$-assert-FollowMeManager$registerUser$4$22 = "Can not find user in FollowMeManager with client id: " + $clientId.getValue();
            throw new AssertionError((Object)$i$a$-assert-FollowMeManager$registerUser$4$22);
        }
        Logger $this$debug_u24default$iv = LOG;
        Throwable t$iv = null;
        boolean $i$f$debug = false;
        if ($this$debug_u24default$iv.isDebugEnabled()) {
            Logger logger = $this$debug_u24default$iv;
            boolean bl2 = false;
            logger.debug("Unregister user (name: '" + $userName + "', clientId: " + $clientId.getValue() + ")", t$iv);
        }
        this$0.occupiedColorBuckets.remove((Object)$newBucket);
        this$0.myUsers.remove((Object)$clientId);
        this$0.myUserProperties.remove((Object)$rdUserId);
        this$0.myFollowers.remove((Object)$clientId);
        for (Pair pair : MapsKt.toList((Map)((Map)this$0.getFollowers()))) {
            ClientId who = (ClientId)pair.component1();
            ClientId whom = (ClientId)pair.component2();
            if (!Intrinsics.areEqual((Object)whom, (Object)$clientId)) continue;
            this$0.myFollowers.remove((Object)who);
        }
        return Unit.INSTANCE;
    }

    static {
        boolean $i$f$getLogger = false;
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(FollowMeManager.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/intellij/cwm/plugin/following/FollowMeManager$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "getInstance", "Lcom/intellij/cwm/plugin/following/FollowMeManager;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.cwm.plugin"})
    @SourceDebugExtension(value={"SMAP\nFollowMeManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FollowMeManager.kt\ncom/intellij/cwm/plugin/following/FollowMeManager$Companion\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,253:1\n30#2,2:254\n*S KotlinDebug\n*F\n+ 1 FollowMeManager.kt\ncom/intellij/cwm/plugin/following/FollowMeManager$Companion\n*L\n69#1:254,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final FollowMeManager getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            ComponentManager $this$service$iv = (ComponentManager)project;
            boolean $i$f$service = false;
            Class<FollowMeManager> serviceClass$iv = FollowMeManager.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            return (FollowMeManager)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

