/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.diagnostic.telemetry.impl;

import com.intellij.diagnostic.ActivityImpl;
import com.intellij.platform.diagnostic.telemetry.exporters.AnyValue;
import com.intellij.platform.diagnostic.telemetry.exporters.KeyValue;
import com.intellij.platform.diagnostic.telemetry.impl.OtlpService;
import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.sdk.resources.Resource;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u0000.\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\u001a\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0007\u001a\u0010\u0010\u0006\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0007\u001a\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002\u001a\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0004\u001a\u00020\u0005H\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"chunkSize", "", "computeTraceId", "", "span", "Lcom/intellij/diagnostic/ActivityImpl;", "computeSpanId", "createOpenTelemetryResource", "Lcom/intellij/platform/diagnostic/telemetry/exporters/Resource;", "opentelemetrySdkResource", "Lio/opentelemetry/sdk/resources/Resource;", "hashCodeRegex", "Lkotlin/text/Regex;", "normalizeSpanName", "", "intellij.platform.diagnostic.telemetry.impl"})
public final class OtlpServiceKt {
    private static final int chunkSize = 512;
    @NotNull
    private static final Regex hashCodeRegex = new Regex("@\\d+ ");

    @ApiStatus.Internal
    @NotNull
    public static final byte[] computeTraceId(@NotNull ActivityImpl span2) {
        Intrinsics.checkNotNullParameter((Object)span2, (String)"span");
        OtlpService otlpService = OtlpService.Companion.getInstance();
        long traceIdSalt = otlpService.traceIdSalt;
        int utc = otlpService.utc;
        ActivityImpl rootSpan = span2;
        while (rootSpan.getParent() != null) {
            ActivityImpl parentSpan;
            rootSpan = parentSpan;
        }
        ByteBuffer byteBuffer = ByteBuffer.allocate(16);
        byteBuffer.putInt(utc);
        byteBuffer.putInt(System.identityHashCode(rootSpan));
        byteBuffer.putLong(traceIdSalt);
        byte[] byArray = byteBuffer.array();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"array(...)");
        return byArray;
    }

    @ApiStatus.Internal
    @NotNull
    public static final byte[] computeSpanId(@NotNull ActivityImpl span2) {
        Intrinsics.checkNotNullParameter((Object)span2, (String)"span");
        ByteBuffer byteBuffer = ByteBuffer.allocate(8);
        byteBuffer.putInt((int)(span2.getStart() / (long)1000000));
        byteBuffer.putInt(System.identityHashCode(span2));
        byte[] byArray = byteBuffer.array();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"array(...)");
        return byArray;
    }

    private static final com.intellij.platform.diagnostic.telemetry.exporters.Resource createOpenTelemetryResource(Resource opentelemetrySdkResource) {
        List attributes = new ArrayList();
        opentelemetrySdkResource.getAttributes().forEach((arg_0, arg_1) -> OtlpServiceKt.createOpenTelemetryResource$lambda$0(attributes, arg_0, arg_1));
        List list = List.copyOf(attributes);
        Intrinsics.checkNotNullExpressionValue(list, (String)"copyOf(...)");
        return new com.intellij.platform.diagnostic.telemetry.exporters.Resource(list, 0, 2, null);
    }

    private static final String normalizeSpanName(ActivityImpl span2) {
        String string = span2.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        CharSequence charSequence = string;
        Regex regex = hashCodeRegex;
        String string2 = " ";
        return regex.replace(charSequence, string2);
    }

    private static final void createOpenTelemetryResource$lambda$0(List $attributes, AttributeKey k, Object v) {
        String string = k.getKey();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getKey(...)");
        $attributes.add(new KeyValue(string, new AnyValue(v.toString())));
    }

    public static final /* synthetic */ com.intellij.platform.diagnostic.telemetry.exporters.Resource access$createOpenTelemetryResource(Resource opentelemetrySdkResource) {
        return OtlpServiceKt.createOpenTelemetryResource(opentelemetrySdkResource);
    }

    public static final /* synthetic */ String access$normalizeSpanName(ActivityImpl span2) {
        return OtlpServiceKt.normalizeSpanName(span2);
    }
}

