/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.workspaceModel.core.fileIndex.impl;

import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.pointers.VirtualFilePointer;
import com.intellij.platform.backend.workspace.VirtualFileUrls;
import com.intellij.platform.workspace.storage.EntityPointer;
import com.intellij.platform.workspace.storage.WorkspaceEntity;
import com.intellij.platform.workspace.storage.url.VirtualFileUrl;
import com.intellij.workspaceModel.core.fileIndex.EntityStorageKind;
import com.intellij.workspaceModel.core.fileIndex.WorkspaceFileKind;
import com.intellij.workspaceModel.core.fileIndex.WorkspaceFileSet;
import com.intellij.workspaceModel.core.fileIndex.WorkspaceFileSetData;
import com.intellij.workspaceModel.core.fileIndex.WorkspaceFileSetRegistrar;
import com.intellij.workspaceModel.core.fileIndex.impl.DummyWorkspaceFileSetData;
import com.intellij.workspaceModel.core.fileIndex.impl.ExcludedFileSet;
import com.intellij.workspaceModel.core.fileIndex.impl.JvmPackageRootDataInternal;
import com.intellij.workspaceModel.core.fileIndex.impl.NonExistingFileSetKind;
import com.intellij.workspaceModel.core.fileIndex.impl.NonExistingWorkspaceRootsRegistry;
import com.intellij.workspaceModel.core.fileIndex.impl.StoredFileSetCollection;
import com.intellij.workspaceModel.core.fileIndex.impl.WorkspaceFileIndexDataImplKt;
import com.intellij.workspaceModel.core.fileIndex.impl.WorkspaceFileSetImpl;
import com.intellij.workspaceModel.core.fileIndex.impl.WorkspaceFileSetsKt;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0088\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001Bw\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007\u0012J\u0010\n\u001aF\u0012\u0004\u0012\u00020\f\u00128\u00126\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000f0\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00110\u00100\rj\u001a\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000f0\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00110\u0010`\u00120\u000bj\u0002`\u0013\u00a2\u0006\u0004\b\u0014\u0010\u0015J*\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\u000f2\b\u0010\"\u001a\u0004\u0018\u00010#H\u0016J2\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\u000f2\b\u0010\"\u001a\u0004\u0018\u00010#2\u0006\u0010$\u001a\u00020%H\u0002J*\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\b2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\u000f2\b\u0010\"\u001a\u0004\u0018\u00010#H\u0016J2\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\b2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\u000f2\b\u0010\"\u001a\u0004\u0018\u00010#2\u0006\u0010$\u001a\u00020%H\u0002J*\u0010&\u001a\u00020\u001c2\u0006\u0010'\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\u000f2\b\u0010\"\u001a\u0004\u0018\u00010#H\u0016J\u0018\u0010(\u001a\u00020\u001c2\u0006\u0010)\u001a\u00020\u001e2\u0006\u0010!\u001a\u00020\u000fH\u0016J \u0010(\u001a\u00020\u001c2\u0006\u0010)\u001a\u00020\u001e2\u0006\u0010*\u001a\u00020 2\u0006\u0010!\u001a\u00020\u000fH\u0016J&\u0010+\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\f\u0010,\u001a\b\u0012\u0004\u0012\u00020\f0-2\u0006\u0010!\u001a\u00020\u000fH\u0016J,\u0010.\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\u0012\u0010/\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020%002\u0006\u0010!\u001a\u00020\u000fH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000RR\u0010\n\u001aF\u0012\u0004\u0012\u00020\f\u00128\u00126\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000f0\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00110\u00100\rj\u001a\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000f0\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00110\u0010`\u00120\u000bj\u0002`\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R#\u0010\u0016\u001a\u0014\u0012\u0004\u0012\u00020\b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00180\u00170\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001a\u00a8\u00061"}, d2={"Lcom/intellij/workspaceModel/core/fileIndex/impl/StoreFileSetsRegistrarImpl;", "Lcom/intellij/workspaceModel/core/fileIndex/WorkspaceFileSetRegistrar;", "storageKind", "Lcom/intellij/workspaceModel/core/fileIndex/EntityStorageKind;", "nonExistingFilesRegistry", "Lcom/intellij/workspaceModel/core/fileIndex/impl/NonExistingWorkspaceRootsRegistry;", "fileSets", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "Lcom/intellij/workspaceModel/core/fileIndex/impl/StoredFileSetCollection;", "fileSetsByPackagePrefix", "Ljava/util/HashMap;", "", "Ljava/util/LinkedHashMap;", "Lcom/intellij/platform/workspace/storage/EntityPointer;", "Lcom/intellij/platform/workspace/storage/WorkspaceEntity;", "", "Lcom/intellij/workspaceModel/core/fileIndex/impl/WorkspaceFileSetImpl;", "Lkotlin/collections/LinkedHashMap;", "Lcom/intellij/workspaceModel/core/fileIndex/impl/PackagePrefixStorage;", "<init>", "(Lcom/intellij/workspaceModel/core/fileIndex/EntityStorageKind;Lcom/intellij/workspaceModel/core/fileIndex/impl/NonExistingWorkspaceRootsRegistry;Ljava/util/Map;Ljava/util/HashMap;)V", "registeredFileSets", "", "Lcom/intellij/workspaceModel/core/fileIndex/WorkspaceFileSet;", "getRegisteredFileSets", "()Ljava/util/Map;", "registerFileSet", "", "root", "Lcom/intellij/platform/workspace/storage/url/VirtualFileUrl;", "kind", "Lcom/intellij/workspaceModel/core/fileIndex/WorkspaceFileKind;", "entity", "customData", "Lcom/intellij/workspaceModel/core/fileIndex/WorkspaceFileSetData;", "recursive", "", "registerNonRecursiveFileSet", "file", "registerExcludedRoot", "excludedRoot", "excludedFrom", "registerExclusionPatterns", "patterns", "", "registerExclusionCondition", "condition", "Lkotlin/Function1;", "intellij.platform.projectModel.impl"})
final class StoreFileSetsRegistrarImpl
implements WorkspaceFileSetRegistrar {
    @NotNull
    private final EntityStorageKind storageKind;
    @NotNull
    private final NonExistingWorkspaceRootsRegistry nonExistingFilesRegistry;
    @NotNull
    private final Map<VirtualFile, StoredFileSetCollection> fileSets;
    @NotNull
    private final HashMap<String, LinkedHashMap<EntityPointer<WorkspaceEntity>, List<WorkspaceFileSetImpl>>> fileSetsByPackagePrefix;
    @NotNull
    private final Map<VirtualFile, Set<WorkspaceFileSet>> registeredFileSets;

    public StoreFileSetsRegistrarImpl(@NotNull EntityStorageKind storageKind, @NotNull NonExistingWorkspaceRootsRegistry nonExistingFilesRegistry, @NotNull Map<VirtualFile, StoredFileSetCollection> fileSets, @NotNull HashMap<String, LinkedHashMap<EntityPointer<WorkspaceEntity>, List<WorkspaceFileSetImpl>>> fileSetsByPackagePrefix) {
        Intrinsics.checkNotNullParameter((Object)((Object)storageKind), (String)"storageKind");
        Intrinsics.checkNotNullParameter((Object)nonExistingFilesRegistry, (String)"nonExistingFilesRegistry");
        Intrinsics.checkNotNullParameter(fileSets, (String)"fileSets");
        Intrinsics.checkNotNullParameter(fileSetsByPackagePrefix, (String)"fileSetsByPackagePrefix");
        this.storageKind = storageKind;
        this.nonExistingFilesRegistry = nonExistingFilesRegistry;
        this.fileSets = fileSets;
        this.fileSetsByPackagePrefix = fileSetsByPackagePrefix;
        this.registeredFileSets = new LinkedHashMap();
    }

    @NotNull
    public final Map<VirtualFile, Set<WorkspaceFileSet>> getRegisteredFileSets() {
        return this.registeredFileSets;
    }

    @Override
    public void registerFileSet(@NotNull VirtualFileUrl root, @NotNull WorkspaceFileKind kind, @NotNull WorkspaceEntity entity, @Nullable WorkspaceFileSetData customData) {
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        Intrinsics.checkNotNullParameter((Object)((Object)kind), (String)"kind");
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        this.registerFileSet(root, kind, entity, customData, true);
    }

    private final void registerFileSet(VirtualFileUrl root, WorkspaceFileKind kind, WorkspaceEntity entity, WorkspaceFileSetData customData, boolean recursive) {
        VirtualFile rootFile;
        VirtualFile virtualFile = rootFile = root instanceof VirtualFilePointer ? ((VirtualFilePointer)root).getFile() : VirtualFileManager.getInstance().findFileByUrl(root.getUrl());
        if (rootFile != null) {
            this.registerFileSet(rootFile, kind, entity, customData, recursive);
        } else {
            this.nonExistingFilesRegistry.registerUrl(root, entity, this.storageKind, kind.isContent() ? NonExistingFileSetKind.INCLUDED_CONTENT : NonExistingFileSetKind.INCLUDED_OTHER);
        }
    }

    @Override
    public void registerFileSet(@NotNull VirtualFile root, @NotNull WorkspaceFileKind kind, @NotNull WorkspaceEntity entity, @Nullable WorkspaceFileSetData customData) {
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        Intrinsics.checkNotNullParameter((Object)((Object)kind), (String)"kind");
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        this.registerFileSet(root, kind, entity, customData, true);
    }

    private final void registerFileSet(VirtualFile root, WorkspaceFileKind kind, WorkspaceEntity entity, WorkspaceFileSetData customData, boolean recursive) {
        EntityPointer entityPointer = entity.createPointer();
        WorkspaceFileSetData workspaceFileSetData = customData;
        if (workspaceFileSetData == null) {
            workspaceFileSetData = DummyWorkspaceFileSetData.INSTANCE;
        }
        WorkspaceFileSetImpl fileSet = new WorkspaceFileSetImpl(root, kind, (EntityPointer<? extends WorkspaceEntity>)entityPointer, this.storageKind, workspaceFileSetData, recursive);
        WorkspaceFileSetsKt.putValue(this.fileSets, root, fileSet);
        Object[] objectArray = new WorkspaceFileSet[]{fileSet};
        this.registeredFileSets.merge(root, SetsKt.mutableSetOf((Object[])objectArray), (arg_0, arg_1) -> StoreFileSetsRegistrarImpl.registerFileSet$lambda$1(StoreFileSetsRegistrarImpl::registerFileSet$lambda$0, arg_0, arg_1));
        if (customData instanceof JvmPackageRootDataInternal) {
            WorkspaceFileSetsKt.addFileSet(this.fileSetsByPackagePrefix, ((JvmPackageRootDataInternal)customData).getPackagePrefix(), fileSet);
        }
    }

    @Override
    public void registerNonRecursiveFileSet(@NotNull VirtualFileUrl file, @NotNull WorkspaceFileKind kind, @NotNull WorkspaceEntity entity, @Nullable WorkspaceFileSetData customData) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)((Object)kind), (String)"kind");
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        this.registerFileSet(file, kind, entity, customData, false);
    }

    @Override
    public void registerExcludedRoot(@NotNull VirtualFileUrl excludedRoot, @NotNull WorkspaceEntity entity) {
        Intrinsics.checkNotNullParameter((Object)excludedRoot, (String)"excludedRoot");
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        VirtualFile excludedRootFile = VirtualFileUrls.getVirtualFile((VirtualFileUrl)excludedRoot);
        if (excludedRootFile == null) {
            this.nonExistingFilesRegistry.registerUrl(excludedRoot, entity, this.storageKind, NonExistingFileSetKind.EXCLUDED_FROM_CONTENT);
        } else {
            WorkspaceFileSetsKt.putValue(this.fileSets, excludedRootFile, new ExcludedFileSet.ByFileKind(31, (EntityPointer<? extends WorkspaceEntity>)entity.createPointer(), this.storageKind));
        }
    }

    @Override
    public void registerExcludedRoot(@NotNull VirtualFileUrl excludedRoot, @NotNull WorkspaceFileKind excludedFrom, @NotNull WorkspaceEntity entity) {
        Intrinsics.checkNotNullParameter((Object)excludedRoot, (String)"excludedRoot");
        Intrinsics.checkNotNullParameter((Object)((Object)excludedFrom), (String)"excludedFrom");
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        VirtualFile file = VirtualFileUrls.getVirtualFile((VirtualFileUrl)excludedRoot);
        if (file == null) {
            this.nonExistingFilesRegistry.registerUrl(excludedRoot, entity, this.storageKind, excludedFrom.isContent() ? NonExistingFileSetKind.EXCLUDED_FROM_CONTENT : NonExistingFileSetKind.EXCLUDED_OTHER);
        } else {
            int mask = switch (WhenMappings.$EnumSwitchMapping$0[excludedFrom.ordinal()]) {
                case 1 -> 6;
                case 2 -> 17;
                default -> WorkspaceFileIndexDataImplKt.toMask(excludedFrom);
            };
            WorkspaceFileSetsKt.putValue(this.fileSets, file, new ExcludedFileSet.ByFileKind(mask, (EntityPointer<? extends WorkspaceEntity>)entity.createPointer(), this.storageKind));
        }
    }

    @Override
    public void registerExclusionPatterns(@NotNull VirtualFileUrl root, @NotNull List<String> patterns, @NotNull WorkspaceEntity entity) {
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        Intrinsics.checkNotNullParameter(patterns, (String)"patterns");
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        VirtualFile rootFile = VirtualFileUrls.getVirtualFile((VirtualFileUrl)root);
        if (!patterns.isEmpty()) {
            if (rootFile == null) {
                this.nonExistingFilesRegistry.registerUrl(root, entity, this.storageKind, NonExistingFileSetKind.EXCLUDED_OTHER);
            } else {
                WorkspaceFileSetsKt.putValue(this.fileSets, rootFile, new ExcludedFileSet.ByPattern(rootFile, patterns, (EntityPointer<? extends WorkspaceEntity>)entity.createPointer(), this.storageKind));
            }
        }
    }

    @Override
    public void registerExclusionCondition(@NotNull VirtualFileUrl root, @NotNull Function1<? super VirtualFile, Boolean> condition, @NotNull WorkspaceEntity entity) {
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        Intrinsics.checkNotNullParameter(condition, (String)"condition");
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        VirtualFile rootFile = VirtualFileUrls.getVirtualFile((VirtualFileUrl)root);
        if (rootFile == null) {
            this.nonExistingFilesRegistry.registerUrl(root, entity, this.storageKind, NonExistingFileSetKind.EXCLUDED_OTHER);
        } else {
            WorkspaceFileSetsKt.putValue(this.fileSets, rootFile, new ExcludedFileSet.ByCondition(rootFile, condition, (EntityPointer<? extends WorkspaceEntity>)entity.createPointer(), this.storageKind));
        }
    }

    private static final Set registerFileSet$lambda$0(Set old, Set set) {
        Intrinsics.checkNotNullParameter((Object)old, (String)"old");
        Intrinsics.checkNotNullParameter((Object)set, (String)"new");
        old.addAll(set);
        return old;
    }

    private static final Set registerFileSet$lambda$1(Function2 $tmp0, Object p0, Object p1) {
        return (Set)$tmp0.invoke(p0, p1);
    }

    @Metadata(mv={2, 3, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[WorkspaceFileKind.values().length];
            try {
                nArray[WorkspaceFileKind.EXTERNAL.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[WorkspaceFileKind.CONTENT.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

