/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.qodana.report;

import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.RoamingType;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.project.Project;
import com.intellij.util.xmlb.annotations.Attribute;
import com.intellij.util.xmlb.annotations.Tag;
import com.intellij.util.xmlb.annotations.XCollection;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.qodana.report.FileReportDescriptor;
import org.jetbrains.qodana.report.LocalReportDescriptor;
import org.jetbrains.qodana.run.LocalRunNotPublishedReportDescriptor;
import org.jetbrains.qodana.run.LocalRunPublishedReportDescriptor;

@com.intellij.openapi.components.State(name="QodanaReportsService", storages={@Storage(value="$WORKSPACE_FILE$", roamingType=RoamingType.DISABLED)})
@Service(value={Service.Level.PROJECT})
@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0007\u0018\u0000 \u00192\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0003\u0019\u001a\u001bB\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0006\u0010\n\u001a\u00020\u000bJ\u000e\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\tJ\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\t0\u000fJ\b\u0010\u0010\u001a\u00020\u0002H\u0016J\u0010\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\u0002H\u0016J\u0012\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0015\u001a\u00020\tH\u0002J\u0010\u0010\u0016\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0017H\u0002J\u0012\u0010\u0018\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0012\u001a\u00020\u0014H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lorg/jetbrains/qodana/report/QodanaLocalReportsService;", "Lcom/intellij/openapi/components/PersistentStateComponent;", "Lorg/jetbrains/qodana/report/QodanaLocalReportsService$State;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "reports", "", "Lorg/jetbrains/qodana/report/LocalReportDescriptor;", "clear", "", "addReport", "reportDescriptor", "getReports", "", "getState", "loadState", "state", "reportStateFromDescriptor", "Lorg/jetbrains/qodana/report/QodanaLocalReportsService$ReportDescriptorState;", "descriptor", "reportStateFromFileReportDescriptor", "Lorg/jetbrains/qodana/report/FileReportDescriptor;", "reportDescriptorFromState", "Companion", "State", "ReportDescriptorState", "intellij.qodana"})
@SourceDebugExtension(value={"SMAP\nQodanaLocalReportsService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 QodanaLocalReportsService.kt\norg/jetbrains/qodana/report/QodanaLocalReportsService\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,136:1\n1915#2,2:137\n3347#2,10:139\n1642#2,10:149\n1915#2:159\n1916#2:161\n1652#2:162\n1642#2,10:163\n1915#2:173\n1916#2:175\n1652#2:176\n1#3:160\n1#3:174\n1#3:177\n*S KotlinDebug\n*F\n+ 1 QodanaLocalReportsService.kt\norg/jetbrains/qodana/report/QodanaLocalReportsService\n*L\n32#1:137,2\n42#1:139,10\n49#1:149,10\n49#1:159\n49#1:161\n49#1:162\n54#1:163,10\n54#1:173\n54#1:175\n54#1:176\n49#1:160\n54#1:174\n*E\n"})
public final class QodanaLocalReportsService
implements PersistentStateComponent<State> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final Set<LocalReportDescriptor> reports;

    public QodanaLocalReportsService(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        ConcurrentHashMap.KeySetView keySetView = new ConcurrentHashMap().keySet(Unit.INSTANCE);
        Intrinsics.checkNotNullExpressionValue(keySetView, (String)"keySet(...)");
        this.reports = keySetView;
    }

    public final void clear() {
        Set clearedReports = CollectionsKt.toSet((Iterable)this.reports);
        this.reports.removeAll(clearedReports);
        Iterable $this$forEach$iv = clearedReports;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            LocalReportDescriptor it = (LocalReportDescriptor)element$iv;
            boolean bl = false;
            it.markAsUnavailable();
        }
    }

    public final void addReport(@NotNull LocalReportDescriptor reportDescriptor) {
        Intrinsics.checkNotNullParameter((Object)reportDescriptor, (String)"reportDescriptor");
        this.reports.add(reportDescriptor);
    }

    @NotNull
    public final Set<LocalReportDescriptor> getReports() {
        Set currentReports = CollectionsKt.toSet((Iterable)this.reports);
        Iterable $this$partition$iv = currentReports;
        boolean $i$f$partition = false;
        ArrayList first$iv = new ArrayList();
        ArrayList second$iv = new ArrayList();
        for (Object element$iv : $this$partition$iv) {
            LocalReportDescriptor it = (LocalReportDescriptor)element$iv;
            boolean bl = false;
            boolean bl2 = it.checkAvailability() ? first$iv.add(element$iv) : second$iv.add(element$iv);
        }
        Pair pair = new Pair(first$iv, second$iv);
        List availableReports = (List)pair.component1();
        List unavailableReports = (List)pair.component2();
        this.reports.removeAll(CollectionsKt.toSet((Iterable)unavailableReports));
        return CollectionsKt.toSet((Iterable)availableReports);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public State getState() {
        void $this$mapNotNullTo$iv$iv;
        Iterable $this$mapNotNull$iv = this.reports;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            ReportDescriptorState it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            LocalReportDescriptor p0 = (LocalReportDescriptor)element$iv$iv;
            boolean bl2 = false;
            if (this.reportStateFromDescriptor(p0) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List list2 = (List)destination$iv$iv;
        return new State(list2);
    }

    /*
     * WARNING - void declaration
     */
    public void loadState(@NotNull State state) {
        void $this$mapNotNullTo$iv$iv;
        void $this$mapNotNull$iv;
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        this.reports.clear();
        Iterable iterable = state.getDescriptions();
        Set<LocalReportDescriptor> set = this.reports;
        boolean $i$f$mapNotNull = false;
        void var4_5 = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            LocalReportDescriptor it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            ReportDescriptorState p0 = (ReportDescriptorState)element$iv$iv;
            boolean bl2 = false;
            if (this.reportDescriptorFromState(p0) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        set.addAll((List)destination$iv$iv);
    }

    private final ReportDescriptorState reportStateFromDescriptor(LocalReportDescriptor descriptor2) {
        ReportDescriptorState reportDescriptorState;
        LocalReportDescriptor localReportDescriptor = descriptor2;
        if (localReportDescriptor instanceof FileReportDescriptor) {
            reportDescriptorState = this.reportStateFromFileReportDescriptor((FileReportDescriptor)descriptor2);
        } else if (localReportDescriptor instanceof LocalRunNotPublishedReportDescriptor) {
            ReportDescriptorState state;
            ReportDescriptorState reportDescriptorState2;
            ReportDescriptorState $this$reportStateFromDescriptor_u24lambda_u240 = reportDescriptorState2 = (state = this.reportStateFromFileReportDescriptor(((LocalRunNotPublishedReportDescriptor)descriptor2).getFileReportDescriptor()));
            boolean bl = false;
            $this$reportStateFromDescriptor_u24lambda_u240.setLocalRun(true);
            reportDescriptorState = reportDescriptorState2;
        } else if (localReportDescriptor instanceof LocalRunPublishedReportDescriptor) {
            ReportDescriptorState state;
            ReportDescriptorState reportDescriptorState3;
            ReportDescriptorState $this$reportStateFromDescriptor_u24lambda_u241 = reportDescriptorState3 = (state = this.reportStateFromFileReportDescriptor(((LocalRunPublishedReportDescriptor)descriptor2).getFileReportDescriptor()));
            boolean bl = false;
            $this$reportStateFromDescriptor_u24lambda_u241.setLocalRun(true);
            $this$reportStateFromDescriptor_u24lambda_u241.setPublishedReportLink(((LocalRunPublishedReportDescriptor)descriptor2).getPublishedReportLink());
            reportDescriptorState = reportDescriptorState3;
        } else {
            reportDescriptorState = null;
        }
        return reportDescriptorState;
    }

    private final ReportDescriptorState reportStateFromFileReportDescriptor(FileReportDescriptor descriptor2) {
        ReportDescriptorState reportDescriptorState;
        ReportDescriptorState $this$reportStateFromFileReportDescriptor_u24lambda_u240 = reportDescriptorState = new ReportDescriptorState();
        boolean bl = false;
        $this$reportStateFromFileReportDescriptor_u24lambda_u240.setReportGuid(descriptor2.getReportGuid());
        $this$reportStateFromFileReportDescriptor_u24lambda_u240.setReportId(descriptor2.getReportName());
        $this$reportStateFromFileReportDescriptor_u24lambda_u240.setPath(((Object)descriptor2.getReportPath()).toString());
        $this$reportStateFromFileReportDescriptor_u24lambda_u240.setQodana(descriptor2.isQodanaReport());
        return reportDescriptorState;
    }

    private final LocalReportDescriptor reportDescriptorFromState(ReportDescriptorState state) {
        Path path;
        String string = state.getPath();
        if (string != null) {
            String it = string;
            boolean bl = false;
            Path path2 = Paths.get(it, new String[0]);
            path = path2;
            Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"get(...)");
        } else {
            path = null;
        }
        Path path3 = path;
        String reportGuid = state.getReportGuid();
        String reportId2 = state.getReportId();
        if (path3 == null || reportGuid == null || reportId2 == null) {
            return null;
        }
        FileReportDescriptor fileReportDescriptor = new FileReportDescriptor(path3, state.isQodana(), reportGuid, reportId2, this.project);
        boolean isLocalRun = state.isLocalRun();
        String publishedReportLink2 = state.getPublishedReportLink();
        return !isLocalRun ? (LocalReportDescriptor)fileReportDescriptor : (isLocalRun && publishedReportLink2 == null ? (LocalReportDescriptor)new LocalRunNotPublishedReportDescriptor(fileReportDescriptor, false) : (isLocalRun && publishedReportLink2 != null ? (LocalReportDescriptor)new LocalRunPublishedReportDescriptor(fileReportDescriptor, publishedReportLink2, false) : null));
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\b"}, d2={"Lorg/jetbrains/qodana/report/QodanaLocalReportsService$Companion;", "", "<init>", "()V", "getInstance", "Lorg/jetbrains/qodana/report/QodanaLocalReportsService;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.qodana"})
    @SourceDebugExtension(value={"SMAP\nQodanaLocalReportsService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 QodanaLocalReportsService.kt\norg/jetbrains/qodana/report/QodanaLocalReportsService$Companion\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,136:1\n30#2,2:137\n*S KotlinDebug\n*F\n+ 1 QodanaLocalReportsService.kt\norg/jetbrains/qodana/report/QodanaLocalReportsService$Companion\n*L\n24#1:137,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final QodanaLocalReportsService getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            ComponentManager $this$service$iv = (ComponentManager)project;
            boolean $i$f$service = false;
            Class<QodanaLocalReportsService> serviceClass$iv = QodanaLocalReportsService.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            return (QodanaLocalReportsService)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Tag(value="ReportDescription")
    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0002\b\t\b\u0007\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u001e\u0010\u0004\u001a\u0004\u0018\u00010\u00058\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u001e\u0010\n\u001a\u0004\u0018\u00010\u00058\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\u0007\"\u0004\b\f\u0010\tR\u001e\u0010\r\u001a\u0004\u0018\u00010\u00058\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u0007\"\u0004\b\u000f\u0010\tR\u001c\u0010\u0010\u001a\u00020\u00118\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u001c\u0010\u0015\u001a\u00020\u00118\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0012\"\u0004\b\u0016\u0010\u0014R\u001e\u0010\u0017\u001a\u0004\u0018\u00010\u00058\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0007\"\u0004\b\u0019\u0010\t\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/qodana/report/QodanaLocalReportsService$ReportDescriptorState;", "", "<init>", "()V", "reportGuid", "", "getReportGuid", "()Ljava/lang/String;", "setReportGuid", "(Ljava/lang/String;)V", "reportId", "getReportId", "setReportId", "path", "getPath", "setPath", "isQodana", "", "()Z", "setQodana", "(Z)V", "isLocalRun", "setLocalRun", "publishedReportLink", "getPublishedReportLink", "setPublishedReportLink", "intellij.qodana"})
    public static final class ReportDescriptorState {
        @Nullable
        private String reportGuid;
        @Nullable
        private String reportId;
        @Nullable
        private String path;
        private boolean isQodana = true;
        private boolean isLocalRun;
        @Nullable
        private String publishedReportLink;

        @Attribute
        @Nullable
        public final String getReportGuid() {
            return this.reportGuid;
        }

        public final void setReportGuid(@Nullable String string) {
            this.reportGuid = string;
        }

        @Attribute
        @Nullable
        public final String getReportId() {
            return this.reportId;
        }

        public final void setReportId(@Nullable String string) {
            this.reportId = string;
        }

        @Attribute
        @Nullable
        public final String getPath() {
            return this.path;
        }

        public final void setPath(@Nullable String string) {
            this.path = string;
        }

        @Attribute
        public final boolean isQodana() {
            return this.isQodana;
        }

        public final void setQodana(boolean bl) {
            this.isQodana = bl;
        }

        @Attribute
        public final boolean isLocalRun() {
            return this.isLocalRun;
        }

        public final void setLocalRun(boolean bl) {
            this.isLocalRun = bl;
        }

        @Attribute
        @Nullable
        public final String getPublishedReportLink() {
            return this.publishedReportLink;
        }

        public final void setPublishedReportLink(@Nullable String string) {
            this.publishedReportLink = string;
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0017\u0012\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006R\u001c\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00038\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lorg/jetbrains/qodana/report/QodanaLocalReportsService$State;", "", "descriptions", "", "Lorg/jetbrains/qodana/report/QodanaLocalReportsService$ReportDescriptorState;", "<init>", "(Ljava/util/List;)V", "getDescriptions", "()Ljava/util/List;", "intellij.qodana"})
    public static final class State {
        @XCollection
        @NotNull
        private final List<ReportDescriptorState> descriptions;

        public State(@NotNull List<ReportDescriptorState> descriptions) {
            Intrinsics.checkNotNullParameter(descriptions, (String)"descriptions");
            this.descriptions = descriptions;
        }

        public /* synthetic */ State(List list2, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                list2 = CollectionsKt.emptyList();
            }
            this(list2);
        }

        @NotNull
        public final List<ReportDescriptorState> getDescriptions() {
            return this.descriptions;
        }

        public State() {
            this(null, 1, null);
        }
    }
}

