/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.qodana.staticAnalysis.sarif.fingerprints;

import com.google.common.hash.HashFunction;
import com.google.common.hash.Hashing;
import com.jetbrains.qodana.sarif.model.Edge;
import com.jetbrains.qodana.sarif.model.Graph;
import com.jetbrains.qodana.sarif.model.Location;
import com.jetbrains.qodana.sarif.model.Message;
import com.jetbrains.qodana.sarif.model.Node;
import com.jetbrains.qodana.sarif.model.Result;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.qodana.staticAnalysis.sarif.fingerprints.CommonFingerprintsKt;
import org.jetbrains.qodana.staticAnalysis.sarif.fingerprints.FingerprintCalculator;
import org.jetbrains.qodana.staticAnalysis.sarif.fingerprints.SafeHasher;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\b\u00c0\n\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\r\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0014\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u00d6\u0083\u0004J\n\u0010\u0014\u001a\u00020\nH\u00d6\u0081\u0004J\n\u0010\u0015\u001a\u00020\u0005H\u00d6\u0081\u0004R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/qodana/staticAnalysis/sarif/fingerprints/BaselineEqualityV2;", "Lorg/jetbrains/qodana/staticAnalysis/sarif/fingerprints/FingerprintCalculator;", "<init>", "()V", "ADDITIONAL_FINGERPRINT_DATA", "", "name", "getName", "()Ljava/lang/String;", "version", "", "getVersion", "()I", "calculate", "result", "Lcom/jetbrains/qodana/sarif/model/Result;", "equals", "", "other", "", "hashCode", "toString", "intellij.qodana"})
public final class BaselineEqualityV2
implements FingerprintCalculator {
    @NotNull
    public static final BaselineEqualityV2 INSTANCE = new BaselineEqualityV2();
    @NotNull
    public static final String ADDITIONAL_FINGERPRINT_DATA = "equalIndicator/2/additionalData";

    private BaselineEqualityV2() {
    }

    @Override
    @NotNull
    public String getName() {
        return "equalIndicator";
    }

    @Override
    public int getVersion() {
        return 2;
    }

    @Override
    @NotNull
    public String calculate(@NotNull Result result2) {
        Intrinsics.checkNotNullParameter((Object)result2, (String)"result");
        HashFunction hashFunction = Hashing.fingerprint2011();
        Intrinsics.checkNotNullExpressionValue((Object)hashFunction, (String)"fingerprint2011(...)");
        return CommonFingerprintsKt.hash(hashFunction, (Function1<? super SafeHasher, Unit>)((Function1)arg_0 -> BaselineEqualityV2.calculate$lambda$0(result2, arg_0)));
    }

    @NotNull
    public String toString() {
        return "BaselineEqualityV2";
    }

    public int hashCode() {
        return 745711271;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof BaselineEqualityV2)) {
            return false;
        }
        BaselineEqualityV2 cfr_ignored_0 = (BaselineEqualityV2)other;
        return true;
    }

    private static final Unit calculate$lambda$0$1$0(SafeHasher $hasher, Node it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        CommonFingerprintsKt.hash(it, $hasher);
        return Unit.INSTANCE;
    }

    private static final Unit calculate$lambda$0$1$1(SafeHasher $hasher, Edge it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        CommonFingerprintsKt.hash(it, $hasher);
        return Unit.INSTANCE;
    }

    private static final Unit calculate$lambda$0$0(SafeHasher $hasher, Location it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        CommonFingerprintsKt.hash(it, $hasher);
        return Unit.INSTANCE;
    }

    private static final Unit calculate$lambda$0$1(SafeHasher $hasher, Graph graph) {
        Intrinsics.checkNotNullParameter((Object)graph, (String)"graph");
        CommonFingerprintsKt.forEachNotNull(graph.getNodes(), arg_0 -> BaselineEqualityV2.calculate$lambda$0$1$0($hasher, arg_0));
        CommonFingerprintsKt.forEachNotNull(graph.getEdges(), arg_0 -> BaselineEqualityV2.calculate$lambda$0$1$1($hasher, arg_0));
        return Unit.INSTANCE;
    }

    private static final Unit calculate$lambda$0(Result $result, SafeHasher hasher) {
        Intrinsics.checkNotNullParameter((Object)hasher, (String)"hasher");
        hasher.put($result.getRuleId());
        CommonFingerprintsKt.forEachNotNull($result.getLocations(), arg_0 -> BaselineEqualityV2.calculate$lambda$0$0(hasher, arg_0));
        if ($result.getLocations() == null || $result.getLocations().isEmpty()) {
            Message message = $result.getMessage();
            hasher.put(message != null ? message.getText() : null);
        }
        CommonFingerprintsKt.forEachNotNull($result.getGraphs(), arg_0 -> BaselineEqualityV2.calculate$lambda$0$1(hasher, arg_0));
        Object object = $result.getProperties();
        hasher.put(object != null && (object = object.get((Object)ADDITIONAL_FINGERPRINT_DATA)) != null ? Integer.valueOf(object.hashCode()) : null);
        return Unit.INSTANCE;
    }
}

