/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.qodana.staticAnalysis.stat;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ComponentManagerEx;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ContentIterator;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiFunction;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.qodana.staticAnalysis.stat.InspectionEventsCollector;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\n\b\u0007\u0018\u0000 \u00182\u00020\u0001:\u0002\u0018\u0019B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001c\u0010\f\u001a\u00020\r2\u0012\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\r0\u000fH\u0002J,\u0010\u0011\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u000b2\u0012\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\r0\u000fH\u0002J\u0010\u0010\u0015\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\u0010H\u0002J\u000e\u0010\u0016\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\u0010J\u0006\u0010\u0017\u001a\u00020\rR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/qodana/staticAnalysis/stat/InspectionFingerprintAggregatorService;", "", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "filetypes", "Ljava/util/concurrent/ConcurrentHashMap;", "", "Lorg/jetbrains/qodana/staticAnalysis/stat/InspectionFingerprintAggregatorService$CountsInfo;", "iterateFilesAndAct", "", "action", "Lkotlin/Function1;", "Lcom/intellij/psi/PsiFile;", "registerFile", "file", "defaultInfo", "incrementer", "registerExistingFile", "registerAnalyzedFile", "logFingerprint", "Companion", "CountsInfo", "intellij.qodana"})
@SourceDebugExtension(value={"SMAP\nInspectionFingerprintAggregatorService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 InspectionFingerprintAggregatorService.kt\norg/jetbrains/qodana/staticAnalysis/stat/InspectionFingerprintAggregatorService\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,65:1\n777#2:66\n873#2,2:67\n1915#2,2:69\n*S KotlinDebug\n*F\n+ 1 InspectionFingerprintAggregatorService.kt\norg/jetbrains/qodana/staticAnalysis/stat/InspectionFingerprintAggregatorService\n*L\n60#1:66\n60#1:67,2\n60#1:69,2\n*E\n"})
public final class InspectionFingerprintAggregatorService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final ConcurrentHashMap<String, CountsInfo> filetypes;

    public InspectionFingerprintAggregatorService(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.filetypes = new ConcurrentHashMap();
        this.iterateFilesAndAct((Function1<? super PsiFile, Unit>)((Function1)arg_0 -> InspectionFingerprintAggregatorService._init_$lambda$0(this, arg_0)));
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    private final void iterateFilesAndAct(Function1<? super PsiFile, Unit> action) {
        PsiManager psiManager = PsiManager.getInstance((Project)this.project);
        Intrinsics.checkNotNullExpressionValue((Object)psiManager, (String)"getInstance(...)");
        PsiManager psiManager2 = psiManager;
        ApplicationManager.getApplication().runReadAction(new Runnable(this, psiManager2, action){
            final /* synthetic */ InspectionFingerprintAggregatorService this$0;
            final /* synthetic */ PsiManager $psiManager;
            final /* synthetic */ Function1<PsiFile, Unit> $action;
            {
                this.this$0 = $receiver;
                this.$psiManager = $psiManager;
                this.$action = $action;
            }

            public final void run() {
                ProjectFileIndex.getInstance((Project)this.this$0.getProject()).iterateContent(new ContentIterator(this.$psiManager, this.$action){
                    final /* synthetic */ PsiManager $psiManager;
                    final /* synthetic */ Function1<PsiFile, Unit> $action;
                    {
                        this.$psiManager = $psiManager;
                        this.$action = $action;
                    }

                    public final boolean processFile(VirtualFile fileOrDir) {
                        block0: {
                            Intrinsics.checkNotNullParameter((Object)fileOrDir, (String)"fileOrDir");
                            PsiFile psiFile = this.$psiManager.findFile(fileOrDir);
                            if (psiFile == null) break block0;
                            PsiFile psiFile2 = psiFile;
                            Function1<PsiFile, Unit> function1 = this.$action;
                            PsiFile it = psiFile2;
                            boolean bl = false;
                            function1.invoke((Object)it);
                        }
                        return true;
                    }
                });
            }
        });
    }

    private final void registerFile(PsiFile file2, CountsInfo defaultInfo, Function1<? super CountsInfo, Unit> incrementer) {
        if (file2.getLanguage().getAssociatedFileType() == null) {
            return;
        }
        LanguageFileType languageFileType = file2.getLanguage().getAssociatedFileType();
        Intrinsics.checkNotNull((Object)languageFileType);
        String string = languageFileType.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        String filetype = string;
        this.filetypes.compute(filetype, new BiFunction(defaultInfo, incrementer){
            final /* synthetic */ CountsInfo $defaultInfo;
            final /* synthetic */ Function1<CountsInfo, Unit> $incrementer;
            {
                this.$defaultInfo = $defaultInfo;
                this.$incrementer = $incrementer;
            }

            public final CountsInfo apply(String string, CountsInfo v) {
                CountsInfo countsInfo;
                Intrinsics.checkNotNullParameter((Object)string, (String)"<unused var>");
                if (v == null) {
                    countsInfo = this.$defaultInfo;
                } else {
                    this.$incrementer.invoke((Object)v);
                    countsInfo = v;
                }
                return countsInfo;
            }
        });
    }

    private final void registerExistingFile(PsiFile file2) {
        this.registerFile(file2, new CountsInfo(1, 0), (Function1<? super CountsInfo, Unit>)((Function1)InspectionFingerprintAggregatorService::registerExistingFile$lambda$0));
    }

    public final void registerAnalyzedFile(@NotNull PsiFile file2) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        this.registerFile(file2, new CountsInfo(1, 1), (Function1<? super CountsInfo, Unit>)((Function1)InspectionFingerprintAggregatorService::registerAnalyzedFile$lambda$0));
    }

    /*
     * WARNING - void declaration
     */
    public final void logFingerprint() {
        void $this$filterTo$iv$iv;
        Set<Map.Entry<String, CountsInfo>> set = this.filetypes.entrySet();
        Intrinsics.checkNotNullExpressionValue(set, (String)"<get-entries>(...)");
        Iterable $this$filter$iv = set;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Map.Entry it = (Map.Entry)element$iv$iv;
            boolean bl = false;
            Object k = it.getKey();
            Intrinsics.checkNotNullExpressionValue(k, (String)"<get-key>(...)");
            boolean bl2 = ((CharSequence)k).length() > 0;
            if (!bl2) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$forEach$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Map.Entry entry = (Map.Entry)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)entry);
            Object k = entry.getKey();
            Intrinsics.checkNotNullExpressionValue(k, (String)"component1(...)");
            String key = (String)k;
            Object v = entry.getValue();
            Intrinsics.checkNotNullExpressionValue(v, (String)"component2(...)");
            CountsInfo value2 = (CountsInfo)v;
            InspectionEventsCollector.logInspectionFingerprint(key, value2.getTotalCount(), value2.getAnalyzedCount(), this.project);
        }
    }

    private static final Unit _init_$lambda$0(InspectionFingerprintAggregatorService this$0, PsiFile it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.registerExistingFile(it);
        return Unit.INSTANCE;
    }

    private static final Unit registerExistingFile$lambda$0(CountsInfo v) {
        Intrinsics.checkNotNullParameter((Object)v, (String)"v");
        int n = v.getTotalCount();
        v.setTotalCount(n + 1);
        return Unit.INSTANCE;
    }

    private static final Unit registerAnalyzedFile$lambda$0(CountsInfo v) {
        Intrinsics.checkNotNullParameter((Object)v, (String)"v");
        int n = v.getAnalyzedCount();
        v.setAnalyzedCount(n + 1);
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0086@\u00a2\u0006\u0002\u0010\b\u00a8\u0006\t"}, d2={"Lorg/jetbrains/qodana/staticAnalysis/stat/InspectionFingerprintAggregatorService$Companion;", "", "<init>", "()V", "getInstance", "Lorg/jetbrains/qodana/staticAnalysis/stat/InspectionFingerprintAggregatorService;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "intellij.qodana"})
    @SourceDebugExtension(value={"SMAP\nInspectionFingerprintAggregatorService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 InspectionFingerprintAggregatorService.kt\norg/jetbrains/qodana/staticAnalysis/stat/InspectionFingerprintAggregatorService$Companion\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,65:1\n83#2:66\n*S KotlinDebug\n*F\n+ 1 InspectionFingerprintAggregatorService.kt\norg/jetbrains/qodana/staticAnalysis/stat/InspectionFingerprintAggregatorService$Companion\n*L\n15#1:66\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final Object getInstance(@NotNull Project project, @NotNull Continuation<? super InspectionFingerprintAggregatorService> $completion) {
            ComponentManager $this$serviceAsync$iv = (ComponentManager)project;
            boolean $i$f$serviceAsync = false;
            Intrinsics.checkNotNull((Object)$this$serviceAsync$iv, (String)"null cannot be cast to non-null type com.intellij.openapi.components.ComponentManagerEx");
            return ((ComponentManagerEx)$this$serviceAsync$iv).getServiceAsync(InspectionFingerprintAggregatorService.class, $completion);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\n\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u001a\u0010\u0004\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\b\"\u0004\b\f\u0010\n\u00a8\u0006\r"}, d2={"Lorg/jetbrains/qodana/staticAnalysis/stat/InspectionFingerprintAggregatorService$CountsInfo;", "", "totalCount", "", "analyzedCount", "<init>", "(II)V", "getTotalCount", "()I", "setTotalCount", "(I)V", "getAnalyzedCount", "setAnalyzedCount", "intellij.qodana"})
    private static final class CountsInfo {
        private int totalCount;
        private int analyzedCount;

        public CountsInfo(int totalCount, int analyzedCount) {
            this.totalCount = totalCount;
            this.analyzedCount = analyzedCount;
        }

        public final int getTotalCount() {
            return this.totalCount;
        }

        public final void setTotalCount(int n) {
            this.totalCount = n;
        }

        public final int getAnalyzedCount() {
            return this.analyzedCount;
        }

        public final void setAnalyzedCount(int n) {
            this.analyzedCount = n;
        }
    }
}

