/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.code.provenance.dev.view.components;

import com.intellij.code.provenance.core.events.storage.ProvenanceStorage;
import com.intellij.code.provenance.core.events.utils.UtilsKt;
import com.intellij.code.provenance.dev.ProvenanceDevBundle;
import com.intellij.code.provenance.dev.ProvenanceDevRegistry;
import com.intellij.code.provenance.dev.view.ProvenanceViewService;
import com.intellij.code.provenance.dev.view.presenter.ChangePresenter;
import com.intellij.code.provenance.dev.view.presenter.ChangePresenterParent;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.ui.AnimatedIcon;
import com.intellij.ui.CollapsiblePanel;
import com.intellij.ui.JBColor;
import com.intellij.ui.components.JBLabel;
import com.intellij.util.ui.JBUI;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001:\u0001 B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0012\u001a\u00020\u0001H\u0002J\b\u0010\u0013\u001a\u00020\u0001H\u0002J\b\u0010\u0014\u001a\u00020\u0015H\u0002J\b\u0010\u0016\u001a\u00020\u0015H\u0002J\b\u0010\u0017\u001a\u00020\u0018H\u0002J\u0010\u0010\u0019\u001a\u00020\u00152\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\b\u0010\u001c\u001a\u00020\u0015H\u0002J\b\u0010\u001d\u001a\u00020\u0015H\u0002J\b\u0010\u001e\u001a\u00020\u0015H\u0002J\b\u0010\u001f\u001a\u00020\u0015H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lcom/intellij/code/provenance/dev/view/components/CurrentStatePanel;", "Ljavax/swing/JPanel;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "contentPanel", "initialStatePanel", "loadingStatePanel", "state", "Lcom/intellij/code/provenance/dev/view/components/CurrentStatePanel$PanelState;", "countdownTimer", "Ljavax/swing/Timer;", "nextRunTime", "", "countdownLabel", "Ljavax/swing/JLabel;", "lastEntryTimestamp", "createInitialStatePanel", "createLoadingStatePanel", "showInitialState", "", "showLoadingState", "createSettingsButton", "Ljavax/swing/JButton;", "showSettingsPopup", "event", "Ljava/awt/event/ActionEvent;", "updateCountdownLabel", "updateLastEntryTimestamp", "updateAutoRunTimer", "startCalculation", "PanelState", "intellij.code.provenance.dev"})
@SourceDebugExtension(value={"SMAP\nCurrentStatePanel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CurrentStatePanel.kt\ncom/intellij/code/provenance/dev/view/components/CurrentStatePanel\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,279:1\n1391#2:280\n1480#2,5:281\n2045#2,14:286\n*S KotlinDebug\n*F\n+ 1 CurrentStatePanel.kt\ncom/intellij/code/provenance/dev/view/components/CurrentStatePanel\n*L\n212#1:280\n212#1:281,5\n214#1:286,14\n*E\n"})
public final class CurrentStatePanel
extends JPanel {
    @NotNull
    private final Project project;
    @NotNull
    private final JPanel contentPanel;
    @NotNull
    private final JPanel initialStatePanel;
    @NotNull
    private final JPanel loadingStatePanel;
    @NotNull
    private PanelState state;
    @Nullable
    private Timer countdownTimer;
    private long nextRunTime;
    @Nullable
    private JLabel countdownLabel;
    private long lastEntryTimestamp;

    public CurrentStatePanel(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        super(new BorderLayout());
        this.project = project;
        this.contentPanel = new JPanel(new BorderLayout());
        this.initialStatePanel = this.createInitialStatePanel();
        this.loadingStatePanel = this.createLoadingStatePanel();
        this.state = new PanelState(false, false, 0, 0, 0L, 31, null);
        CollapsiblePanel collapsiblePanel = new CollapsiblePanel((JComponent)this.contentPanel, false, false, AllIcons.General.ArrowDown, AllIcons.General.ArrowRight, ProvenanceDevBundle.INSTANCE.message("provenance.dev.current.state.title", new Object[0]));
        collapsiblePanel.setBorder((Border)JBUI.Borders.empty((int)5, (int)10));
        this.add((Component)collapsiblePanel, "Center");
        this.showInitialState();
        this.updateAutoRunTimer();
    }

    private final JPanel createInitialStatePanel() {
        JPanel panel = new JPanel(new BorderLayout());
        panel.setBorder(JBUI.Borders.empty((int)10));
        JBLabel messageLabel = new JBLabel(ProvenanceDevBundle.INSTANCE.message("provenance.dev.current.state.initial.message", new Object[0]));
        messageLabel.setFont(messageLabel.getFont().deriveFont(0));
        messageLabel.setForeground((Color)JBColor.GRAY);
        JButton runButton = new JButton();
        runButton.setIcon(AllIcons.Actions.Execute);
        runButton.setToolTipText(ProvenanceDevBundle.INSTANCE.message("provenance.dev.current.state.calculate.tooltip", new Object[0]));
        runButton.addActionListener(arg_0 -> CurrentStatePanel.createInitialStatePanel$lambda$0(this, arg_0));
        runButton.setPreferredSize((Dimension)JBUI.size((int)24, (int)24));
        runButton.setBorderPainted(false);
        runButton.setContentAreaFilled(false);
        JButton settingsButton = this.createSettingsButton();
        JPanel topPanel = new JPanel(new BorderLayout());
        topPanel.add((Component)messageLabel, "Center");
        JPanel rightPanel = new JPanel(new FlowLayout(2));
        rightPanel.add(runButton);
        rightPanel.add(settingsButton);
        topPanel.add((Component)rightPanel, "East");
        panel.add((Component)topPanel, "Center");
        return panel;
    }

    private final JPanel createLoadingStatePanel() {
        JPanel panel = new JPanel(new FlowLayout(0));
        panel.setBorder(JBUI.Borders.empty((int)10));
        JBLabel spinner = new JBLabel(ProvenanceDevBundle.INSTANCE.message("provenance.dev.current.state.loading.message", new Object[0]));
        spinner.setIcon((Icon)new AnimatedIcon.Default());
        panel.add((Component)spinner);
        return panel;
    }

    private final void showInitialState() {
        this.state = new PanelState(false, false, 0, 0, 0L, 31, null);
        this.contentPanel.removeAll();
        this.contentPanel.add((Component)this.initialStatePanel, "Center");
        this.contentPanel.revalidate();
        this.contentPanel.repaint();
    }

    private final void showLoadingState() {
        this.contentPanel.removeAll();
        this.contentPanel.add((Component)this.loadingStatePanel, "Center");
        this.contentPanel.revalidate();
        this.contentPanel.repaint();
    }

    private final JButton createSettingsButton() {
        JButton settingsButton = new JButton();
        settingsButton.setIcon(AllIcons.General.GearPlain);
        settingsButton.setToolTipText(ProvenanceDevBundle.INSTANCE.message("provenance.dev.current.state.settings.tooltip", new Object[0]));
        settingsButton.setPreferredSize((Dimension)JBUI.size((int)24, (int)24));
        settingsButton.setBorderPainted(false);
        settingsButton.setContentAreaFilled(false);
        settingsButton.addActionListener(arg_0 -> CurrentStatePanel.createSettingsButton$lambda$0(this, arg_0));
        return settingsButton;
    }

    private final void showSettingsPopup(ActionEvent event) {
        Object object = event.getSource();
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type javax.swing.JButton");
        JButton source = (JButton)object;
        JPopupMenu popup = new JPopupMenu();
        int timeoutValue = ProvenanceDevRegistry.INSTANCE.getStorageUITimeout();
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout(5, 5));
        panel.setBorder(JBUI.Borders.empty((int)5));
        JPanel valuePanel = new JPanel(new BorderLayout(5, 0));
        valuePanel.add((Component)new JLabel(ProvenanceDevBundle.INSTANCE.message("provenance.dev.current.state.settings.interval.label", new Object[0])), "West");
        JSpinner spinner = new JSpinner(new SpinnerNumberModel(timeoutValue, 0, 3600, 1));
        spinner.addChangeListener(arg_0 -> CurrentStatePanel.showSettingsPopup$lambda$0(spinner, this, arg_0));
        JComponent jComponent = spinner.getEditor();
        Intrinsics.checkNotNull((Object)jComponent, (String)"null cannot be cast to non-null type javax.swing.JSpinner.DefaultEditor");
        JSpinner.DefaultEditor editor = (JSpinner.DefaultEditor)jComponent;
        JFormattedTextField textField = editor.getTextField();
        textField.getDocument().addDocumentListener(new DocumentListener(textField, timeoutValue, this){
            final /* synthetic */ JFormattedTextField $textField;
            final /* synthetic */ int $timeoutValue;
            final /* synthetic */ CurrentStatePanel this$0;
            {
                this.$textField = $textField;
                this.$timeoutValue = $timeoutValue;
                this.this$0 = $receiver;
            }

            private final void updateValue() {
                try {
                    String text = this.$textField.getText();
                    Intrinsics.checkNotNull((Object)text);
                    Integer newValue = StringsKt.toIntOrNull((String)text);
                    if (newValue != null && newValue >= 0 && newValue <= 3600) {
                        int n = this.$timeoutValue;
                        if (newValue != n) {
                            Registry.Companion.get("code.provenance.storage.ui.timeout").setValue(newValue.intValue());
                            CurrentStatePanel.access$updateAutoRunTimer(this.this$0);
                        }
                    }
                }
                catch (Exception e) {
                    boolean $i$f$fileLogger = false;
                    boolean $i$f$currentClassLogger = false;
                    Class<?> clazz$iv$iv = MethodHandles.lookup().lookupClass();
                    Logger logger = Logger.getInstance(clazz$iv$iv);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                    logger.error((Throwable)e);
                }
            }

            public void insertUpdate(DocumentEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                this.updateValue();
            }

            public void removeUpdate(DocumentEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                this.updateValue();
            }

            public void changedUpdate(DocumentEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                this.updateValue();
            }
        });
        valuePanel.add((Component)spinner, "East");
        panel.add((Component)valuePanel, "North");
        this.countdownLabel = new JLabel();
        this.updateCountdownLabel();
        JLabel jLabel = this.countdownLabel;
        Intrinsics.checkNotNull((Object)jLabel);
        panel.add((Component)jLabel, "South");
        popup.add(panel);
        popup.show(source, 0, source.getHeight());
    }

    private final void updateCountdownLabel() {
        block3: {
            block4: {
                block2: {
                    if (ProvenanceDevRegistry.INSTANCE.isMockAgentActionsEnabled()) {
                        JLabel jLabel = this.countdownLabel;
                        if (jLabel != null) {
                            jLabel.setText(ProvenanceDevBundle.INSTANCE.message("provenance.dev.current.state.mock.disabled", new Object[0]));
                        }
                        return;
                    }
                    int timeoutValue = ProvenanceDevRegistry.INSTANCE.getStorageUITimeout();
                    if (timeoutValue > 0) break block2;
                    JLabel jLabel = this.countdownLabel;
                    if (jLabel == null) break block3;
                    jLabel.setText(ProvenanceDevBundle.INSTANCE.message("provenance.dev.current.state.autorun.disabled", new Object[0]));
                    break block3;
                }
                long remainingTime = (this.nextRunTime - System.currentTimeMillis()) / (long)1000;
                if (remainingTime <= 0L) break block4;
                JLabel jLabel = this.countdownLabel;
                if (jLabel == null) break block3;
                Object[] objectArray = new Object[]{remainingTime};
                jLabel.setText(ProvenanceDevBundle.INSTANCE.message("provenance.dev.current.state.next.autorun", objectArray));
                break block3;
            }
            JLabel jLabel = this.countdownLabel;
            if (jLabel == null) break block3;
            jLabel.setText(ProvenanceDevBundle.INSTANCE.message("provenance.dev.current.state.autorun.scheduled", new Object[0]));
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void updateLastEntryTimestamp() {
        Object v0;
        void $this$flatMapTo$iv$iv;
        List<ChangePresenterParent> content = ProvenanceViewService.Companion.getInstance(this.project).getContent();
        Iterable $this$flatMap$iv = content;
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            ChangePresenterParent it = (ChangePresenterParent)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = it.getLeafs();
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        List allPresenters = (List)destination$iv$iv;
        Iterable $this$maxByOrNull$iv = allPresenters;
        boolean $i$f$maxByOrNull = false;
        Iterator iterator$iv = $this$maxByOrNull$iv.iterator();
        if (!iterator$iv.hasNext()) {
            v0 = null;
        } else {
            Object maxElem$iv = iterator$iv.next();
            if (!iterator$iv.hasNext()) {
                v0 = maxElem$iv;
            } else {
                ChangePresenter it = (ChangePresenter)maxElem$iv;
                boolean bl = false;
                long maxValue$iv = it.getTimestamp();
                do {
                    Object e$iv = iterator$iv.next();
                    ChangePresenter it2 = (ChangePresenter)e$iv;
                    $i$a$-maxByOrNull-CurrentStatePanel$updateLastEntryTimestamp$latestTimestamp$1 = false;
                    long v$iv = it2.getTimestamp();
                    if (maxValue$iv >= v$iv) continue;
                    maxElem$iv = e$iv;
                    maxValue$iv = v$iv;
                } while (iterator$iv.hasNext());
                v0 = maxElem$iv;
            }
        }
        ChangePresenter changePresenter = v0;
        Long latestTimestamp = changePresenter != null ? Long.valueOf(changePresenter.getTimestamp()) : null;
        this.lastEntryTimestamp = latestTimestamp != null ? latestTimestamp : System.currentTimeMillis();
    }

    private final void updateAutoRunTimer() {
        block5: {
            Timer timer = this.countdownTimer;
            if (timer != null) {
                timer.stop();
            }
            if (ProvenanceDevRegistry.INSTANCE.isMockAgentActionsEnabled()) {
                JLabel jLabel = this.countdownLabel;
                if (jLabel != null) {
                    jLabel.setText(ProvenanceDevBundle.INSTANCE.message("provenance.dev.current.state.mock.disabled", new Object[0]));
                }
                return;
            }
            int timeoutValue = ProvenanceDevRegistry.INSTANCE.getStorageUITimeout();
            if (timeoutValue <= 0) {
                JLabel jLabel = this.countdownLabel;
                if (jLabel != null) {
                    jLabel.setText(ProvenanceDevBundle.INSTANCE.message("provenance.dev.current.state.autorun.disabled", new Object[0]));
                }
                return;
            }
            this.updateLastEntryTimestamp();
            this.nextRunTime = System.currentTimeMillis() + (long)(timeoutValue * 1000);
            Timer timer2 = this.countdownTimer = new Timer(1000, arg_0 -> CurrentStatePanel.updateAutoRunTimer$lambda$0(this, timeoutValue, arg_0));
            if (timer2 == null) break block5;
            timer2.start();
        }
    }

    private final void startCalculation() {
        Timer timer;
        this.showLoadingState();
        UtilsKt.runInSuspendContext((Project)this.project, (String)ProvenanceDevBundle.INSTANCE.message("provenance.dev.current.run.state.calculation", new Object[0]), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            final /* synthetic */ CurrentStatePanel this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object $result) {
                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        this.label = 1;
                        Object object2 = BuildersKt.withContext((CoroutineContext)((CoroutineContext)Dispatchers.getIO()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.this$0, null){
                            int label;
                            final /* synthetic */ CurrentStatePanel this$0;
                            {
                                this.this$0 = $receiver;
                                super(2, $completion);
                            }

                            /*
                             * Enabled force condition propagation
                             * Lifted jumps to return sites
                             */
                            public final Object invokeSuspend(Object $result) {
                                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        ResultKt.throwOnFailure((Object)$result);
                                        this.label = 1;
                                        Object object2 = ProvenanceStorage.Companion.getInstance(CurrentStatePanel.access$getProject$p(this.this$0)).doFlush((Continuation)this);
                                        if (object2 != object) return Unit.INSTANCE;
                                        return object;
                                    }
                                    case 1: {
                                        ResultKt.throwOnFailure((Object)$result);
                                        Object object2 = $result;
                                        return Unit.INSTANCE;
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                return (Continuation)new /* invalid duplicate definition of identical inner class */;
                            }

                            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }
                        }), (Continuation)((Continuation)this));
                        if (object2 != object) return Unit.INSTANCE;
                        return object;
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        Object object2 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }));
        Timer $this$startCalculation_u24lambda_u241 = timer = new Timer(2000, arg_0 -> CurrentStatePanel.startCalculation$lambda$0(this, arg_0));
        boolean bl = false;
        $this$startCalculation_u24lambda_u241.setRepeats(false);
        $this$startCalculation_u24lambda_u241.start();
    }

    private static final void createInitialStatePanel$lambda$0(CurrentStatePanel this$0, ActionEvent it) {
        this$0.startCalculation();
    }

    private static final void createSettingsButton$lambda$0(CurrentStatePanel this$0, ActionEvent it) {
        Intrinsics.checkNotNull((Object)it);
        this$0.showSettingsPopup(it);
    }

    private static final void showSettingsPopup$lambda$0(JSpinner $spinner, CurrentStatePanel this$0, ChangeEvent it) {
        Object object = $spinner.getValue();
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.Int");
        int newValue = (Integer)object;
        ProvenanceDevRegistry.INSTANCE.setStorageUITimeout(newValue);
        this$0.updateAutoRunTimer();
    }

    private static final void updateAutoRunTimer$lambda$0(CurrentStatePanel this$0, int $timeoutValue, ActionEvent it) {
        this$0.updateCountdownLabel();
        long currentTime = System.currentTimeMillis();
        if (currentTime >= this$0.nextRunTime) {
            long previousTimestamp = this$0.lastEntryTimestamp;
            this$0.updateLastEntryTimestamp();
            if (this$0.lastEntryTimestamp > previousTimestamp) {
                this$0.startCalculation();
            } else {
                JLabel jLabel = this$0.countdownLabel;
                if (jLabel != null) {
                    jLabel.setText(ProvenanceDevBundle.INSTANCE.message("provenance.dev.current.state.no.changes", new Object[0]));
                }
            }
            this$0.nextRunTime = currentTime + (long)($timeoutValue * 1000);
        }
    }

    private static final void startCalculation$lambda$0$0(CurrentStatePanel this$0) {
        this$0.showInitialState();
    }

    private static final void startCalculation$lambda$0(CurrentStatePanel this$0, ActionEvent it) {
        SwingUtilities.invokeLater(() -> CurrentStatePanel.startCalculation$lambda$0$0(this$0));
    }

    public static final /* synthetic */ void access$updateAutoRunTimer(CurrentStatePanel $this) {
        $this.updateAutoRunTimer();
    }

    public static final /* synthetic */ Project access$getProject$p(CurrentStatePanel $this) {
        return $this.project;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0013\n\u0002\u0010\u000e\n\u0000\b\u0080\b\u0018\u00002\u00020\u0001B9\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\u0006\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\t\u0010\u0013\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0014\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0015\u001a\u00020\u0006H\u00c6\u0003J\t\u0010\u0016\u001a\u00020\u0006H\u00c6\u0003J\t\u0010\u0017\u001a\u00020\tH\u00c6\u0003J;\u0010\u0018\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\u00062\b\b\u0002\u0010\b\u001a\u00020\tH\u00c6\u0001J\u0014\u0010\u0019\u001a\u00020\u00032\b\u0010\u001a\u001a\u0004\u0018\u00010\u0001H\u00d6\u0083\u0004J\n\u0010\u001b\u001a\u00020\u0006H\u00d6\u0081\u0004J\n\u0010\u001c\u001a\u00020\u001dH\u00d6\u0081\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0002\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\fR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000fR\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u001e"}, d2={"Lcom/intellij/code/provenance/dev/view/components/CurrentStatePanel$PanelState;", "", "isIntentClassificationRunning", "", "allVerificationsComplete", "totalVerifications", "", "completedVerifications", "startTime", "", "<init>", "(ZZIIJ)V", "()Z", "getAllVerificationsComplete", "getTotalVerifications", "()I", "getCompletedVerifications", "getStartTime", "()J", "component1", "component2", "component3", "component4", "component5", "copy", "equals", "other", "hashCode", "toString", "", "intellij.code.provenance.dev"})
    public static final class PanelState {
        private final boolean isIntentClassificationRunning;
        private final boolean allVerificationsComplete;
        private final int totalVerifications;
        private final int completedVerifications;
        private final long startTime;

        public PanelState(boolean isIntentClassificationRunning, boolean allVerificationsComplete, int totalVerifications, int completedVerifications, long startTime) {
            this.isIntentClassificationRunning = isIntentClassificationRunning;
            this.allVerificationsComplete = allVerificationsComplete;
            this.totalVerifications = totalVerifications;
            this.completedVerifications = completedVerifications;
            this.startTime = startTime;
        }

        public /* synthetic */ PanelState(boolean bl, boolean bl2, int n, int n2, long l, int n3, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n3 & 1) != 0) {
                bl = false;
            }
            if ((n3 & 2) != 0) {
                bl2 = false;
            }
            if ((n3 & 4) != 0) {
                n = 0;
            }
            if ((n3 & 8) != 0) {
                n2 = 0;
            }
            if ((n3 & 0x10) != 0) {
                l = 0L;
            }
            this(bl, bl2, n, n2, l);
        }

        public final boolean isIntentClassificationRunning() {
            return this.isIntentClassificationRunning;
        }

        public final boolean getAllVerificationsComplete() {
            return this.allVerificationsComplete;
        }

        public final int getTotalVerifications() {
            return this.totalVerifications;
        }

        public final int getCompletedVerifications() {
            return this.completedVerifications;
        }

        public final long getStartTime() {
            return this.startTime;
        }

        public final boolean component1() {
            return this.isIntentClassificationRunning;
        }

        public final boolean component2() {
            return this.allVerificationsComplete;
        }

        public final int component3() {
            return this.totalVerifications;
        }

        public final int component4() {
            return this.completedVerifications;
        }

        public final long component5() {
            return this.startTime;
        }

        @NotNull
        public final PanelState copy(boolean isIntentClassificationRunning, boolean allVerificationsComplete, int totalVerifications, int completedVerifications, long startTime) {
            return new PanelState(isIntentClassificationRunning, allVerificationsComplete, totalVerifications, completedVerifications, startTime);
        }

        public static /* synthetic */ PanelState copy$default(PanelState panelState, boolean bl, boolean bl2, int n, int n2, long l, int n3, Object object) {
            if ((n3 & 1) != 0) {
                bl = panelState.isIntentClassificationRunning;
            }
            if ((n3 & 2) != 0) {
                bl2 = panelState.allVerificationsComplete;
            }
            if ((n3 & 4) != 0) {
                n = panelState.totalVerifications;
            }
            if ((n3 & 8) != 0) {
                n2 = panelState.completedVerifications;
            }
            if ((n3 & 0x10) != 0) {
                l = panelState.startTime;
            }
            return panelState.copy(bl, bl2, n, n2, l);
        }

        @NotNull
        public String toString() {
            return "PanelState(isIntentClassificationRunning=" + this.isIntentClassificationRunning + ", allVerificationsComplete=" + this.allVerificationsComplete + ", totalVerifications=" + this.totalVerifications + ", completedVerifications=" + this.completedVerifications + ", startTime=" + this.startTime + ")";
        }

        public int hashCode() {
            int result = Boolean.hashCode(this.isIntentClassificationRunning);
            result = result * 31 + Boolean.hashCode(this.allVerificationsComplete);
            result = result * 31 + Integer.hashCode(this.totalVerifications);
            result = result * 31 + Integer.hashCode(this.completedVerifications);
            result = result * 31 + Long.hashCode(this.startTime);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof PanelState)) {
                return false;
            }
            PanelState panelState = (PanelState)other;
            if (this.isIntentClassificationRunning != panelState.isIntentClassificationRunning) {
                return false;
            }
            if (this.allVerificationsComplete != panelState.allVerificationsComplete) {
                return false;
            }
            if (this.totalVerifications != panelState.totalVerifications) {
                return false;
            }
            if (this.completedVerifications != panelState.completedVerifications) {
                return false;
            }
            return this.startTime == panelState.startTime;
        }

        public PanelState() {
            this(false, false, 0, 0, 0L, 31, null);
        }
    }
}

