/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.code.provenance.dev.view.components;

import com.intellij.code.provenance.dev.view.ProvenanceViewService;
import com.intellij.code.provenance.dev.view.presenter.ChangeDetails;
import com.intellij.code.provenance.dev.view.presenter.ChangeKind;
import com.intellij.code.provenance.dev.view.presenter.ChangeKindKt;
import com.intellij.code.provenance.dev.view.presenter.ChangePresenter;
import com.intellij.code.provenance.dev.view.presenter.ChangePresenterParent;
import com.intellij.icons.AllIcons;
import com.intellij.ui.ColoredTreeCellRenderer;
import com.intellij.ui.JBColor;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.treeStructure.Tree;
import java.awt.Color;
import java.awt.Component;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001:\u0003\u0018\u0019\u001aB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013J\u001a\u0010\u0014\u001a\u00020\u00112\u0012\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\u00110\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\f\u001a\u00020\r8F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u001b"}, d2={"Lcom/intellij/code/provenance/dev/view/components/ProvenanceTree;", "", "<init>", "()V", "rootNode", "Ljavax/swing/tree/DefaultMutableTreeNode;", "treeModel", "Ljavax/swing/tree/DefaultTreeModel;", "tree", "Lcom/intellij/ui/treeStructure/Tree;", "scrollPane", "Lcom/intellij/ui/components/JBScrollPane;", "component", "Ljavax/swing/JComponent;", "getComponent", "()Ljavax/swing/JComponent;", "update", "", "service", "Lcom/intellij/code/provenance/dev/view/ProvenanceViewService;", "addTreeSelectionListener", "callback", "Lkotlin/Function1;", "Lcom/intellij/code/provenance/dev/view/presenter/ChangeDetails;", "ProvenanceRootNode", "ProvenanceLeafNode", "ProvenanceTreeCellRenderer", "intellij.code.provenance.dev"})
@SourceDebugExtension(value={"SMAP\nProvenanceTree.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ProvenanceTree.kt\ncom/intellij/code/provenance/dev/view/components/ProvenanceTree\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,140:1\n1915#2:141\n1915#2,2:142\n1916#2:144\n*S KotlinDebug\n*F\n+ 1 ProvenanceTree.kt\ncom/intellij/code/provenance/dev/view/components/ProvenanceTree\n*L\n41#1:141\n44#1:142,2\n41#1:144\n*E\n"})
public final class ProvenanceTree {
    @NotNull
    private final DefaultMutableTreeNode rootNode = new DefaultMutableTreeNode("Root");
    @NotNull
    private final DefaultTreeModel treeModel = new DefaultTreeModel(this.rootNode);
    @NotNull
    private final Tree tree = new Tree((TreeModel)this.treeModel);
    @NotNull
    private final JBScrollPane scrollPane = new JBScrollPane((Component)this.tree);

    public ProvenanceTree() {
        this.scrollPane.setHorizontalScrollBarPolicy(31);
        this.tree.setCellRenderer((TreeCellRenderer)((Object)new ProvenanceTreeCellRenderer(this.scrollPane.getVerticalScrollBar().getPreferredSize().width)));
        this.tree.setRootVisible(false);
        this.tree.setShowsRootHandles(true);
        this.tree.getSelectionModel().setSelectionMode(1);
    }

    @NotNull
    public final JComponent getComponent() {
        return (JComponent)this.scrollPane;
    }

    public final void update(@NotNull ProvenanceViewService service) {
        Intrinsics.checkNotNullParameter((Object)service, (String)"service");
        this.rootNode.removeAllChildren();
        Iterable $this$forEach$iv = service.getContent();
        int $i$f$forEach = 0;
        for (Object element$iv : $this$forEach$iv) {
            ChangePresenterParent root = (ChangePresenterParent)element$iv;
            boolean bl = false;
            ProvenanceRootNode parentNode = new ProvenanceRootNode(root);
            if (root.getLeafs().size() > 1) {
                Iterable $this$forEach$iv2 = root.getLeafs();
                boolean $i$f$forEach2 = false;
                for (Object element$iv2 : $this$forEach$iv2) {
                    ChangePresenter leaf = (ChangePresenter)element$iv2;
                    boolean bl2 = false;
                    ProvenanceLeafNode childNode = new ProvenanceLeafNode(leaf);
                    parentNode.add(childNode);
                }
            }
            this.rootNode.add(parentNode);
        }
        this.treeModel.reload();
        $i$f$forEach = this.tree.getRowCount();
        for (int i = 0; i < $i$f$forEach; ++i) {
            this.tree.expandRow(i);
        }
        if (this.rootNode.getChildCount() > 0) {
            TreeNode firstNode = this.rootNode.getChildAt(0);
            Object[] objectArray = new TreeNode[]{this.rootNode, firstNode};
            TreePath path = new TreePath(objectArray);
            this.tree.setSelectionPath(path);
        }
    }

    public final void addTreeSelectionListener(@NotNull Function1<? super ChangeDetails, Unit> callback) {
        Intrinsics.checkNotNullParameter(callback, (String)"callback");
        this.tree.addTreeSelectionListener(arg_0 -> ProvenanceTree.addTreeSelectionListener$lambda$0(this, callback, arg_0));
    }

    private static final void addTreeSelectionListener$lambda$0(ProvenanceTree this$0, Function1 $callback, TreeSelectionEvent e) {
        Object node = this$0.tree.getLastSelectedPathComponent();
        Object object = node;
        if (object instanceof ProvenanceRootNode) {
            $callback.invoke((Object)((ProvenanceRootNode)node).getPresenter());
        } else if (object instanceof ProvenanceLeafNode) {
            $callback.invoke((Object)((ProvenanceLeafNode)node).getPresenter());
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\n\u0010\b\u001a\u00020\tH\u0096\u0080\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\n"}, d2={"Lcom/intellij/code/provenance/dev/view/components/ProvenanceTree$ProvenanceLeafNode;", "Ljavax/swing/tree/DefaultMutableTreeNode;", "presenter", "Lcom/intellij/code/provenance/dev/view/presenter/ChangePresenter;", "<init>", "(Lcom/intellij/code/provenance/dev/view/presenter/ChangePresenter;)V", "getPresenter", "()Lcom/intellij/code/provenance/dev/view/presenter/ChangePresenter;", "toString", "", "intellij.code.provenance.dev"})
    private static final class ProvenanceLeafNode
    extends DefaultMutableTreeNode {
        @NotNull
        private final ChangePresenter presenter;

        public ProvenanceLeafNode(@NotNull ChangePresenter presenter) {
            Intrinsics.checkNotNullParameter((Object)presenter, (String)"presenter");
            super(presenter);
            this.presenter = presenter;
        }

        @NotNull
        public final ChangePresenter getPresenter() {
            return this.presenter;
        }

        @Override
        @NotNull
        public String toString() {
            return this.presenter.getCaption();
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\n\u0010\b\u001a\u00020\tH\u0096\u0080\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\n"}, d2={"Lcom/intellij/code/provenance/dev/view/components/ProvenanceTree$ProvenanceRootNode;", "Ljavax/swing/tree/DefaultMutableTreeNode;", "presenter", "Lcom/intellij/code/provenance/dev/view/presenter/ChangePresenterParent;", "<init>", "(Lcom/intellij/code/provenance/dev/view/presenter/ChangePresenterParent;)V", "getPresenter", "()Lcom/intellij/code/provenance/dev/view/presenter/ChangePresenterParent;", "toString", "", "intellij.code.provenance.dev"})
    private static final class ProvenanceRootNode
    extends DefaultMutableTreeNode {
        @NotNull
        private final ChangePresenterParent presenter;

        public ProvenanceRootNode(@NotNull ChangePresenterParent presenter) {
            Intrinsics.checkNotNullParameter((Object)presenter, (String)"presenter");
            super(presenter);
            this.presenter = presenter;
        }

        @NotNull
        public final ChangePresenterParent getPresenter() {
            return this.presenter;
        }

        @Override
        @NotNull
        public String toString() {
            return this.presenter.getCaption();
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005JB\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u00032\u0006\u0010\u0013\u001a\u00020\u000fH\u0016J\b\u0010\u0014\u001a\u00020\u0003H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0015"}, d2={"Lcom/intellij/code/provenance/dev/view/components/ProvenanceTree$ProvenanceTreeCellRenderer;", "Lcom/intellij/ui/ColoredTreeCellRenderer;", "scrollWidth", "", "<init>", "(I)V", "getScrollWidth", "()I", "customizeCellRenderer", "", "tree", "Ljavax/swing/JTree;", "value", "", "selected", "", "expanded", "leaf", "row", "hasFocus", "paddingLeft", "intellij.code.provenance.dev"})
    private static final class ProvenanceTreeCellRenderer
    extends ColoredTreeCellRenderer {
        private final int scrollWidth;

        public ProvenanceTreeCellRenderer(int scrollWidth) {
            this.scrollWidth = scrollWidth;
        }

        public final int getScrollWidth() {
            return this.scrollWidth;
        }

        public void customizeCellRenderer(@NotNull JTree tree2, @Nullable Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            ChangeKind kind;
            String string;
            Intrinsics.checkNotNullParameter((Object)tree2, (String)"tree");
            DefaultMutableTreeNode defaultMutableTreeNode = value instanceof DefaultMutableTreeNode ? (DefaultMutableTreeNode)value : null;
            if (defaultMutableTreeNode == null) {
                return;
            }
            DefaultMutableTreeNode node = defaultMutableTreeNode;
            DefaultMutableTreeNode defaultMutableTreeNode2 = node;
            if (defaultMutableTreeNode2 instanceof ProvenanceRootNode) {
                string = ((ProvenanceRootNode)node).getPresenter().getCaption();
            } else if (defaultMutableTreeNode2 instanceof ProvenanceLeafNode) {
                string = ((ProvenanceLeafNode)node).getPresenter().getCaption();
            } else {
                String string2 = node.toString();
                string = string2;
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
            }
            String caption = string;
            DefaultMutableTreeNode defaultMutableTreeNode3 = node;
            Long timestamp = defaultMutableTreeNode3 instanceof ProvenanceRootNode ? ((ProvenanceRootNode)node).getPresenter().getTimestamp() : (defaultMutableTreeNode3 instanceof ProvenanceLeafNode ? Long.valueOf(((ProvenanceLeafNode)node).getPresenter().getTimestamp()) : null);
            DefaultMutableTreeNode defaultMutableTreeNode4 = node;
            ChangeKind changeKind = kind = defaultMutableTreeNode4 instanceof ProvenanceRootNode ? ((ProvenanceRootNode)node).getPresenter().getKind() : (defaultMutableTreeNode4 instanceof ProvenanceLeafNode ? ((ProvenanceLeafNode)node).getPresenter().getKind() : null);
            if (changeKind != null) {
                ChangeKind it = changeKind;
                boolean bl = false;
                this.setIcon(ChangeKindKt.icon(it));
            }
            ChangeKind changeKind2 = kind;
            JBColor color = changeKind2 != null ? ChangeKindKt.color(changeKind2) : null;
            this.append(caption, new SimpleTextAttributes(0, (Color)color));
            if (timestamp != null) {
                String timestampStr = ChangePresenter.Companion.formatEntryDateTime(timestamp);
                int padding = tree2.getVisibleRect().width - this.paddingLeft() - this.scrollWidth;
                this.append(timestampStr, SimpleTextAttributes.GRAYED_ATTRIBUTES, padding, 4);
            }
        }

        private final int paddingLeft() {
            return AllIcons.General.ChevronUp.getIconWidth() * 3;
        }
    }
}

