/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.application.options.editor.fonts;

import com.intellij.application.options.editor.fonts.FontWeightComboUI;
import com.intellij.openapi.editor.colors.FontPreferences;
import com.intellij.openapi.editor.impl.FontFamilyService;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractListModel;
import javax.swing.ComboBoxModel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

abstract class FontWeightCombo
extends ComboBox<MyWeightItem> {
    @NotNull
    private final MyModel myModel = new MyModel();

    FontWeightCombo(boolean markRecommended) {
        this.setModel(this.myModel);
        this.setSwingPopup(false);
        this.setRenderer(FontWeightComboUI.getRenderer(markRecommended));
    }

    void update(@NotNull FontPreferences fontPreferences) {
        if (fontPreferences == null) {
            FontWeightCombo.$$$reportNull$$$0(0);
        }
        this.myModel.update(fontPreferences);
    }

    @Nullable
    String getSelectedSubFamily() {
        String string;
        Object object = this.myModel.getSelectedItem();
        if (object instanceof MyWeightItem) {
            MyWeightItem weightItem = (MyWeightItem)object;
            string = weightItem.subFamily;
        } else {
            string = null;
        }
        return string;
    }

    @Nullable
    abstract String getSubFamily(@NotNull FontPreferences var1);

    @NotNull
    abstract String getRecommendedSubFamily(@NotNull String var1);

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fontPreferences", "com/intellij/application/options/editor/fonts/FontWeightCombo", "update"));
    }

    private final class MyModel
    extends AbstractListModel<MyWeightItem>
    implements ComboBoxModel<MyWeightItem> {
        @NotNull
        private final List<MyWeightItem> myItems = new ArrayList<MyWeightItem>();
        @Nullable
        private MyWeightItem mySelectedItem;

        private MyModel() {
        }

        @Override
        public void setSelectedItem(Object anItem) {
            if (anItem instanceof MyWeightItem) {
                this.mySelectedItem = (MyWeightItem)anItem;
            } else if (anItem instanceof String) {
                this.mySelectedItem = (MyWeightItem)ContainerUtil.find(this.myItems, item -> item.subFamily.equals(anItem));
            }
        }

        @Override
        public Object getSelectedItem() {
            return this.mySelectedItem;
        }

        @Override
        public int getSize() {
            return this.myItems.size();
        }

        @Override
        public MyWeightItem getElementAt(int index) {
            return this.myItems.get(index);
        }

        private void update(@NotNull FontPreferences currPreferences) {
            if (currPreferences == null) {
                MyModel.$$$reportNull$$$0(0);
            }
            this.myItems.clear();
            String currFamily = currPreferences.getFontFamily();
            String recommended = FontWeightCombo.this.getRecommendedSubFamily(currFamily);
            FontFamilyService.getSubFamilies((String)currFamily).forEach(subFamily -> this.myItems.add(new MyWeightItem((String)subFamily, subFamily.equals(recommended))));
            String subFamily2 = FontWeightCombo.this.getSubFamily(currPreferences);
            this.setSelectedItem(subFamily2 != null ? subFamily2 : recommended);
            this.fireContentsChanged(this, -1, -1);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "currPreferences", "com/intellij/application/options/editor/fonts/FontWeightCombo$MyModel", "update"));
        }
    }

    static final class MyWeightItem {
        @NlsSafe
        @NotNull
        public final String subFamily;
        public final boolean isRecommended;

        MyWeightItem(@NotNull String subFamily, boolean isRecommended) {
            if (subFamily == null) {
                MyWeightItem.$$$reportNull$$$0(0);
            }
            this.subFamily = subFamily;
            this.isRecommended = isRecommended;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "subFamily", "com/intellij/application/options/editor/fonts/FontWeightCombo$MyWeightItem", "<init>"));
        }
    }
}

