/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diagnostic.hprof.util;

import com.intellij.diagnostic.hprof.util.FileBackedHashMap;
import com.intellij.diagnostic.hprof.util.IntList;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0007\u0018\u0000 \f2\u00020\u0001:\u0001\fB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0011\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0007H\u0096\u0002J\u0019\u0010\t\u001a\u00020\n2\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\u0007H\u0096\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/intellij/diagnostic/hprof/util/FileBackedIntList;", "Lcom/intellij/diagnostic/hprof/util/IntList;", "buffer", "Ljava/nio/ByteBuffer;", "<init>", "(Ljava/nio/ByteBuffer;)V", "get", "", "index", "set", "", "value", "Companion", "intellij.platform.ide.impl"})
@ApiStatus.Internal
public final class FileBackedIntList
implements IntList {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ByteBuffer buffer;

    public FileBackedIntList(@NotNull ByteBuffer buffer2) {
        Intrinsics.checkNotNullParameter((Object)buffer2, (String)"buffer");
        this.buffer = buffer2;
    }

    @Override
    public int get(int index) {
        this.buffer.position(index * 4);
        return this.buffer.getInt();
    }

    @Override
    public void set(int index, int value) {
        this.buffer.position(index * 4);
        this.buffer.putInt(value);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t\u00a8\u0006\n"}, d2={"Lcom/intellij/diagnostic/hprof/util/FileBackedIntList$Companion;", "", "<init>", "()V", "createEmpty", "Lcom/intellij/diagnostic/hprof/util/IntList;", "channel", "Ljava/nio/channels/FileChannel;", "size", "", "intellij.platform.ide.impl"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final IntList createEmpty(@NotNull FileChannel channel, long size2) {
            Intrinsics.checkNotNullParameter((Object)channel, (String)"channel");
            FileBackedHashMap.Companion.createEmptyFile(channel, size2 * (long)4);
            MappedByteBuffer mappedByteBuffer = channel.map(FileChannel.MapMode.READ_WRITE, 0L, channel.size());
            Intrinsics.checkNotNullExpressionValue((Object)mappedByteBuffer, (String)"map(...)");
            return new FileBackedIntList(mappedByteBuffer);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

