/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.featureStatistics.fusCollectors;

import it.unimi.dsi.fastutil.ints.Int2LongMap;
import it.unimi.dsi.fastutil.ints.Int2LongOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0016\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00032\u0006\u0010\u000f\u001a\u00020\u0005J\u000e\u0010\u0010\u001a\u00020\u00032\u0006\u0010\u000f\u001a\u00020\u0005J\u0015\u0010\u0011\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u000f\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0012J\u0018\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u000e\u001a\u00020\u00032\u0006\u0010\u000f\u001a\u00020\u0005H\u0002J\u0010\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u000f\u001a\u00020\u0005H\u0002J\b\u0010\u0016\u001a\u00020\u0014H\u0002J\u0010\u0010\u0017\u001a\u00020\u00142\u0006\u0010\u000f\u001a\u00020\u0005H\u0002J\b\u0010\u0018\u001a\u00020\u0014H\u0002J\u0018\u0010\u0019\u001a\u00020\u00142\u0006\u0010\u000e\u001a\u00020\u00032\u0006\u0010\u001a\u001a\u00020\u0005H\u0002J0\u0010\u001b\u001a\u0004\u0018\u0001H\u001c\"\u0004\b\u0000\u0010\u001c2\u0018\u0010\u001d\u001a\u0014\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u0002H\u001c0\u001eH\u0082\b\u00a2\u0006\u0002\u0010\u001fJ\u0018\u0010 \u001a\u00020\r2\u0006\u0010\u001a\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u0005H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lcom/intellij/featureStatistics/fusCollectors/EventsIdentityThrottle;", "", "maxSize", "", "timeout", "", "<init>", "(IJ)V", "identities", "Lit/unimi/dsi/fastutil/ints/Int2LongOpenHashMap;", "oldestIdentityCache", "oldestTimestampCache", "tryPass", "", "identity", "now", "size", "getOldest", "(J)Ljava/lang/Integer;", "put", "", "clearObsolete", "clearOldest", "doClearObsolete", "updateOldest", "takeIntoAccountInOldest", "timestamp", "withOldest", "T", "identityAndTimestamp", "Lkotlin/Function2;", "(Lkotlin/jvm/functions/Function2;)Ljava/lang/Object;", "isObsolete", "intellij.platform.ide.impl"})
@SourceDebugExtension(value={"SMAP\nEventsIdentityThrottle.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EventsIdentityThrottle.kt\ncom/intellij/featureStatistics/fusCollectors/EventsIdentityThrottle\n*L\n1#1,96:1\n89#1,4:97\n89#1,4:101\n89#1,4:105\n*S KotlinDebug\n*F\n+ 1 EventsIdentityThrottle.kt\ncom/intellij/featureStatistics/fusCollectors/EventsIdentityThrottle\n*L\n40#1:97,4\n49#1:101,4\n57#1:105,4\n*E\n"})
public final class EventsIdentityThrottle {
    private final int maxSize;
    private final long timeout;
    @NotNull
    private final Int2LongOpenHashMap identities;
    private int oldestIdentityCache;
    private long oldestTimestampCache;

    public EventsIdentityThrottle(int maxSize, long timeout) {
        this.maxSize = maxSize;
        this.timeout = timeout;
        this.identities = new Int2LongOpenHashMap(this.maxSize);
        this.oldestTimestampCache = Long.MAX_VALUE;
    }

    public final synchronized boolean tryPass(int identity, long now) {
        this.clearObsolete(now);
        if (this.identities.containsKey(identity)) {
            return false;
        }
        if (this.identities.size() == this.maxSize) {
            this.clearOldest();
        }
        this.put(identity, now);
        return true;
    }

    public final synchronized int size(long now) {
        this.clearObsolete(now);
        return this.identities.size();
    }

    @Nullable
    public final synchronized Integer getOldest(long now) {
        Integer n;
        this.clearObsolete(now);
        EventsIdentityThrottle this_$iv = this;
        boolean $i$f$withOldest = false;
        if (this_$iv.oldestTimestampCache != Long.MAX_VALUE) {
            long cfr_ignored_0 = this_$iv.oldestTimestampCache;
            int oldestIdentity = this_$iv.oldestIdentityCache;
            boolean bl = false;
            n = oldestIdentity;
        } else {
            n = null;
        }
        return n;
    }

    private final void put(int identity, long now) {
        this.identities.put(identity, now);
        this.takeIntoAccountInOldest(identity, now);
    }

    /*
     * WARNING - void declaration
     */
    private final void clearObsolete(long now) {
        block1: {
            void oldestTimestamp;
            EventsIdentityThrottle this_$iv = this;
            boolean $i$f$withOldest = false;
            if (this_$iv.oldestTimestampCache == Long.MAX_VALUE) break block1;
            int cfr_ignored_0 = this_$iv.oldestIdentityCache;
            long l = this_$iv.oldestTimestampCache;
            boolean bl = false;
            if (this.isObsolete((long)oldestTimestamp, now)) {
                this.doClearObsolete(now);
            }
        }
    }

    private final void clearOldest() {
        block0: {
            EventsIdentityThrottle this_$iv = this;
            boolean $i$f$withOldest = false;
            if (this_$iv.oldestTimestampCache == Long.MAX_VALUE) break block0;
            long cfr_ignored_0 = this_$iv.oldestTimestampCache;
            int oldestIdentity = this_$iv.oldestIdentityCache;
            boolean bl = false;
            this.identities.remove(oldestIdentity);
            this.updateOldest();
        }
    }

    private final void doClearObsolete(long now) {
        ObjectIterator objectIterator = this.identities.int2LongEntrySet().fastIterator();
        Intrinsics.checkNotNullExpressionValue((Object)objectIterator, (String)"fastIterator(...)");
        ObjectIterator objectIterator2 = objectIterator;
        while (((Iterator)objectIterator2).hasNext()) {
            Int2LongMap.Entry entry = (Int2LongMap.Entry)objectIterator2.next();
            if (!this.isObsolete(entry.getLongValue(), now)) continue;
            this.identities.remove(entry.getIntKey());
        }
        this.updateOldest();
    }

    private final void updateOldest() {
        this.oldestTimestampCache = Long.MAX_VALUE;
        ObjectIterator objectIterator = this.identities.int2LongEntrySet().fastIterator();
        Intrinsics.checkNotNullExpressionValue((Object)objectIterator, (String)"fastIterator(...)");
        ObjectIterator objectIterator2 = objectIterator;
        while (((Iterator)objectIterator2).hasNext()) {
            Int2LongMap.Entry entry = (Int2LongMap.Entry)objectIterator2.next();
            this.takeIntoAccountInOldest(entry.getIntKey(), entry.getLongValue());
        }
    }

    private final void takeIntoAccountInOldest(int identity, long timestamp) {
        if (timestamp <= this.oldestTimestampCache) {
            this.oldestIdentityCache = identity;
            this.oldestTimestampCache = timestamp;
        }
    }

    private final <T> T withOldest(Function2<? super Integer, ? super Long, ? extends T> identityAndTimestamp) {
        boolean $i$f$withOldest = false;
        if (this.oldestTimestampCache != Long.MAX_VALUE) {
            return (T)identityAndTimestamp.invoke((Object)this.oldestIdentityCache, (Object)this.oldestTimestampCache);
        }
        return null;
    }

    private final boolean isObsolete(long timestamp, long now) {
        return timestamp + this.timeout <= now;
    }
}

